/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.hover;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.Range;
import org.eclipse.mylyn.wikitext.markdown.MarkdownLanguage;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class LSBasedHover
implements ITextHover,
ITextHoverExtension {
    private static final MarkupParser MARKDOWN_PARSER = new MarkupParser((MarkupLanguage)new MarkdownLanguage());
    private CompletableFuture<Hover> hoverRequest;
    private IRegion lastRegion;
    private ITextViewer textViewer;

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (textViewer == null || hoverRegion == null) {
            return null;
        }
        if (!hoverRegion.equals(this.lastRegion) || !textViewer.equals(this.textViewer) || this.hoverRequest == null) {
            this.initiateHoverRequest(textViewer, hoverRegion.getOffset());
        }
        if (this.hoverRequest == null) {
            return null;
        }
        Hover hoverResult = null;
        try {
            hoverResult = this.hoverRequest.get(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError(e);
        }
        if (hoverResult == null) {
            return null;
        }
        List contents = hoverResult.getContents();
        if (contents == null || contents.isEmpty()) {
            return null;
        }
        String result = contents.stream().map(content -> {
            if (content.isLeft()) {
                return (String)content.getLeft();
            }
            if (content.isRight()) {
                MarkedString markedString = (MarkedString)content.getRight();
                if (markedString.getLanguage() != null && !markedString.getLanguage().isEmpty()) {
                    return String.format("```%s\n%s\n```", markedString.getLanguage(), markedString.getValue());
                }
                return markedString.getValue();
            }
            return "";
        }).filter(line -> !line.isEmpty()).collect(Collectors.joining("\n\n"));
        if (result.isEmpty()) {
            return null;
        }
        result = MARKDOWN_PARSER.parseToHtml(result);
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        Color foreground = colorRegistry.get("org.eclipse.ui.workbench.HOVER_FOREGROUND");
        Color background = colorRegistry.get("org.eclipse.ui.workbench.HOVER_BACKGROUND");
        String style = "<style TYPE='text/css'>html { font-family: " + JFaceResources.getDefaultFontDescriptor().getFontData()[0].getName() + "; " + "font-size: " + Integer.toString(JFaceResources.getDefaultFontDescriptor().getFontData()[0].getHeight()) + "pt; " + (background != null ? "background-color: " + LSBasedHover.toHTMLrgb(background.getRGB()) + "; " : "") + (foreground != null ? "color: " + LSBasedHover.toHTMLrgb(foreground.getRGB()) + "; " : "") + " }</style>";
        int headIndex = result.indexOf("<head>");
        StringBuilder builder = new StringBuilder(result.length() + style.length());
        builder.append(result.substring(0, headIndex + "<head>".length()));
        builder.append(style);
        builder.append(result.substring(headIndex + "<head>".length()));
        return builder.toString();
    }

    private static String toHTMLrgb(RGB rgb) {
        StringBuilder builder = new StringBuilder(7);
        builder.append('#');
        LSBasedHover.appendAsHexString(builder, rgb.red);
        LSBasedHover.appendAsHexString(builder, rgb.green);
        LSBasedHover.appendAsHexString(builder, rgb.blue);
        return builder.toString();
    }

    private static void appendAsHexString(StringBuilder buffer, int intValue) {
        String hexValue = Integer.toHexString(intValue);
        if (hexValue.length() == 1) {
            buffer.append('0');
        }
        buffer.append(hexValue);
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer == null) {
            return null;
        }
        Region res = new Region(offset, 0);
        LanguageServiceAccessor.LSPDocumentInfo info = LanguageServiceAccessor.getLSPDocumentInfoFor(textViewer, capabilities -> Boolean.TRUE.equals(capabilities.getHoverProvider()));
        if (info != null) {
            try {
                this.initiateHoverRequest(textViewer, offset);
                Hover hover = this.hoverRequest.get(800L, TimeUnit.MILLISECONDS);
                if (hover != null && hover.getRange() != null) {
                    Range range = hover.getRange();
                    int rangeOffset = LSPEclipseUtils.toOffset(range.getStart(), info.getDocument());
                    res = new Region(rangeOffset, LSPEclipseUtils.toOffset(range.getEnd(), info.getDocument()) - rangeOffset);
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException | BadLocationException e) {
                LanguageServerPlugin.logError(e);
                res = new Region(offset, 1);
            }
        } else {
            res = new Region(offset, 1);
        }
        this.lastRegion = res;
        this.textViewer = textViewer;
        return res;
    }

    private void initiateHoverRequest(@NonNull ITextViewer viewer, int offset) {
        this.textViewer = viewer;
        LanguageServiceAccessor.LSPDocumentInfo info = LanguageServiceAccessor.getLSPDocumentInfoFor(viewer, capabilities -> Boolean.TRUE.equals(capabilities.getHoverProvider()));
        if (info != null) {
            try {
                this.hoverRequest = info.getLanguageClient().getTextDocumentService().hover(LSPEclipseUtils.toTextDocumentPosistionParams(info.getFileUri(), offset, info.getDocument()));
            }
            catch (BadLocationException e) {
                LanguageServerPlugin.logError(e);
            }
        }
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                if (BrowserInformationControl.isAvailable((Composite)parent)) {
                    return new FocusableBrowserInformationControl(parent);
                }
                return new DefaultInformationControl(parent);
            }
        };
    }

    private static class FocusableBrowserInformationControl
    extends BrowserInformationControl {
        public FocusableBrowserInformationControl(Shell parent) {
            super(parent, "org.eclipse.jface.defaultfont", EditorsUI.getTooltipAffordanceString());
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    BrowserInformationControl res = new BrowserInformationControl(parent, "org.eclipse.jface.defaultfont", true);
                    return res;
                }
            };
        }
    }
}

