/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ContextInformationValidator;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.operations.completion.LSCompletionProposal;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.xbase.lib.Pair;

public class LSContentAssistProcessor
implements IContentAssistProcessor {
    private static final long TRIGGERS_TIMEOUT = 50L;
    private static final long COMPLETION_TIMEOUT = 1000L;
    private LanguageServiceAccessor.LSPDocumentInfo info;
    private LanguageServiceAccessor.LSPDocumentInfo lastCheckedForAutoActiveCharactersInfo;
    private char[] triggerChars;
    private char[] contextTriggerChars;
    private Pair<IDocument, Job> findInfoJob;
    private String errorMessage;

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] res;
        block6: {
            this.checkInfoAndJob(viewer.getDocument());
            if (this.info == null) {
                try {
                    ((Job)this.findInfoJob.getValue()).join(1000L, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (InterruptedException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
            res = new ICompletionProposal[]{};
            CompletableFuture request = null;
            try {
                if (this.info != null) {
                    TextDocumentPositionParams param = LSPEclipseUtils.toTextDocumentPosistionParams(this.info.getFileUri(), offset, this.info.getDocument());
                    request = this.info.getLanguageClient().getTextDocumentService().completion(param);
                    res = this.toProposals(offset, (Either<List<CompletionItem>, CompletionList>)((Either)request.get()));
                }
            }
            catch (Exception ex) {
                LanguageServerPlugin.logError(ex);
                if (request == null) break block6;
                res = this.toProposals(offset, (Either<List<CompletionItem>, CompletionList>)request.getNow(Either.forLeft(Collections.emptyList())));
                this.errorMessage = ex.getMessage();
            }
        }
        return res;
    }

    private void checkInfoAndJob(@NonNull IDocument refDocument) {
        if (this.info != null && !refDocument.equals(this.info.getDocument())) {
            if (this.findInfoJob != null) {
                ((Job)this.findInfoJob.getValue()).cancel();
                this.findInfoJob = null;
            }
            this.info = null;
        }
        if (this.info == null && this.findInfoJob == null) {
            this.createInfoJob(refDocument);
        }
    }

    private ICompletionProposal[] toProposals(int offset, Either<List<CompletionItem>, CompletionList> completionList) {
        if (completionList == null) {
            return new ICompletionProposal[0];
        }
        List items = Collections.emptyList();
        if (completionList.isLeft()) {
            items = (List)completionList.getLeft();
        } else if (completionList.isRight()) {
            items = ((CompletionList)completionList.getRight()).getItems();
        }
        ArrayList<LSCompletionProposal> proposals = new ArrayList<LSCompletionProposal>();
        for (CompletionItem item : items) {
            LSCompletionProposal proposal;
            if (item == null || !(proposal = new LSCompletionProposal(item, offset, this.info)).validate(this.info.getDocument(), offset, null)) continue;
            proposals.add(proposal);
        }
        proposals.sort((o1, o2) -> {
            if (o1.getBestOffset() < o2.getBestOffset()) {
                return -1;
            }
            if (o1.getBestOffset() > o2.getBestOffset()) {
                return 1;
            }
            if (o1.getNumberOfModifsBeforeOffset() < o2.getNumberOfModifsBeforeOffset()) {
                return -1;
            }
            if (o1.getNumberOfModifsBeforeOffset() > o2.getNumberOfModifsBeforeOffset()) {
                return 1;
            }
            String c1 = o1.getSortText();
            String c2 = o2.getSortText();
            if (c1 == null) {
                return -1;
            }
            return c1.compareToIgnoreCase(c2);
        });
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        this.checkInfoAndJob(viewer.getDocument());
        if (this.info == null) {
            try {
                ((Job)this.findInfoJob.getValue()).join(1000L, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        if (this.info == null) {
            return new IContextInformation[0];
        }
        ArrayList<ContextInformation> contextInformations = new ArrayList<ContextInformation>();
        try {
            TextDocumentPositionParams param = LSPEclipseUtils.toTextDocumentPosistionParams(this.info.getFileUri(), offset, this.info.getDocument());
            SignatureHelp signatureHelp = (SignatureHelp)this.info.getLanguageClient().getTextDocumentService().signatureHelp(param).get();
            for (SignatureInformation information : signatureHelp.getSignatures()) {
                StringBuilder signature = new StringBuilder(information.getLabel());
                if (information.getDocumentation() != null && !information.getDocumentation().isEmpty()) {
                    signature.append('\n').append(information.getDocumentation());
                }
                contextInformations.add(new ContextInformation(information.getLabel(), signature.toString()));
            }
        }
        catch (InterruptedException | ExecutionException | BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
        return contextInformations.toArray(new IContextInformation[0]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        this.collectAutoActivationCharacters();
        return this.triggerChars;
    }

    private void collectAutoActivationCharacters() {
        this.checkInfoAndJob(LSPEclipseUtils.getDocument((ITextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()));
        if (this.info == null) {
            try {
                ((Job)this.findInfoJob.getValue()).join(50L, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException | OperationCanceledException e) {
                LanguageServerPlugin.logError(e);
            }
        }
        if (this.info != null && this.info != this.lastCheckedForAutoActiveCharactersInfo) {
            ServerCapabilities currentCapabilites = this.info.getCapabilites();
            if (currentCapabilites == null) {
                return;
            }
            if (currentCapabilites.getCompletionProvider() != null) {
                this.triggerChars = this.collectCharacters(currentCapabilites.getCompletionProvider().getTriggerCharacters());
            }
            if (currentCapabilites.getSignatureHelpProvider() != null) {
                this.contextTriggerChars = this.collectCharacters(currentCapabilites.getSignatureHelpProvider().getTriggerCharacters());
            }
            this.lastCheckedForAutoActiveCharactersInfo = this.info;
        }
    }

    private char[] collectCharacters(@Nullable List<String> triggerCharacters) {
        if (triggerCharacters == null || triggerCharacters.isEmpty()) {
            return null;
        }
        ArrayList<Character> chars = new ArrayList<Character>();
        for (String s : triggerCharacters) {
            if (s.length() != 1) continue;
            chars.add(Character.valueOf(s.charAt(0)));
        }
        char[] triggerChars = new char[chars.size()];
        int i = 0;
        for (Character c : chars) {
            triggerChars[i] = c.charValue();
            ++i;
        }
        return triggerChars;
    }

    private void createInfoJob(final @NonNull IDocument document) {
        Job job = new Job("[Completion] Find Language Server"){

            protected IStatus run(IProgressMonitor monitor) {
                LSContentAssistProcessor.this.info = LanguageServiceAccessor.getLSPDocumentInfoFor(document, capabilities -> capabilities.getCompletionProvider() != null);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.setUser(false);
        job.schedule();
        this.findInfoJob = new Pair((Object)document, (Object)job);
    }

    public char[] getContextInformationAutoActivationCharacters() {
        this.collectAutoActivationCharacters();
        return this.contextTriggerChars;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new ContextInformationValidator((IContentAssistProcessor)this);
    }
}

