/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerExit;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainerState;
import org.eclipse.linuxtools.docker.ui.launch.Messages;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;

public class ContainerCommandProcess
extends Process {
    private String containerId;
    private IDockerConnection connection;
    private String imageName;
    private PipedInputStream stdout;
    private PipedInputStream stderr;
    private Set<String> remoteVolumes;
    private boolean keepContainer;
    private Thread thread;

    public ContainerCommandProcess(IDockerConnection connection, String imageName, String containerId, Set<String> remoteVolumes, boolean keepContainer) {
        this.connection = connection;
        this.imageName = imageName;
        this.containerId = containerId;
        this.remoteVolumes = remoteVolumes;
        this.stdout = new PipedInputStream();
        this.stderr = new PipedInputStream();
        this.keepContainer = keepContainer;
        Runnable logContainer = () -> {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    PipedOutputStream pipedStdout = new PipedOutputStream(this.stdout);
                    try {
                        try (PipedOutputStream pipedStderr = new PipedOutputStream(this.stderr);){
                            connection.attachLog(containerId, (OutputStream)pipedStdout, (OutputStream)pipedStderr);
                            pipedStdout.flush();
                            pipedStderr.flush();
                        }
                        if (pipedStdout == null) return;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (pipedStdout == null) throw throwable;
                        pipedStdout.close();
                        throw throwable;
                    }
                    pipedStdout.close();
                    return;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException | InterruptedException | DockerException throwable) {
                // empty catch block
            }
        };
        this.thread = new Thread(logContainer);
        this.thread.start();
    }

    @Override
    public void destroy() {
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.stdout.close();
            this.stderr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.thread.interrupt();
    }

    @Override
    public int exitValue() {
        IDockerContainerState state;
        IDockerContainerInfo info = this.connection.getContainerInfo(this.containerId);
        if (info != null && (state = info.state()) != null) {
            if (state.paused().booleanValue() || state.restarting().booleanValue() || state.running().booleanValue()) {
                throw new IllegalThreadStateException(LaunchMessages.getFormattedString("ContainerNotFinished.msg", this.containerId));
            }
            return state.exitCode();
        }
        return -1;
    }

    @Override
    public InputStream getErrorStream() {
        return this.stderr;
    }

    @Override
    public InputStream getInputStream() {
        return this.stdout;
    }

    @Override
    public OutputStream getOutputStream() {
        return new ByteArrayOutputStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        try {
            IDockerContainerExit exit = this.connection.waitForContainer(this.containerId);
            this.connection.stopLoggingThread(this.containerId);
            if (!this.keepContainer) {
                this.connection.removeContainer(this.containerId);
            }
            if (!((DockerConnection)this.connection).isLocal()) {
                CopyVolumesFromImageJob job = new CopyVolumesFromImageJob(this.connection, this.imageName, this.remoteVolumes);
                job.schedule();
                job.join();
            }
            return exit.statusCode();
        }
        catch (DockerException e) {
            return -1;
        }
    }

    public String getImage() {
        return this.imageName;
    }

    private class BlockingInputStream
    extends InputStream {
        private InputStream in;

        public BlockingInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }
    }

    private class CopyVolumesFromImageJob
    extends Job {
        private static final String COPY_VOLUMES_FROM_JOB_TITLE = "ContainerLaunch.copyVolumesFromJob.title";
        private static final String COPY_VOLUMES_FROM_DESC = "ContainerLaunch.copyVolumesFromJob.desc";
        private static final String COPY_VOLUMES_FROM_TASK = "ContainerLaunch.copyVolumesFromJob.task";
        private final Set<String> remoteVolumes;
        private final IDockerConnection connection;
        private final String imageName;

        public CopyVolumesFromImageJob(IDockerConnection connection, String imageName, Set<String> remoteVolumes) {
            super(Messages.getString(COPY_VOLUMES_FROM_JOB_TITLE));
            this.remoteVolumes = remoteVolumes;
            this.connection = connection;
            this.imageName = imageName;
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 27[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

