/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.internal.editor.text.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class LuaMultLineStringRule
implements IPredicateRule {
    protected int readCount;
    protected IToken returnToken;
    private IToken fDefaultToken;

    public LuaMultLineStringRule(IToken stringToken) {
        this.fDefaultToken = stringToken;
    }

    public IToken getSuccessToken() {
        return this.fDefaultToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        this.readCount = 0;
        this.returnToken = this.fDefaultToken;
        IToken result = this.doEvaluate(scanner);
        if (result.isUndefined()) {
            while (this.readCount > 0) {
                scanner.unread();
                --this.readCount;
            }
        }
        return result;
    }

    protected IToken doEvaluate(ICharacterScanner scanner) {
        int equalsNumber = 0;
        int c = scanner.read();
        ++this.readCount;
        if (c == 91) {
            c = scanner.read();
            ++this.readCount;
            while (c == 61) {
                ++equalsNumber;
                c = scanner.read();
                ++this.readCount;
            }
            if (c != 91) {
                return Token.UNDEFINED;
            }
            IToken content = this.doEvaluateContent(scanner);
            if (content.isUndefined()) {
                return content;
            }
            c = scanner.read();
            while (c != -1) {
                boolean missed = false;
                if (c == 93) {
                    c = scanner.read();
                    ++this.readCount;
                    int i = 0;
                    while (i < equalsNumber) {
                        if (c != 61) {
                            missed = true;
                            break;
                        }
                        c = scanner.read();
                        ++this.readCount;
                        ++i;
                    }
                    if (missed) continue;
                    if (c == 93) {
                        return this.returnToken;
                    }
                    c = scanner.read();
                    ++this.readCount;
                    continue;
                }
                c = scanner.read();
                ++this.readCount;
            }
            scanner.unread();
            return this.returnToken;
        }
        return Token.UNDEFINED;
    }

    protected IToken doEvaluateContent(ICharacterScanner scanner) {
        int c;
        do {
            c = scanner.read();
            ++this.readCount;
        } while (c != 93 && c != -1);
        scanner.unread();
        --this.readCount;
        return this.returnToken;
    }
}

