/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.actions.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jwt.we.editors.actions.WEActionHandler;
import org.eclipse.jwt.we.editors.pages.activityEditor.internal.IActivityEditor;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.jwt.we.parts.core.NodeModelElementEditPart;
import org.eclipse.jwt.we.parts.processes.ScopeEditPart;
import org.eclipse.ui.IWorkbenchPart;

public final class GridHandler
extends WEActionHandler {
    private boolean gridSnap = PreferenceReader.gridSnap.get();
    private boolean gridVisible = PreferenceReader.gridVisible.get();
    private final int GRID_VISIBILITY = 0;
    private final int GRID_SNAP_AUTOMATICALLY = 1;
    private final int GRID_SNAP_NOW = 2;
    private final int GRID_SNAP_NOW_CENTERED = 3;

    public GridHandler() {
        super(true);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (GeneralHelper.getActiveInstance() == null || !(GeneralHelper.getActiveInstance().getActiveEditor() instanceof IActivityEditor)) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    private int getCommandType(ExecutionEvent event) {
        String commandId = "";
        try {
            commandId = event.getCommand().getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        if (commandId.equals("org.eclipse.jwt.we.gridSnapCommand")) {
            return 1;
        }
        if (commandId.equals("org.eclipse.jwt.we.gridVisibleCommand")) {
            return 0;
        }
        if (commandId.equals("org.eclipse.jwt.we.gridSnapNowCornerCommand")) {
            return 2;
        }
        if (commandId.equals("org.eclipse.jwt.we.gridSnapNowCenteredCommand")) {
            return 3;
        }
        return 0;
    }

    private void toggleGridSnap() {
        this.gridSnap = !this.gridSnap;
        PreferenceReader.gridSnap.set(this.gridSnap);
    }

    private void toggleGridVisible() {
        this.gridVisible = !this.gridVisible;
        PreferenceReader.gridVisible.set(this.gridVisible);
    }

    private Rectangle alignToGridCenteredHelp(Rectangle constraint, int gridWidth, int gridHeight) {
        Rectangle result = new Rectangle(constraint);
        int middleX = result.x + result.width / 2;
        int middleY = result.y + result.height / 2;
        int x_mod = middleX % gridWidth;
        middleX -= x_mod;
        if (x_mod > gridWidth / 2) {
            middleX += gridWidth;
        }
        int y_mod = middleY % gridHeight;
        middleY -= y_mod;
        if (y_mod > gridHeight / 2) {
            middleY += gridHeight;
        }
        result.x = middleX - result.width / 2;
        result.y = middleY - result.height / 2;
        return result;
    }

    private void alignToGridCentered() {
        EditPart rootEditPart = GeneralHelper.getActiveInstance().getCurrentActivitySheet().getRootEditPart().getContents();
        if (!(rootEditPart instanceof ScopeEditPart)) {
            return;
        }
        ScopeEditPart scopeEditPart = (ScopeEditPart)rootEditPart;
        int gridWidth = PreferenceReader.gridWidth.get();
        int gridHeight = PreferenceReader.gridHeight.get();
        CompoundCommand compoundCommand = new CompoundCommand();
        int i = 0;
        while (i < scopeEditPart.getChildren().size()) {
            if (scopeEditPart.getChildren().get(i) instanceof NodeModelElementEditPart) {
                NodeModelElementEditPart nodeEditPart = (NodeModelElementEditPart)scopeEditPart.getChildren().get(i);
                Rectangle oldConstraint = nodeEditPart.getFigure().getBounds();
                Rectangle newConstraint = this.alignToGridCenteredHelp(oldConstraint, gridWidth, gridHeight);
                int deltaX = newConstraint.x - oldConstraint.x;
                int deltaY = newConstraint.y - oldConstraint.y;
                ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"resize children");
                request.setMoveDelta(new Point(deltaX, deltaY));
                request.setEditParts((EditPart)nodeEditPart);
                compoundCommand.add(scopeEditPart.getCommand((Request)request));
            }
            ++i;
        }
        GeneralHelper.getActiveInstance().getEditDomain().getCommandStack().execute((Command)compoundCommand);
    }

    private Rectangle alignToGridCornerHelp(Rectangle constraint, int gridWidth, int gridHeight) {
        Rectangle result = new Rectangle(constraint);
        int x_mod = result.x % gridWidth;
        result.x -= x_mod;
        if (x_mod > gridWidth / 2) {
            result.x += gridWidth;
        }
        int y_mod = result.y % gridHeight;
        result.y -= y_mod;
        if (y_mod > gridHeight / 2) {
            result.y += gridHeight;
        }
        return result;
    }

    private void alignToGridCorner() {
        EditPart rootEditPart = GeneralHelper.getActiveInstance().getCurrentActivitySheet().getRootEditPart().getContents();
        if (!(rootEditPart instanceof ScopeEditPart)) {
            return;
        }
        ScopeEditPart scopeEditPart = (ScopeEditPart)rootEditPart;
        int gridWidth = PreferenceReader.gridWidth.get();
        int gridHeight = PreferenceReader.gridHeight.get();
        CompoundCommand compoundCommand = new CompoundCommand();
        int i = 0;
        while (i < scopeEditPart.getChildren().size()) {
            if (scopeEditPart.getChildren().get(i) instanceof NodeModelElementEditPart) {
                NodeModelElementEditPart nodeEditPart = (NodeModelElementEditPart)scopeEditPart.getChildren().get(i);
                Rectangle oldConstraint = nodeEditPart.getFigure().getBounds();
                Rectangle newConstraint = this.alignToGridCornerHelp(oldConstraint, gridWidth, gridHeight);
                int deltaX = newConstraint.x - oldConstraint.x;
                int deltaY = newConstraint.y - oldConstraint.y;
                ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"resize children");
                request.setMoveDelta(new Point(deltaX, deltaY));
                request.setEditParts((EditPart)nodeEditPart);
                compoundCommand.add(scopeEditPart.getCommand((Request)request));
            }
            ++i;
        }
        GeneralHelper.getActiveInstance().getEditDomain().getCommandStack().execute((Command)compoundCommand);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        int commandType = this.getCommandType(event);
        if (commandType == -1) {
            return null;
        }
        switch (commandType) {
            case 0: {
                this.toggleGridVisible();
                break;
            }
            case 1: {
                this.toggleGridSnap();
                break;
            }
            case 2: {
                this.alignToGridCorner();
                break;
            }
            case 3: {
                this.alignToGridCentered();
            }
        }
        return null;
    }
}

