/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.TestDataBP;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.ParamTextPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractNodePropertySource;
import org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.rcp.views.JBPropertiesPage;
import org.eclipse.jubula.client.ui.rcp.views.dataset.DataSetView;
import org.eclipse.jubula.client.ui.rcp.views.dataset.TestDataCubeDataSetPage;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.PropertySheet;

public class JumpToCTDSHandler
extends AbstractHandler {
    public Object executeImpl(ExecutionEvent event) {
        String mined = this.mineString();
        if (mined != null) {
            this.jumpToCTDSEditor(mined);
        }
        return null;
    }

    private String mineString() {
        IViewPart v = Plugin.getActivePage().findView("org.eclipse.ui.views.PropertySheet");
        if (!(v instanceof PropertySheet)) {
            return null;
        }
        PropertySheet p = (PropertySheet)v;
        if (!(p.getCurrentPage() instanceof JBPropertiesPage)) {
            return null;
        }
        ITreeSelection ssel = ((JBPropertiesPage)p.getCurrentPage()).getCurrentTreeSelection();
        if (ssel == null) {
            return null;
        }
        Object f = ssel.getFirstElement();
        if (!(f instanceof ParamTextPropertyDescriptor)) {
            return null;
        }
        ParamTextPropertyDescriptor pd = (ParamTextPropertyDescriptor)f;
        if (!(pd.getId() instanceof AbstractNodePropertySource.AbstractParamValueController)) {
            return null;
        }
        return ((AbstractNodePropertySource.AbstractParamValueController)pd.getId()).getProperty();
    }

    public void jumpToCTDSEditor(String value) {
        String[] best = null;
        int max = 0;
        for (String[] arr : TestDataBP.getAllCTDSReferences((String)value)) {
            int num = 0;
            int i = 0;
            while (i < arr.length) {
                if (arr[i] != null) {
                    ++num;
                }
                ++i;
            }
            if (num <= max) continue;
            best = arr;
            max = num;
        }
        this.openCTDS(best);
    }

    private void openCTDS(String[] data) {
        IProjectPO proj = GeneralStorage.getInstance().getProject();
        IParameterInterfacePO po = TestDataCubeBP.getTestDataCubeByName((String)data[0], (IProjectPO)proj);
        if (po == null) {
            return;
        }
        IEditorPart part = AbstractOpenHandler.openEditor((IPersistentObject)proj.getTestDataCubeCont());
        if (!(part instanceof CentralTestDataEditor) || data[1] == null || data[2] == null) {
            return;
        }
        CentralTestDataEditor ctdsEd = (CentralTestDataEditor)part;
        po = (IParameterInterfacePO)ctdsEd.getEntityManager().find(po.getClass(), (Object)po.getId());
        ctdsEd.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)po));
        IViewPart view = Plugin.showView("org.eclipse.jubula.client.ui.rcp.views.DataSetView");
        if (!(view instanceof DataSetView)) {
            return;
        }
        IPage page = ((DataSetView)view).getCurrentPage();
        if (!(page instanceof TestDataCubeDataSetPage)) {
            return;
        }
        ((TestDataCubeDataSetPage)page).navigateToCell(data[1], data[2], data[3]);
    }
}

