/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.handlers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.dot.internal.DotExecutableUtils;
import org.eclipse.gef.dot.internal.DotFileUtils;
import org.eclipse.gef.dot.internal.ui.GraphvizPreferencePage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class SyncGraphvizExportHandler
extends AbstractHandler {
    private static final String EXTENSION = "dot";
    private IPartListener2 partListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            SyncGraphvizExportHandler.this.checkActiveEditorAndExportGraph(part);
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };
    private IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() != 16 && event.getType() != 1) {
                return;
            }
            IResourceDelta rootDelta = event.getDelta();
            try {
                rootDelta.accept(SyncGraphvizExportHandler.this.resourceDeltaVisitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    };
    private IResourceDeltaVisitor resourceDeltaVisitor = new IResourceDeltaVisitor(){

        public boolean visit(IResourceDelta delta) {
            IResource resource = delta.getResource();
            if (resource.getType() == 1 && ((IFile)resource).getName().endsWith(SyncGraphvizExportHandler.EXTENSION)) {
                try {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    if (!workspace.isTreeLocked()) {
                        IFile file = (IFile)resource;
                        workspace.run((IWorkspaceRunnable)new DotExportRunnable(file), null);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
    };

    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        Event event = (Event)executionEvent.getTrigger();
        ToolItem toolItem = (ToolItem)event.widget;
        if (toolItem.getSelection()) {
            if (!GraphvizPreferencePage.isGraphvizConfigured()) {
                GraphvizPreferencePage.showGraphvizConfigurationDialog();
            }
            if (!GraphvizPreferencePage.isGraphvizConfigured()) {
                toolItem.setSelection(false);
                return null;
            }
            this.addListeners();
            IEditorPart activeEditor = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)executionEvent).getActivePage().getActiveEditor();
            this.checkActiveEditorAndExportGraph((IWorkbenchPart)activeEditor);
        } else {
            this.removeListeners();
        }
        return null;
    }

    private void addListeners() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 17);
    }

    private void removeListeners() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().removePartListener(this.partListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
    }

    private void checkActiveEditorAndExportGraph(IWorkbenchPart part) {
        XtextEditor editor;
        if (part instanceof XtextEditor && "org.eclipse.gef.dot.internal.language.Dot".equals((editor = (XtextEditor)part).getLanguageName()) && editor.getEditorInput() instanceof FileEditorInput) {
            IFile file = ((FileEditorInput)editor.getEditorInput()).getFile();
            this.exportGraph(file);
        }
    }

    private void exportGraph(IFile inputFile) {
        File resolvedInputFile = null;
        try {
            resolvedInputFile = DotFileUtils.resolve((URL)inputFile.getLocationURI().toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return;
        }
        String dotExportFormat = GraphvizPreferencePage.getDotExportFormat();
        if (dotExportFormat.isEmpty()) {
            return;
        }
        final String[] outputs = new String[2];
        File outputFile = DotExecutableUtils.renderImage((File)new File(GraphvizPreferencePage.getDotExecutablePath()), (File)resolvedInputFile, (String)dotExportFormat, null, (String[])outputs);
        if (!outputs[1].isEmpty()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Errors from dot call:", (String)outputs[1]);
                }
            });
        }
        if (outputFile != null) {
            this.refreshParent(outputFile);
            this.openFile(outputFile);
        }
    }

    private void refreshParent(File file) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)file.getAbsolutePath())).getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void openFile(File resolvedFile) {
        IPath location = Path.fromOSString((String)resolvedFile.getAbsolutePath());
        final IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        if (registry.isSystemExternalEditorAvailable(file.getName())) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        page.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.ui.systemExternalEditor");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private class DotExportRunnable
    implements IWorkspaceRunnable {
        private IFile file;

        DotExportRunnable(IFile file) {
            this.file = file;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            SyncGraphvizExportHandler.this.exportGraph(this.file);
        }
    }
}

