/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.editors;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.emf.parsley.EmfParsleyActivator;
import org.eclipse.emf.parsley.edit.actionbar.WorkbenchActionBarContributor;
import org.eclipse.emf.parsley.edit.ui.dnd.ViewerDragAndDropHelper;
import org.eclipse.emf.parsley.editors.EmfEditorContentOutlineFactory;
import org.eclipse.emf.parsley.editors.EmfEditorContentOutlinePage;
import org.eclipse.emf.parsley.editors.listeners.ResourceDeltaVisitor;
import org.eclipse.emf.parsley.handlers.OutlineSelectionHandler;
import org.eclipse.emf.parsley.internal.editors.listeners.PartListenerAdapter;
import org.eclipse.emf.parsley.internal.editors.util.ProblemIndicationEContentAdapter;
import org.eclipse.emf.parsley.listeners.AsyncCommandStackListenerClient;
import org.eclipse.emf.parsley.listeners.AsyncCommandStackListenerHelper;
import org.eclipse.emf.parsley.listeners.IEditorMouseListener;
import org.eclipse.emf.parsley.menus.ViewerContextMenuHelper;
import org.eclipse.emf.parsley.resource.ResourceLoader;
import org.eclipse.emf.parsley.util.EmfParsleyUiUtil;
import org.eclipse.emf.parsley.viewers.ViewerFactory;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;

public abstract class EmfAbstractEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker,
AsyncCommandStackListenerClient {
    protected static final int CONTAINER_Y_SIZE_DELTA = 6;
    protected ComposedAdapterFactory adapterFactory;
    protected EmfEditorContentOutlinePage contentOutlinePage;
    protected boolean saving = false;
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();
    protected StructuredViewer selectionViewer;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected IPartListener partListener = new PartListenerAdapter(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == EmfAbstractEditor.this.contentOutlinePage) {
                    EmfAbstractEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)EmfAbstractEditor.this);
                }
            } else if (p instanceof PropertySheet) {
                if (EmfAbstractEditor.this.propertySheetPages.contains(((PropertySheet)p).getCurrentPage())) {
                    EmfAbstractEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)EmfAbstractEditor.this);
                    EmfAbstractEditor.this.handleActivate();
                }
            } else if (p == EmfAbstractEditor.this) {
                EmfAbstractEditor.this.handleActivate();
            }
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new ProblemIndicationEContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        EmfAbstractEditor.this.handleResourceDiagnostic(resource);
                        break;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            EmfAbstractEditor.this.handleIResourceChangeEvent(event);
        }
    };
    @Inject
    protected ViewerFactory viewerFactory;
    @Inject
    protected Provider<IEditorMouseListener> mouseAdapterProvider;
    @Inject
    protected EmfEditorContentOutlineFactory emfContentOutlineFactory;
    @Inject
    protected OutlineSelectionHandler outlineSelectionHandler;
    @Inject
    protected AdapterFactoryEditingDomain editingDomain;
    @Inject
    protected ResourceLoader resourceLoader;
    @Inject
    protected ViewerContextMenuHelper contextMenuHelper;
    @Inject
    protected ViewerDragAndDropHelper dragAndDropHelper;
    @Inject
    private AsyncCommandStackListenerHelper commandStackListenerHelper;
    public static final String ECORE_FILE_EXTENSION = "ecore";
    public static final String EMOF_FILE_EXTENSION = "emof";

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (this.saving) {
            return;
        }
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            this.reloadChangedResources();
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void reloadChangedResources() {
        for (Resource resource : this.changedResources) {
            if (!resource.isLoaded()) continue;
            resource.unload();
            try {
                resource.load(Collections.emptyMap());
            }
            catch (IOException exception) {
                if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
            }
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = this.createDiagnostic();
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    EcoreEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            this.updateMarkers(diagnostic);
        }
    }

    protected BasicDiagnostic createDiagnostic() {
        BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.ecore.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
        for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
            if (childDiagnostic.getSeverity() == 0) continue;
            diagnostic.add(childDiagnostic);
        }
        return diagnostic;
    }

    protected void updateMarkers(BasicDiagnostic diagnostic) {
        if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
            this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
            if (diagnostic.getSeverity() != 0) {
                try {
                    this.markerHelper.createMarkers((Diagnostic)diagnostic);
                }
                catch (CoreException exception) {
                    EcoreEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)EmfAbstractEditor.getString("_UI_FileConflict_label"), (String)EmfAbstractEditor.getString("_WARN_FileConflict"));
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = (ComposedAdapterFactory)this.editingDomain.getAdapterFactory();
        this.commandStackListenerHelper.addCommandStackListener((EditingDomain)this.editingDomain, (Widget)this.getSite().getWorkbenchWindow().getShell(), (AsyncCommandStackListenerClient)this);
    }

    public void mostRecentCommandAffectsResource(Command mostRecentCommand) {
        this.firePropertyChange(257);
    }

    public void postCommandStackChanged(Command mostRecentCommand) {
        if (mostRecentCommand != null) {
            this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
        }
        Iterator<PropertySheetPage> i = this.propertySheetPages.iterator();
        while (i.hasNext()) {
            PropertySheetPage propertySheetPage = i.next();
            if (propertySheetPage.getControl().isDisposed()) {
                i.remove();
                continue;
            }
            propertySheetPage.refresh();
        }
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (EmfAbstractEditor.this.selectionViewer != null) {
                        EmfAbstractEditor.this.selectionViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                EmfAbstractEditor.this.setSelection(selectionChangedEvent.getSelection());
            }
        };
    }

    public void createContextMenuFor(StructuredViewer viewer) {
        this.contextMenuHelper.addViewerContextMenu((Viewer)viewer, (IWorkbenchPart)this, (IMenuListener)this, this.getActionBarContributor());
        this.dragAndDropHelper.addDragAndDrop(viewer, (EditingDomain)this.editingDomain);
        IEditorMouseListener listener = this.getMouseAdapter();
        viewer.getControl().addMouseListener((MouseListener)listener);
    }

    protected IEditorMouseListener getMouseAdapter() {
        return (IEditorMouseListener)this.mouseAdapterProvider.get();
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.ecore.editor", 0, EmfAbstractEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.emf.ecore.editor", 0, EmfAbstractEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y + 6);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, EmfAbstractEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                ((CTabFolder)this.getContainer()).setTabHeight(-1);
                Point point = this.getContainer().getSize();
                this.getContainer().setSize(point.x, point.y - 6);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? this.getContentOutlinePage() : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            this.contentOutlinePage = this.emfContentOutlineFactory.create(this);
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EmfAbstractEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public void setSelectionOnRoot(StructuredViewer viewer) {
        if (!this.editingDomain.getResourceSet().getResources().isEmpty()) {
            viewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
        }
    }

    public IPropertySheetPage getPropertySheetPage() {
        ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain){

            public void setSelectionToViewer(List<?> selection) {
                EmfAbstractEditor.this.setSelectionToViewer(selection);
                EmfAbstractEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                EmfAbstractEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        if (this.outlineSelectionHandler.getSelectionViewer() == null) {
            this.outlineSelectionHandler.setSelectionViewer(this.selectionViewer);
        }
        this.outlineSelectionHandler.handleContentOutlineSelection(selection);
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        this.updateProblemIndication = false;
        this.saving = true;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    EmfAbstractEditor.this.performSave(saveOptions);
                }
            });
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            EcoreEditorPlugin.INSTANCE.log((Object)exception);
        }
        this.saving = false;
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException e) {
            EmfParsleyActivator.logError((String)"EmfAbstractEditor.isPersisted", (Throwable)e);
        }
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        new ResourceDialog(this.getSite().getShell(), null, 0){

            protected boolean isSave() {
                return true;
            }

            protected boolean processResources() {
                List uris = this.getURIs();
                if (!uris.isEmpty()) {
                    URI uri = (URI)uris.get(0);
                    EmfAbstractEditor.this.doSaveAs(uri, (IEditorInput)new URIEditorInput(uri));
                    return true;
                }
                return false;
            }
        }.open();
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException exception) {
            EcoreEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        this.initializeEditingDomain();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = EmfParsleyUiUtil.getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(EmfAbstractEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(EmfAbstractEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(EmfAbstractEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return EcoreEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return EcoreEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public WorkbenchActionBarContributor getActionBarContributor() {
        return (WorkbenchActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    protected boolean showOutlineView() {
        return false;
    }

    public Viewer getViewer() {
        return this.selectionViewer;
    }

    protected void handleResourceDiagnostic(Resource resource) {
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, null);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, diagnostic);
        } else {
            this.resourceToDiagnosticMap.remove(resource);
        }
        if (this.updateProblemIndication) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EmfAbstractEditor.this.updateProblemIndication();
                }
            });
        }
    }

    protected void handleIResourceChangeEvent(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
            visitor.init(this.editingDomain.getResourceSet(), this.savedResources);
            delta.accept((IResourceDeltaVisitor)visitor);
            if (!visitor.getRemovedResources().isEmpty()) {
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EmfAbstractEditor.this.removedResources.addAll(visitor.getRemovedResources());
                        if (!EmfAbstractEditor.this.isDirty()) {
                            EmfAbstractEditor.this.getSite().getPage().closeEditor((IEditorPart)EmfAbstractEditor.this, false);
                        }
                    }
                });
            }
            if (!visitor.getChangedResources().isEmpty()) {
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EmfAbstractEditor.this.changedResources.addAll(visitor.getChangedResources());
                        if (EmfAbstractEditor.this.getSite().getPage().getActiveEditor() == EmfAbstractEditor.this) {
                            EmfAbstractEditor.this.handleActivate();
                        }
                    }
                });
            }
        }
        catch (CoreException exception) {
            EcoreEditorPlugin.INSTANCE.log((Object)exception);
        }
    }

    protected void performSave(Map<Object, Object> saveOptions) {
        boolean first = true;
        for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
            if (!first && resource.getContents().isEmpty() && !this.isPersisted(resource) || this.editingDomain.isReadOnly(resource)) continue;
            try {
                long timeStamp = resource.getTimeStamp();
                resource.save(saveOptions);
                if (resource.getTimeStamp() != timeStamp) {
                    this.savedResources.add(resource);
                }
            }
            catch (Exception exception) {
                this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
            }
            first = false;
        }
    }
}

