/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common.model.impl;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.emfstore.internal.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.internal.common.model.EMFStorePropertyType;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.common.model.ModelPackage;
import org.eclipse.emf.emfstore.internal.common.model.ModelVersion;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.PropertyStringValue;
import org.eclipse.emf.emfstore.internal.common.model.impl.EMFStorePropertyImpl;
import org.eclipse.emf.emfstore.internal.common.model.impl.ModelElementIdImpl;
import org.eclipse.emf.emfstore.internal.common.model.impl.ModelVersionImpl;
import org.eclipse.emf.emfstore.internal.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.impl.PropertyMapEntryImpl;
import org.eclipse.emf.emfstore.internal.common.model.impl.PropertyStringValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelFactoryImpl
extends EFactoryImpl
implements ModelFactory {
    public static ModelFactory init() {
        try {
            ModelFactory theModelFactory = (ModelFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/emf/emfstore/common/model");
            if (theModelFactory != null) {
                return theModelFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ModelFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createProject();
            }
            case 3: {
                return this.createModelElementId();
            }
            case 4: {
                return this.createModelVersion();
            }
            case 7: {
                return this.createEMFStoreProperty();
            }
            case 8: {
                return (EObject)this.createPropertyMapEntry();
            }
            case 9: {
                return this.createPropertyStringValue();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.createEMFStorePropertyTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.convertEMFStorePropertyTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Project createProject() {
        ProjectImpl project = new ProjectImpl();
        return project;
    }

    @Override
    public ModelElementId createModelElementId() {
        ModelElementIdImpl modelElementId = new ModelElementIdImpl();
        return modelElementId;
    }

    @Override
    public ModelVersion createModelVersion() {
        ModelVersionImpl modelVersion = new ModelVersionImpl();
        return modelVersion;
    }

    @Override
    public EMFStoreProperty createEMFStoreProperty() {
        EMFStorePropertyImpl emfStoreProperty = new EMFStorePropertyImpl();
        return emfStoreProperty;
    }

    public Map.Entry<String, EMFStoreProperty> createPropertyMapEntry() {
        PropertyMapEntryImpl propertyMapEntry = new PropertyMapEntryImpl();
        return propertyMapEntry;
    }

    @Override
    public PropertyStringValue createPropertyStringValue() {
        PropertyStringValueImpl propertyStringValue = new PropertyStringValueImpl();
        return propertyStringValue;
    }

    public EMFStorePropertyType createEMFStorePropertyTypeFromString(EDataType eDataType, String initialValue) {
        EMFStorePropertyType result = EMFStorePropertyType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertEMFStorePropertyTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public ModelPackage getModelPackage() {
        return (ModelPackage)this.getEPackage();
    }

    @Deprecated
    public static ModelPackage getPackage() {
        return ModelPackage.eINSTANCE;
    }
}

