/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.helpers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.Messages;
import org.eclipse.emf.diffmerge.api.IComparison;
import org.eclipse.emf.diffmerge.api.IMapping;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.IMergeSelector;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IMergeableDifference;
import org.eclipse.emf.diffmerge.impl.helpers.AbstractExpensiveOperation;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeOperation
extends AbstractExpensiveOperation {
    protected final IComparison _comparison;
    protected final IMergeSelector _merger;
    protected final Collection<? extends IDifference> _toMerge;
    protected final Role _destinationRole;
    protected final boolean _updateReferences;
    protected final Collection<IDifference> _actuallyMerged;

    public MergeOperation(IComparison comparison_p, Collection<? extends IDifference> differences_p, Role destination_p, boolean updateReferences_p) {
        this._comparison = comparison_p;
        this._toMerge = differences_p;
        this._destinationRole = destination_p;
        this._merger = null;
        this._updateReferences = updateReferences_p;
        this._actuallyMerged = new FArrayList();
    }

    public MergeOperation(IComparison comparison_p, IMergeSelector merger_p, boolean updateReferences_p) {
        this._comparison = comparison_p;
        this._toMerge = Collections.emptySet();
        this._destinationRole = null;
        this._merger = merger_p;
        this._updateReferences = updateReferences_p;
        this._actuallyMerged = new FArrayList();
    }

    public Collection<IDifference> getOutput() {
        return Collections.unmodifiableCollection(this._actuallyMerged);
    }

    @Override
    public String getOperationName() {
        return Messages.MergeOperation_Name;
    }

    @Override
    protected int getWorkAmount() {
        int nbDiffs = this.isGlobal() ? this._comparison.getMapping().size() : this._toMerge.size();
        return 1 + nbDiffs + (this._updateReferences ? 1 : 0);
    }

    protected boolean isGlobal() {
        return this._merger != null;
    }

    @Override
    public IStatus run() {
        this.getMonitor().worked(1);
        IStatus result = this.isGlobal() ? this.runOnComparison() : this.runOnSet();
        if (this._updateReferences && result != null && result.isOK()) {
            this.checkProgress();
            IMapping.Editable mapping = (IMapping.Editable)this._comparison.getMapping();
            if (this._destinationRole != null) {
                mapping.completeReferences(this._destinationRole);
            } else {
                mapping.completeReferences(Role.TARGET);
                mapping.completeReferences(Role.REFERENCE);
            }
            this.getMonitor().worked(1);
        }
        return result;
    }

    protected IStatus runOnComparison() {
        for (IMatch match : this._comparison.getMapping().getContents()) {
            for (IDifference difference : match.getAllDifferences()) {
                this.checkProgress();
                Role mergeDirection = this._merger.getMergeDirection(difference);
                if (mergeDirection == null || !difference.canMergeTo(mergeDirection)) continue;
                try {
                    Collection<IDifference> merged = ((IMergeableDifference)difference).mergeTo(mergeDirection);
                    this._actuallyMerged.addAll(merged);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            this.getMonitor().worked(1);
        }
        return Status.OK_STATUS;
    }

    protected IStatus runOnSet() {
        for (IDifference iDifference : this._toMerge) {
            this.checkProgress();
            try {
                if (iDifference instanceof IMergeableDifference) {
                    Collection<IDifference> merged = ((IMergeableDifference)iDifference).mergeTo(this._destinationRole);
                    this._actuallyMerged.addAll(merged);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.getMonitor().worked(1);
        }
        return Status.OK_STATUS;
    }
}

