/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.documentation;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.tcl.internal.ui.documentation.ManPagesLocationsDialog;
import org.eclipse.dltk.tcl.internal.ui.documentation.ManPagesMessages;
import org.eclipse.dltk.tcl.ui.manpages.Documentation;
import org.eclipse.dltk.tcl.ui.manpages.ManPageFolder;
import org.eclipse.dltk.tcl.ui.manpages.ManPageLoader;
import org.eclipse.dltk.tcl.ui.manpages.ManPageResource;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ManPagesLocationsBlock
implements ISelectionChangedListener {
    protected static final String LAST_PATH_SETTING = "LAST_PATH_SETTING";
    protected static final String DIALOG_SETTINGS_PREFIX = "ManPagesLocationsBlock";
    private TreeViewer fLocationsViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fDefaultButton;
    private final IStatusChangeListener fPage;
    private final boolean fEditable;
    private ManPageResource documentations = null;

    public ManPagesLocationsBlock(IStatusChangeListener page, boolean editable) {
        this.fPage = page;
        this.fEditable = editable;
    }

    public Control createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = this.fEditable ? 2 : 1;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        comp.setLayoutData((Object)new GridData(1808));
        this.fLocationsViewer = new TreeViewer(comp);
        GridData gd = new GridData(1808);
        PixelConverter pixConv = new PixelConverter((Control)parent);
        gd.widthHint = pixConv.convertWidthInCharsToPixels(48);
        gd.heightHint = pixConv.convertHeightInCharsToPixels(8);
        this.fLocationsViewer.getControl().setLayoutData((Object)gd);
        this.fLocationsViewer.setContentProvider((IContentProvider)new ManLocationsContentProvider());
        this.fLocationsViewer.setLabelProvider((IBaseLabelProvider)new ManPagesLabelProvider());
        this.fLocationsViewer.setComparator(new ViewerComparator());
        this.fLocationsViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        if (this.fEditable) {
            this.createButtons(comp);
        }
        Dialog.applyDialogFont((Control)comp);
        return comp;
    }

    private void createButtons(Composite comp) {
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        pathButtonComp.setLayoutData((Object)new GridData(258));
        this.fAddButton = this.createPushButton(pathButtonComp, ManPagesMessages.ManPagesLocationsBlock_AddButton);
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManPagesLocationsBlock.this.add();
            }
        });
        this.fEditButton = this.createPushButton(pathButtonComp, ManPagesMessages.ManPagesLocationsBlock_EditButton);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = ManPagesLocationsBlock.this.getSelection();
                if (selection.size() == 1 && selection.getFirstElement() instanceof Documentation) {
                    ManPagesLocationsBlock.this.edit((Documentation)selection.getFirstElement());
                }
            }
        });
        this.fRemoveButton = this.createPushButton(pathButtonComp, ManPagesMessages.ManPagesLocationsBlock_RemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = ManPagesLocationsBlock.this.getSelection();
                if (ManPagesLocationsBlock.this.canRemove(selection)) {
                    ManPagesLocationsBlock.this.remove(selection);
                }
            }
        });
        this.fDefaultButton = this.createPushButton(pathButtonComp, ManPagesMessages.ManPagesLocationsBlock_SetDefaultButton);
        ((GridData)this.fDefaultButton.getLayoutData()).verticalIndent = 16;
        this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = ManPagesLocationsBlock.this.getSelection();
                if (selection.size() == 1 && selection.getFirstElement() instanceof Documentation) {
                    ManPagesLocationsBlock.this.setDefault((Documentation)selection.getFirstElement());
                }
            }
        });
    }

    protected void setDefault(Documentation documentation) {
        documentation.setDefault(true);
        for (Documentation doc : this.documentations.getDocumentations()) {
            if (doc == documentation || !doc.isDefault()) continue;
            doc.setDefault(false);
        }
        this.fLocationsViewer.refresh();
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        ManPagesLocationsBlock.setButtonLayoutData(button);
        return button;
    }

    static void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        int widthHint = 80;
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void update() {
        this.updateButtons();
        this.updatePageStatus(StatusInfo.OK_STATUS);
    }

    protected void updatePageStatus(IStatus status) {
        if (this.fPage == null) {
            return;
        }
        this.fPage.statusChanged(status);
    }

    public void initialize() {
        this.documentations = ManPageLoader.load();
        this.fLocationsViewer.setInput((Object)this.documentations);
        this.fLocationsViewer.expandToLevel(2);
        this.update();
    }

    public void save() throws IOException {
        this.documentations.save(null);
    }

    private Shell getShell() {
        if (this.fPage instanceof IShellProvider) {
            return ((IShellProvider)this.fPage).getShell();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    protected void add() {
        ManPagesLocationsDialog dialog = new ManPagesLocationsDialog(this.getShell(), this.documentations, null);
        if (dialog.open() == 0) {
            Documentation documentation = dialog.getResult();
            this.documentations.checkDefault();
            this.fLocationsViewer.refresh();
            this.fLocationsViewer.setSelection((ISelection)new StructuredSelection((Object)documentation));
        }
    }

    protected void edit(Documentation documentation) {
        ManPagesLocationsDialog dialog = new ManPagesLocationsDialog(this.getShell(), this.documentations, documentation);
        if (dialog.open() == 0) {
            this.fLocationsViewer.refresh((Object)documentation);
        }
    }

    protected void remove(IStructuredSelection selection) {
        boolean changes = false;
        for (Object obj : selection) {
            if (!(obj instanceof EObject)) continue;
            EcoreUtil.remove((EObject)((EObject)obj));
            changes = true;
        }
        if (changes) {
            this.documentations.checkDefault();
            this.fLocationsViewer.refresh();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        if (!this.fEditable) {
            return;
        }
        IStructuredSelection selection = this.getSelection();
        boolean singleDoc = selection.size() == 1 && selection.getFirstElement() instanceof Documentation;
        this.fEditButton.setEnabled(singleDoc);
        this.fDefaultButton.setEnabled(singleDoc && !((Documentation)selection.getFirstElement()).isDefault());
        this.fRemoveButton.setEnabled(this.canRemove(selection));
    }

    protected boolean canRemove(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object obj : selection) {
            if (obj instanceof Documentation) continue;
            return false;
        }
        return true;
    }

    protected IStructuredSelection getSelection() {
        return (IStructuredSelection)this.fLocationsViewer.getSelection();
    }

    private static class ManLocationsContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Documentation) {
                EList<ManPageFolder> folders = ((Documentation)parentElement).getFolders();
                return folders.toArray((Object[])new ManPageFolder[folders.size()]);
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Documentation;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ManPageResource) {
                List<Documentation> docs = ((ManPageResource)inputElement).getDocumentations();
                return docs.toArray(new Object[docs.size()]);
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ManPagesLabelProvider
    extends LabelProvider
    implements IFontProvider {
        public Image getImage(Object element) {
            if (element instanceof Documentation) {
                return DLTKUIPlugin.getImageDescriptorRegistry().get(DLTKPluginImages.DESC_OBJS_JAVADOCTAG);
            }
            if (element instanceof ManPageFolder) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.library_obj.png");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof Documentation) {
                Documentation doc = (Documentation)element;
                String text = doc.getName();
                if (doc.isDefault()) {
                    text = String.valueOf(text) + ManPagesMessages.ManPagesLocationsBlock_DefaultSuffix;
                }
                return text;
            }
            if (element instanceof ManPageFolder) {
                return ((ManPageFolder)element).getPath();
            }
            return super.getText(element);
        }

        public Font getFont(Object element) {
            Documentation doc;
            if (element instanceof Documentation && (doc = (Documentation)element).isDefault()) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }
    }
}

