/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.build;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.ScannerInfoCache;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IncludeExportPatterns;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.core.build.Messages;
import org.eclipse.cdt.internal.core.model.BinaryRunner;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.parser.ParserSettings2;
import org.eclipse.cdt.utils.elf.Elf;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryShared;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class CBuildConfiguration
extends PlatformObject
implements ICBuildConfiguration,
IMarkerGenerator,
IConsoleParser {
    private static final String TOOLCHAIN_TYPE = "cdt.toolChain.type";
    private static final String TOOLCHAIN_ID = "cdt.toolChain.id";
    private static final String TOOLCHAIN_VERSION = "cdt.toolChain.version";
    private static final String LAUNCH_MODE = "cdt.launchMode";
    private static final List<String> DEFAULT_COMMAND = new ArrayList<String>(0);
    private final String name;
    private final IBuildConfiguration config;
    private final IToolChain toolChain;
    private String launchMode;
    private final Map<IResource, List<IScannerInfoChangeListener>> scannerInfoListeners = new HashMap<IResource, List<IScannerInfoChangeListener>>();
    private ScannerInfoCache scannerInfoCache;
    private Map<String, String> properties;
    private boolean infoChanged = false;

    protected CBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        this.config = config;
        this.name = name;
        Preferences settings = this.getSettings();
        String typeId = settings.get(TOOLCHAIN_TYPE, "");
        String id = settings.get(TOOLCHAIN_ID, "");
        String version = settings.get(TOOLCHAIN_VERSION, "");
        IToolChainManager toolChainManager = CCorePlugin.getService(IToolChainManager.class);
        IToolChain tc = toolChainManager.getToolChain(typeId, id, version);
        if (tc == null) {
            Collection<IToolChain> tcs = toolChainManager.getToolChains(typeId, id);
            if (!tcs.isEmpty()) {
                tc = tcs.iterator().next();
            } else {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", String.format(Messages.CBuildConfigurationtoolchainMissing, config.getName())));
            }
        }
        this.toolChain = tc;
        this.launchMode = settings.get(LAUNCH_MODE, null);
    }

    protected CBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        this(config, name, toolChain, "run");
    }

    protected CBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, String launchMode) {
        this.config = config;
        this.name = name;
        this.toolChain = toolChain;
        this.launchMode = launchMode;
        Preferences settings = this.getSettings();
        settings.put(TOOLCHAIN_TYPE, toolChain.getProvider().getId());
        settings.put(TOOLCHAIN_ID, toolChain.getId());
        settings.put(TOOLCHAIN_VERSION, toolChain.getVersion());
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            CCorePlugin.log(e);
        }
    }

    protected CBuildConfiguration(IBuildConfiguration config, IToolChain toolChain) {
        this(config, "default", toolChain);
    }

    @Override
    public IBuildConfiguration getBuildConfiguration() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public String getLaunchMode() {
        return this.launchMode;
    }

    protected void setLaunchMode(String launchMode) {
        this.launchMode = launchMode;
        Preferences settings = this.getSettings();
        settings.put(LAUNCH_MODE, launchMode);
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            CCorePlugin.log(e);
        }
    }

    public IProject getProject() {
        return this.config.getProject();
    }

    @Override
    public String getBinaryParserId() throws CoreException {
        return this.toolChain != null ? this.toolChain.getBinaryParserId() : "org.eclipse.cdt.core.ELF";
    }

    public IContainer getBuildContainer() throws CoreException {
        IFolder buildFolder;
        NullProgressMonitor monitor = new NullProgressMonitor();
        IProject project = this.getProject();
        IFolder buildRootFolder = project.getFolder("build");
        if (!buildRootFolder.exists()) {
            buildRootFolder.create(1025, true, (IProgressMonitor)monitor);
        }
        if (!(buildFolder = buildRootFolder.getFolder(this.name)).exists()) {
            buildFolder.create(1025, true, (IProgressMonitor)monitor);
        }
        return buildFolder;
    }

    public URI getBuildDirectoryURI() throws CoreException {
        return this.getBuildContainer().getLocationURI();
    }

    public Path getBuildDirectory() throws CoreException {
        return Paths.get(this.getBuildDirectoryURI());
    }

    @Override
    public void setBuildEnvironment(Map<String, String> env) {
        CCorePlugin.getDefault().getBuildEnvironmentManager().setEnvironment(env, this.config, true);
    }

    @Override
    public IBinary[] getBuildOutput() throws CoreException {
        ICProject cproject = CoreModel.getDefault().create(this.config.getProject());
        IBinaryContainer binaries = cproject.getBinaryContainer();
        IPath outputPath = this.getBuildContainer().getFullPath();
        ArrayList<IBinary> outputs = new ArrayList<IBinary>();
        IBinary[] iBinaryArray = binaries.getBinaries();
        int n = iBinaryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBinary binary = iBinaryArray[n2];
            if (outputPath.isPrefixOf(binary.getPath())) {
                IBinaryParser.IBinaryObject bin;
                if (binary.isExecutable()) {
                    outputs.add(binary);
                } else if (binary.isSharedLib() && (bin = (IBinaryParser.IBinaryObject)binary.getAdapter(IBinaryParser.IBinaryObject.class)) instanceof ElfBinaryShared) {
                    try {
                        Elf elf = new Elf(bin.getPath().toOSString());
                        Elf.PHdr[] pHdrArray = elf.getPHdrs();
                        int n3 = pHdrArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Elf.PHdr phdr = pHdrArray[n4];
                            if (phdr.p_type == 3L) {
                                outputs.add(binary);
                                break;
                            }
                            ++n4;
                        }
                    }
                    catch (IOException e) {
                        CCorePlugin.log(e);
                    }
                }
            }
            ++n2;
        }
        if (outputs.isEmpty()) {
            BinaryRunner runner = CModelManager.getDefault().getBinaryRunner(cproject);
            runner.start();
            runner.waitIfRunning();
            IBinary[] iBinaryArray2 = binaries.getBinaries();
            int n5 = iBinaryArray2.length;
            n = 0;
            while (n < n5) {
                IBinary binary = iBinaryArray2[n];
                if (binary.isExecutable() && outputPath.isPrefixOf(binary.getPath())) {
                    outputs.add(binary);
                }
                ++n;
            }
        }
        return outputs.toArray(new IBinary[outputs.size()]);
    }

    public void setActive(IProgressMonitor monitor) throws CoreException {
        IProject project = this.config.getProject();
        if (this.config.equals(project.getActiveBuildConfig())) {
            return;
        }
        IProjectDescription projectDesc = project.getDescription();
        projectDesc.setActiveBuildConfig(this.config.getName());
        project.setDescription(projectDesc, monitor);
    }

    protected Preferences getSettings() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.cdt.core").node("config").node(this.getProject().getName()).node(this.config.getName());
    }

    @Override
    public IToolChain getToolChain() throws CoreException {
        return this.toolChain;
    }

    @Override
    public IEnvironmentVariable getVariable(String name) {
        return null;
    }

    @Override
    public IEnvironmentVariable[] getVariables() {
        return null;
    }

    @Override
    public void addMarker(IResource file, int lineNumber, String errorDesc, int severity, String errorVar) {
        this.addMarker(new ProblemMarkerInfo(file, lineNumber, errorDesc, severity, errorVar, null));
    }

    @Override
    public void addMarker(ProblemMarkerInfo problemMarkerInfo) {
        try {
            Map<String, String> attributes;
            IMarker[] markers;
            IProject project = this.config.getProject();
            IResource markerResource = problemMarkerInfo.file;
            if (markerResource == null) {
                markerResource = project;
            }
            String externalLocation = null;
            if (problemMarkerInfo.externalPath != null && !problemMarkerInfo.externalPath.isEmpty()) {
                externalLocation = problemMarkerInfo.externalPath.toOSString();
            }
            IMarker[] iMarkerArray = markers = markerResource.findMarkers("org.eclipse.cdt.core.problem", true, 1);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                String extloc;
                IMarker m = iMarkerArray[n2];
                int line = m.getAttribute("lineNumber", -1);
                int sev = m.getAttribute("severity", -1);
                String msg = (String)m.getAttribute("message");
                if (line == problemMarkerInfo.lineNumber && sev == this.mapMarkerSeverity(problemMarkerInfo.severity) && msg.equals(problemMarkerInfo.description) && ((extloc = (String)m.getAttribute("problem.externalLocation")) == externalLocation || extloc != null && extloc.equals(externalLocation))) {
                    if (project == null || project.equals((Object)markerResource.getProject())) {
                        return;
                    }
                    String source = (String)m.getAttribute("sourceId");
                    if (project.getName().equals(source)) {
                        return;
                    }
                }
                ++n2;
            }
            String type = problemMarkerInfo.getType();
            if (type == null) {
                type = "org.eclipse.cdt.core.problem";
            }
            IMarker marker = markerResource.createMarker(type);
            marker.setAttribute("message", (Object)problemMarkerInfo.description);
            marker.setAttribute("severity", this.mapMarkerSeverity(problemMarkerInfo.severity));
            marker.setAttribute("lineNumber", problemMarkerInfo.lineNumber);
            marker.setAttribute("charStart", problemMarkerInfo.startChar);
            marker.setAttribute("charEnd", problemMarkerInfo.endChar);
            if (problemMarkerInfo.variableName != null) {
                marker.setAttribute("problem.variable", (Object)problemMarkerInfo.variableName);
            }
            if (externalLocation != null) {
                URI uri = URIUtil.toURI((String)externalLocation);
                if (uri.getScheme() != null) {
                    marker.setAttribute("problem.externalLocation", (Object)externalLocation);
                    String locationText = NLS.bind((String)CCorePlugin.getResourceString("ACBuilder.ProblemsView.Location"), (Object)problemMarkerInfo.lineNumber, (Object)externalLocation);
                    marker.setAttribute("location", (Object)locationText);
                }
            } else if (problemMarkerInfo.lineNumber == 0) {
                marker.setAttribute("location", (Object)" ");
            }
            if (project != null && !project.equals((Object)markerResource.getProject())) {
                marker.setAttribute("sourceId", (Object)project.getName());
            }
            if ((attributes = problemMarkerInfo.getAttributes()) != null) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    marker.setAttribute(entry.getKey(), (Object)entry.getValue());
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e.getStatus());
        }
    }

    private int mapMarkerSeverity(int severity) {
        switch (severity) {
            case 2: 
            case 3: {
                return 2;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    protected Path findCommand(String command) {
        String[] path;
        Path cmdPath;
        if (Platform.getOS().equals("win32") && !command.endsWith(".exe")) {
            command = String.valueOf(command) + ".exe";
        }
        if ((cmdPath = Paths.get(command, new String[0])).isAbsolute()) {
            return cmdPath;
        }
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        this.setBuildEnvironment(env);
        String[] stringArray = path = ((String)env.get("PATH")).split(File.pathSeparator);
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            Path commandPath = Paths.get(dir, command);
            if (Files.exists(commandPath, new LinkOption[0])) {
                return commandPath;
            }
            ++n2;
        }
        return null;
    }

    protected int watchProcess(Process process, IConsoleParser[] consoleParsers, IConsole console) throws CoreException {
        new ReaderThread(process.getInputStream(), consoleParsers, console.getOutputStream()).start();
        new ReaderThread(process.getErrorStream(), consoleParsers, console.getErrorStream()).start();
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            CCorePlugin.log(e);
            return -1;
        }
    }

    private File getScannerInfoCacheFile() {
        return CCorePlugin.getDefault().getStateLocation().append("infoCache").append(this.getProject().getName()).append(String.valueOf(this.name) + ".json").toFile();
    }

    protected void loadScannerInfoCache() {
        if (this.scannerInfoCache == null) {
            File cacheFile = this.getScannerInfoCacheFile();
            if (cacheFile.exists()) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (FileReader reader = new FileReader(cacheFile);){
                        GsonBuilder gsonBuilder = new GsonBuilder();
                        gsonBuilder.registerTypeAdapter(IExtendedScannerInfo.class, (Object)new IExtendedScannerInfoCreator());
                        Gson gson = gsonBuilder.create();
                        this.scannerInfoCache = (ScannerInfoCache)gson.fromJson((Reader)reader, ScannerInfoCache.class);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    CCorePlugin.log(e);
                    this.scannerInfoCache = new ScannerInfoCache();
                }
            } else {
                this.scannerInfoCache = new ScannerInfoCache();
            }
            this.scannerInfoCache.initCache();
        }
    }

    protected void saveScannerInfoCache() {
        File cacheFile = this.getScannerInfoCacheFile();
        if (!cacheFile.getParentFile().exists()) {
            try {
                Files.createDirectories(cacheFile.getParentFile().toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                CCorePlugin.log(e);
                return;
            }
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (FileWriter writer = new FileWriter(this.getScannerInfoCacheFile());){
                Gson gson = new Gson();
                gson.toJson((Object)this.scannerInfoCache, (Appendable)writer);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
    }

    protected ScannerInfoCache getScannerInfoCache() {
        return this.scannerInfoCache;
    }

    @Override
    public IScannerInfo getScannerInformation(IResource resource) {
        ICElement celement;
        this.loadScannerInfoCache();
        IExtendedScannerInfo info = this.scannerInfoCache.getScannerInfo(resource);
        if (info == null && (celement = CCorePlugin.getDefault().getCoreModel().create(resource)) instanceof ITranslationUnit) {
            ITranslationUnit tu = (ITranslationUnit)celement;
            try {
                info = this.getToolChain().getDefaultScannerInfo(this.getBuildConfiguration(), null, tu.getLanguage(), this.getBuildDirectoryURI());
                this.scannerInfoCache.addScannerInfo(DEFAULT_COMMAND, info, resource);
                this.saveScannerInfoCache();
            }
            catch (CoreException e) {
                CCorePlugin.log(e.getStatus());
            }
        }
        return info;
    }

    @Override
    public boolean processLine(String line) {
        int n;
        int n2;
        String[] stringArray;
        List<String> command = Arrays.asList(line.split("\\s+"));
        String[] compileCommands = this.toolChain.getCompileCommands();
        block2: for (String arg : command) {
            if (arg.startsWith("-")) {
                return false;
            }
            stringArray = compileCommands;
            n2 = compileCommands.length;
            n = 0;
            while (n < n2) {
                String cc = stringArray[n];
                if (arg.endsWith(cc) && (arg.equals(cc) || arg.endsWith("/" + cc) || arg.endsWith("\\" + cc))) break block2;
                ++n;
            }
        }
        try {
            IResource[] resources = this.toolChain.getResourcesFromCommand(command, this.getBuildDirectoryURI());
            if (resources != null) {
                List<String> commandStrings = this.toolChain.stripCommand(command, resources);
                stringArray = resources;
                n2 = resources.length;
                n = 0;
                while (n < n2) {
                    String resource = stringArray[n];
                    this.loadScannerInfoCache();
                    if (this.scannerInfoCache.hasCommand(commandStrings)) {
                        if (!this.scannerInfoCache.hasResource(commandStrings, (IResource)resource)) {
                            this.scannerInfoCache.addResource(commandStrings, (IResource)resource);
                            this.infoChanged = true;
                        }
                    } else {
                        Path commandPath = this.findCommand(command.get(0));
                        command.set(0, commandPath.toString());
                        IExtendedScannerInfo info = this.getToolChain().getScannerInfo(this.getBuildConfiguration(), command, null, (IResource)resource, this.getBuildDirectoryURI());
                        this.scannerInfoCache.addScannerInfo(commandStrings, info, (IResource)resource);
                        this.infoChanged = true;
                    }
                    ++n;
                }
                return true;
            }
            return false;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return false;
        }
    }

    @Override
    public void shutdown() {
        if (this.infoChanged) {
            this.saveScannerInfoCache();
            CCorePlugin.getIndexManager().reindex(CoreModel.getDefault().create(this.getProject()));
            this.infoChanged = false;
        }
    }

    @Override
    public void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        List<IScannerInfoChangeListener> listeners = this.scannerInfoListeners.get(resource);
        if (listeners == null) {
            listeners = new ArrayList<IScannerInfoChangeListener>();
            this.scannerInfoListeners.put(resource, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        List<IScannerInfoChangeListener> listeners = this.scannerInfoListeners.get(resource);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.scannerInfoListeners.remove(resource);
            }
        }
    }

    public static Path getCommandFromPath(Path command) {
        if (command.isAbsolute()) {
            return command;
        }
        if (Platform.getOS().equals("win32") && !command.toString().endsWith(".exe")) {
            command = Paths.get(String.valueOf(command.toString()) + ".exe", new String[0]);
        }
        String path = System.getenv("PATH");
        String[] stringArray = path.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            Path entryPath = Paths.get(entry, new String[0]);
            Path cmdPath = entryPath.resolve(command);
            if (Files.isExecutable(cmdPath)) {
                return cmdPath;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean setProperties(Map<String, String> properties) {
        if (this.properties == null || !this.properties.equals(properties)) {
            this.properties = properties;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = this.getDefaultProperties();
        }
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Map<String, String> getDefaultProperties() {
        return new HashMap<String, String>();
    }

    private static class IExtendedScannerInfoCreator
    implements JsonDeserializer<IExtendedScannerInfo> {
        private IExtendedScannerInfoCreator() {
        }

        public IExtendedScannerInfo deserialize(JsonElement element, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
            JsonObject infoObj = element.getAsJsonObject();
            HashMap<String, String> definedSymbols = null;
            if (infoObj.has("definedSymbols")) {
                JsonObject definedSymbolsObj = infoObj.get("definedSymbols").getAsJsonObject();
                definedSymbols = new HashMap<String, String>();
                for (Map.Entry entry : definedSymbolsObj.entrySet()) {
                    definedSymbols.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
            }
            String[] includePaths = null;
            if (infoObj.has("includePaths")) {
                JsonArray includePathsArray = infoObj.get("includePaths").getAsJsonArray();
                ArrayList<String> includePathsList = new ArrayList<String>(includePathsArray.size());
                Iterator i = includePathsArray.iterator();
                while (i.hasNext()) {
                    includePathsList.add(((JsonElement)i.next()).getAsString());
                }
                includePaths = includePathsList.toArray(new String[includePathsList.size()]);
            }
            IncludeExportPatterns includeExportPatterns = null;
            if (infoObj.has("includeExportPatterns")) {
                JsonObject includeExportPatternsObj = infoObj.get("includeExportPatterns").getAsJsonObject();
                String exportPattern = null;
                if (includeExportPatternsObj.has("includeExportPattern")) {
                    exportPattern = includeExportPatternsObj.get("includeExportPattern").getAsJsonObject().get("pattern").getAsString();
                }
                String beginExportsPattern = null;
                if (includeExportPatternsObj.has("includeBeginExportPattern")) {
                    beginExportsPattern = includeExportPatternsObj.get("includeBeginExportPattern").getAsJsonObject().get("pattern").getAsString();
                }
                String endExportsPattern = null;
                if (includeExportPatternsObj.has("includeEndExportPattern")) {
                    endExportsPattern = includeExportPatternsObj.get("includeEndExportPattern").getAsJsonObject().get("pattern").getAsString();
                }
                includeExportPatterns = new IncludeExportPatterns(exportPattern, beginExportsPattern, endExportsPattern);
            }
            ExtendedScannerInfo info = new ExtendedScannerInfo(definedSymbols, includePaths);
            info.setIncludeExportPatterns(includeExportPatterns);
            info.setParserSettings(new ParserSettings2());
            return info;
        }
    }

    private static class ReaderThread
    extends Thread {
        private final BufferedReader in;
        private final PrintStream out;
        private final IConsoleParser[] consoleParsers;

        public ReaderThread(InputStream in, IConsoleParser[] consoleParsers, OutputStream out) {
            this.in = new BufferedReader(new InputStreamReader(in));
            this.consoleParsers = consoleParsers;
            this.out = new PrintStream(out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String line = this.in.readLine();
                while (line != null) {
                    IConsoleParser[] iConsoleParserArray = this.consoleParsers;
                    int n = this.consoleParsers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConsoleParser consoleParser;
                        IConsoleParser iConsoleParser = consoleParser = iConsoleParserArray[n2];
                        synchronized (iConsoleParser) {
                            consoleParser.processLine(line);
                        }
                        ++n2;
                    }
                    this.out.println(line);
                    line = this.in.readLine();
                }
            }
            catch (IOException e) {
                CCorePlugin.log(e);
            }
        }
    }
}

