/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.artifact;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.TextAnnotation;
import org.eclipse.bpmn2.modeler.core.features.DefaultMoveBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.DefaultResizeBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.ShowDocumentationFeature;
import org.eclipse.bpmn2.modeler.core.features.ShowPropertiesFeature;
import org.eclipse.bpmn2.modeler.core.features.artifact.AddTextAnnotationFeature;
import org.eclipse.bpmn2.modeler.core.features.artifact.DirectEditTextAnnotationFeature;
import org.eclipse.bpmn2.modeler.core.features.artifact.LayoutTextAnnotationFeature;
import org.eclipse.bpmn2.modeler.core.features.artifact.UpdateTextAnnotationFeature;
import org.eclipse.bpmn2.modeler.core.features.label.LabelFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.ui.features.AbstractDefaultDeleteFeature;
import org.eclipse.bpmn2.modeler.ui.features.artifact.CreateTextAnnotationFeature;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IDirectEditingFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class TextAnnotationFeatureContainer
extends LabelFeatureContainer {
    public Object getApplyObject(IContext context) {
        return BusinessObjectUtil.getBusinessObject((IContext)context, TextAnnotation.class);
    }

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof TextAnnotation;
    }

    public ICreateFeature getCreateFeature(IFeatureProvider fp) {
        return new CreateTextAnnotationFeature(fp);
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddTextAnnotationFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = new MultiUpdateFeature(fp);
        multiUpdate.addFeature((IUpdateFeature)new UpdateTextAnnotationFeature(fp));
        multiUpdate.addFeature((IUpdateFeature)new UpdateLabelFeature(fp){

            protected boolean hasLabel(BaseElement element) {
                return element instanceof TextAnnotation;
            }

            protected String getLabelString(BaseElement element) {
                if (element instanceof TextAnnotation) {
                    return ((TextAnnotation)element).getText();
                }
                return "";
            }

            protected Rectangle getLabelBounds(PictogramElement pe, boolean isAddingLabel, Point offset) {
                Rectangle bounds = super.getLabelBounds(pe, isAddingLabel, offset);
                if (bounds != null && !isAddingLabel) {
                    bounds.setY(bounds.y - 3);
                }
                return bounds;
            }

            protected int getLabelWidth(AbstractText text) {
                PictogramElement pe = FeatureSupport.getLabelOwner((GraphicsAlgorithm)text);
                return pe.getGraphicsAlgorithm().getWidth() - 12;
            }

            protected int getLabelHeight(AbstractText text) {
                PictogramElement pe = FeatureSupport.getLabelOwner((GraphicsAlgorithm)text);
                return pe.getGraphicsAlgorithm().getHeight() - 6;
            }

            protected ShapeStyle.LabelPosition getLabelPosition(AbstractText text) {
                return ShapeStyle.LabelPosition.TOP;
            }
        });
        return multiUpdate;
    }

    public IDirectEditingFeature getDirectEditingFeature(IFeatureProvider fp) {
        return new DirectEditTextAnnotationFeature(fp);
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return new LayoutTextAnnotationFeature(fp);
    }

    public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
        return new DefaultMoveBPMNShapeFeature(fp){

            public boolean canMoveShape(IMoveShapeContext context) {
                return FeatureSupport.isValidArtifactTarget((ITargetContext)context);
            }

            protected void internalMove(IMoveShapeContext context) {
                if (FeatureSupport.isLabelShape((PictogramElement)context.getPictogramElement())) {
                    PictogramElement pe = FeatureSupport.getLabelOwner((IContext)context);
                    MoveShapeContext newContext = new MoveShapeContext((Shape)pe);
                    newContext.setDeltaX(context.getDeltaX());
                    newContext.setDeltaY(context.getDeltaY());
                    newContext.setX(context.getX());
                    newContext.setY(context.getY());
                    newContext.setSourceContainer(context.getSourceContainer());
                    newContext.setTargetContainer(context.getTargetContainer());
                    context = newContext;
                }
                super.internalMove(context);
            }
        };
    }

    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return new DefaultResizeBPMNShapeFeature(fp){

            public void resizeShape(IResizeShapeContext context) {
                if (FeatureSupport.isLabelShape((PictogramElement)context.getPictogramElement())) {
                    PictogramElement pe = FeatureSupport.getLabelOwner((IContext)context);
                    ResizeShapeContext newContext = new ResizeShapeContext((Shape)pe);
                    newContext.setDirection(context.getDirection());
                    newContext.setHeight(context.getHeight());
                    newContext.setWidth(context.getWidth());
                    newContext.setX(context.getX());
                    newContext.setY(context.getY());
                    context = newContext;
                }
                super.resizeShape(context);
            }
        };
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new AbstractDefaultDeleteFeature(fp);
    }

    public ICustomFeature[] getCustomFeatures(IFeatureProvider fp) {
        return new ICustomFeature[]{new ShowDocumentationFeature(fp), new ShowPropertiesFeature(fp)};
    }
}

