/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection.action;

import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.selection.command.SelectCellCommand;
import net.sourceforge.nattable.ui.action.IDragMode;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

public class CellSelectionDragMode
implements IDragMode {
    private boolean shiftMask;
    private boolean controlMask;
    private Point lastDragInCellPosition = null;

    public void mouseDown(NatTable natTable, MouseEvent event) {
        natTable.forceFocus();
        this.shiftMask = (event.stateMask & 0x20000) == 131072;
        this.controlMask = (event.stateMask & 0x40000) == 262144;
        this.fireSelectionCommand(natTable, natTable.getColumnPositionByX(event.x), natTable.getRowPositionByY(event.y), this.shiftMask, this.controlMask);
    }

    public void mouseMove(NatTable natTable, MouseEvent event) {
        if (event.x > natTable.getWidth()) {
            return;
        }
        int selectedColumnPosition = natTable.getColumnPositionByX(event.x);
        int selectedRowPosition = natTable.getRowPositionByY(event.y);
        if (selectedColumnPosition > -1 && selectedRowPosition > -1) {
            Point dragInCellPosition = new Point(selectedColumnPosition, selectedRowPosition);
            if (this.lastDragInCellPosition == null || !dragInCellPosition.equals((Object)this.lastDragInCellPosition)) {
                this.lastDragInCellPosition = dragInCellPosition;
                this.fireSelectionCommand(natTable, selectedColumnPosition, selectedRowPosition, true, false);
            }
        }
    }

    public void fireSelectionCommand(NatTable natTable, int columnPosition, int rowPosition, boolean shiftMask, boolean controlMask) {
        natTable.doCommand(new SelectCellCommand(natTable, columnPosition, rowPosition, shiftMask, controlMask));
    }

    public void mouseUp(NatTable natTable, MouseEvent event) {
        this.endDrag();
    }

    private void endDrag() {
        this.lastDragInCellPosition = null;
    }
}

