/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.set.primitive.MutableShortSetFactory;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.factory.primitive.ShortSets;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.utility.Iterate;

public class MutableShortSetFactoryImpl
implements MutableShortSetFactory {
    public static final MutableShortSetFactory INSTANCE = new MutableShortSetFactoryImpl();

    @Override
    public MutableShortSet empty() {
        return new ShortHashSet();
    }

    @Override
    public MutableShortSet of() {
        return this.empty();
    }

    @Override
    public MutableShortSet with() {
        return this.empty();
    }

    @Override
    public MutableShortSet withInitialCapacity(int capacity) {
        return new ShortHashSet(capacity);
    }

    @Override
    public MutableShortSet of(short ... items) {
        return this.with(items);
    }

    @Override
    public MutableShortSet with(short ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        return ShortHashSet.newSetWith(items);
    }

    @Override
    public MutableShortSet ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableShortSet withAll(ShortIterable items) {
        return ShortHashSet.newSet(items);
    }

    @Override
    public MutableShortSet ofAll(Iterable<Short> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableShortSet withAll(Iterable<Short> iterable) {
        return Iterate.collectShort(iterable, Short::shortValue, ShortSets.mutable.empty());
    }
}

