/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.launching.internal.target;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.launching.ext.BundleStart;
import org.eclipse.rcptt.launching.ext.OriginalOrderProperties;
import org.eclipse.rcptt.launching.internal.target.TargetPlatformHelper;

public class Q7Target {
    private AutInstall install;

    public AutInstall getInstall() {
        return this.install;
    }

    public File getInstallLocation() {
        if (this.install == null) {
            return null;
        }
        File result = this.install.getInstallLocation();
        if (result == null || !result.exists()) {
            return null;
        }
        return result;
    }

    public void setInstall(ITargetLocation installation) {
        if (!(installation instanceof ProfileBundleContainer)) {
            Q7ExtLaunchingPlugin.log(Q7ExtLaunchingPlugin.status(String.format("%s is set as an installation container, but ProfileBundleContainer expected", installation)));
            this.install = null;
        }
        this.install = new AutInstall((ProfileBundleContainer)installation);
    }

    public static class AutInstall {
        private static final String OSGI_BUNDLES = "osgi.bundles";
        public final ProfileBundleContainer container;
        public String userArea;

        public AutInstall(ProfileBundleContainer container) {
            this.container = container;
            this.userArea = null;
        }

        public boolean usesSimpleConfigurator() {
            return this.getBundlesString().contains("org.eclipse.equinox.simpleconfigurator");
        }

        public Map<String, BundleStart> configIniBundles() {
            LinkedHashMap<String, BundleStart> result = new LinkedHashMap<String, BundleStart>();
            for (String entry : Splitter.on((char)',').split((CharSequence)this.getBundlesString())) {
                int sep = entry.indexOf(64);
                String id = sep == -1 ? entry : entry.substring(0, sep);
                String startInfo = sep == -1 ? "" : entry.substring(sep + 1);
                BundleStart bundleStart = BundleStart.DEFAULT;
                try {
                    bundleStart = BundleStart.fromOsgiString(startInfo);
                }
                catch (Exception e) {
                    Q7ExtLaunchingPlugin.logWarn(e, "config.ini 'osgi.bundles' bad entry: cannot parse start level and auto-start for entry '%s', using defaults instead.", entry);
                }
                result.put(id, bundleStart);
            }
            return result;
        }

        private String getBundlesString() {
            return org.eclipse.pde.internal.core.TargetPlatformHelper.stripPathInformation((String)((String)MoreObjects.firstNonNull((Object)this.getConfig().getProperty(OSGI_BUNDLES), (Object)org.eclipse.pde.internal.core.TargetPlatformHelper.getDefaultBundleList())));
        }

        public File getInstallLocation() {
            try {
                return new File(this.container.getLocation(true));
            }
            catch (CoreException e) {
                Q7ExtLaunchingPlugin.log(Q7ExtLaunchingPlugin.status("Can't get AUT location", e));
                return null;
            }
        }

        public URL getInstallLocationURL() {
            try {
                return TargetPlatformHelper.buildURL(this.container.getLocation(true), true, this.getInstallLocation().getAbsolutePath());
            }
            catch (CoreException e) {
                Q7ExtLaunchingPlugin.log(Q7ExtLaunchingPlugin.status("Can't get AUT location", e));
                return null;
            }
        }

        protected OriginalOrderProperties getConfig() {
            return (OriginalOrderProperties)MoreObjects.firstNonNull((Object)TargetPlatformHelper.processConfiguration(this), (Object)new OriginalOrderProperties());
        }
    }
}

