/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public abstract class WizardParameterValues
implements IParameterValues {
    private void addParameterValues(Map values, IWizardCategory wizardCategory) {
        Object[] objectArray = wizardCategory.getWizards();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardDescriptor wizardDescriptor = objectArray[n2];
            if (!WorkbenchActivityHelper.filterItem(wizardDescriptor)) {
                Object name = wizardDescriptor.getLabel();
                String id = wizardDescriptor.getId();
                String value = (String)values.get(name);
                if (value != null && !value.equals(id)) {
                    name = (String)name + " (" + id + ")";
                }
                values.put(name, id);
            }
            ++n2;
        }
        objectArray = wizardCategory.getCategories();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object childCategory = objectArray[n2];
            this.addParameterValues(values, (IWizardCategory)childCategory);
            ++n2;
        }
    }

    public Map getParameterValues() {
        HashMap values = new HashMap();
        IWizardRegistry wizardRegistry = this.getWizardRegistry();
        this.addParameterValues(values, wizardRegistry.getRootCategory());
        return values;
    }

    protected abstract IWizardRegistry getWizardRegistry();

    public static final class Export
    extends WizardParameterValues {
        @Override
        protected IWizardRegistry getWizardRegistry() {
            return PlatformUI.getWorkbench().getExportWizardRegistry();
        }
    }

    public static final class Import
    extends WizardParameterValues {
        @Override
        protected IWizardRegistry getWizardRegistry() {
            return PlatformUI.getWorkbench().getImportWizardRegistry();
        }
    }

    public static final class New
    extends WizardParameterValues {
        @Override
        protected IWizardRegistry getWizardRegistry() {
            return PlatformUI.getWorkbench().getNewWizardRegistry();
        }
    }
}

