/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.fuml.actions.ILoopNodeActivation;
import org.eclipse.papyrus.moka.fuml.actions.OutputPinActivation;
import org.eclipse.papyrus.moka.fuml.actions.StructuredActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.actions.Values;
import org.eclipse.papyrus.moka.fuml.activities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.papyrus.moka.fuml.profiling.actions.AcceptEventActionActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ActivityEdgeInstanceProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ActivityNodeActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.CallActionActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.ObjectNodeActivationProfiler;
import org.eclipse.papyrus.moka.fuml.profiling.activities.PinActivationProfiler;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.BooleanValue;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.LoopNode;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Pin;

public class LoopNodeActivation
extends StructuredActivityNodeActivation
implements ILoopNodeActivation {
    public List<Values> bodyOutputLists = new ArrayList<Values>();
    public Boolean isTerminateAll;

    @Override
    public void doStructuredActivity() {
        LoopNode loopNode = (LoopNode)this.node;
        EList loopVariableInputs = loopNode.getLoopVariableInputs();
        this.bodyOutputLists.clear();
        int i = 0;
        while (i < loopVariableInputs.size()) {
            List<IValue> list;
            InputPin loopVariableInput = (InputPin)loopVariableInputs.get(i);
            Values bodyOutputList = new Values();
            InputPin inputPin = loopVariableInput;
            LoopNodeActivation loopNodeActivation = this;
            try {
                list = loopNodeActivation.takeTokens(inputPin);
            }
            finally {
                PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_activities_PinActivationProfiler$2$e210d285(loopNodeActivation, inputPin);
            }
            bodyOutputList.values = list;
            this.bodyOutputLists.add(bodyOutputList);
            ++i;
        }
        this.isTerminateAll = false;
        this.doLoop(true);
    }

    public void doLoop(Boolean continuing) {
        LoopNode loopNode = (LoopNode)this.node;
        EList loopVariables = loopNode.getLoopVariables();
        List<OutputPin> resultPins = this.getResults();
        while (continuing.booleanValue()) {
            this.runLoopVariables();
            int i = 0;
            while (i < loopVariables.size()) {
                OutputPin loopVariable = (OutputPin)loopVariables.get(i);
                Values bodyOutputList = this.bodyOutputLists.get(i);
                List<IValue> values = bodyOutputList.values;
                this.putPinValues(loopVariable, values);
                ((OutputPinActivation)this.activationGroup.getNodeActivation((ActivityNode)loopVariable)).sendUnofferedTokens();
                ++i;
            }
            List<IActivityNodeActivation> nodeActivations = this.activationGroup.nodeActivations;
            ArrayList<IActivityNodeActivation> nonExecutableNodeActivations = new ArrayList<IActivityNodeActivation>();
            int i2 = 0;
            while (i2 < nodeActivations.size()) {
                IActivityNodeActivation nodeActivation = nodeActivations.get(i2);
                if (!(nodeActivation.getNode() instanceof ExecutableNode | nodeActivation.getNode() instanceof Pin)) {
                    nonExecutableNodeActivations.add(nodeActivation);
                }
                ++i2;
            }
            this.activationGroup.run(nonExecutableNodeActivations);
            if (loopNode.isTestedFirst()) {
                continuing = this.runTest();
                if (continuing.booleanValue()) {
                    this.runBody();
                }
            } else {
                this.runBody();
                if (this.isRunning() & this.isSuspended() == false) {
                    continuing = this.runTest();
                }
            }
            if (this.isTerminateAll == false & this.isRunning() & this.isSuspended() == false) {
                this.activationGroup.terminateAll();
            } else {
                continuing = false;
            }
            Debug.println("[doStructuredActivity] " + (continuing != false ? "Continuing." : (this.isSuspended() != false ? "Suspended" : "Done.")));
        }
        if (this.isTerminateAll == false & this.isRunning() & this.isSuspended() == false) {
            int i = 0;
            while (i < this.bodyOutputLists.size()) {
                Values bodyOutputList = this.bodyOutputLists.get(i);
                OutputPin resultPin = resultPins.get(i);
                this.putTokens(resultPin, bodyOutputList.values);
                ++i;
            }
        }
    }

    public Boolean runTest() {
        Debug.println("[runTest] Running test...");
        LoopNode loopNode = (LoopNode)this.node;
        this.activationGroup.runNodes(this.makeActivityNodeList((List<ExecutableNode>)loopNode.getTests()));
        List<IValue> values = this.getPinValues(loopNode.getDecider());
        boolean decision = false;
        if (values.size() > 0) {
            decision = ((BooleanValue)values.get((int)0)).value;
        }
        Debug.println("[runTest] " + (decision ? "Test succeeded." : "Test failed."));
        return decision;
    }

    public void runBody() {
        Debug.println("[runBody] Running body...");
        LoopNode loopNode = (LoopNode)this.node;
        this.activationGroup.runNodes(this.makeActivityNodeList((List<ExecutableNode>)loopNode.getBodyParts()));
        if (this.isTerminateAll == false & this.isSuspended() == false) {
            this.saveBodyOutputs();
        }
    }

    public void saveBodyOutputs() {
        LoopNode loopNode = (LoopNode)this.node;
        EList bodyOutputs = loopNode.getBodyOutputs();
        List<Values> bodyOutputLists = this.bodyOutputLists;
        int i = 0;
        while (i < bodyOutputs.size()) {
            OutputPin bodyOutput = (OutputPin)bodyOutputs.get(i);
            Values bodyOutputList = bodyOutputLists.get(i);
            bodyOutputList.values = this.getPinValues(bodyOutput);
            ++i;
        }
    }

    public void runLoopVariables() {
        this.activationGroup.runNodes(this.makeLoopVariableList());
    }

    @Override
    public void createNodeActivations() {
        super.createNodeActivations();
        this.activationGroup.createNodeActivations(this.makeLoopVariableList());
    }

    public List<ActivityNode> makeLoopVariableList() {
        LoopNode loopNode = (LoopNode)this.node;
        ArrayList<ActivityNode> nodes = new ArrayList<ActivityNode>();
        EList loopVariables = loopNode.getLoopVariables();
        int i = 0;
        while (i < loopVariables.size()) {
            OutputPin loopVariable = (OutputPin)loopVariables.get(i);
            nodes.add((ActivityNode)loopVariable);
            ++i;
        }
        return nodes;
    }

    @Override
    public void terminateAll() {
        this.isTerminateAll = true;
        LoopNode loopNode = (LoopNode)this.node;
        EList bodyOutputs = loopNode.getBodyOutputs();
        List<OutputPin> resultPins = this.getResults();
        int i = 0;
        while (i < bodyOutputs.size()) {
            OutputPin bodyOutput = (OutputPin)bodyOutputs.get(i);
            OutputPin resultPin = resultPins.get(i);
            this.putTokens(resultPin, this.getPinValues(bodyOutput));
            ++i;
        }
        super.terminateAll();
    }

    @Override
    public void resume() {
        block22: {
            LoopNode loopNode = (LoopNode)this.node;
            this.saveBodyOutputs();
            if (!this.isTerminateAll.booleanValue()) {
                if (loopNode.isMustIsolate()) {
                    LoopNodeActivation loopNodeActivation = this;
                    ActivityEdgeInstanceProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(loopNodeActivation);
                    ActivityNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(loopNodeActivation);
                    ObjectNodeActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(loopNodeActivation);
                    PinActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(loopNodeActivation);
                    AcceptEventActionActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(loopNodeActivation);
                    CallActionActivationProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$1$ccbc371e(loopNodeActivation);
                    loopNodeActivation._beginIsolation();
                    this.continueLoop();
                    LoopNodeActivation loopNodeActivation2 = this;
                    try {
                        try {
                            try {
                                try {
                                    try {
                                        try {
                                            loopNodeActivation2._endIsolation();
                                            break block22;
                                        }
                                        finally {
                                            ActivityEdgeInstanceProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(loopNodeActivation2);
                                        }
                                    }
                                    finally {
                                        ActivityNodeActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(loopNodeActivation2);
                                    }
                                }
                                finally {
                                    ObjectNodeActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(loopNodeActivation2);
                                }
                            }
                            finally {
                                PinActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(loopNodeActivation2);
                            }
                        }
                        finally {
                            AcceptEventActionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(loopNodeActivation2);
                        }
                    }
                    finally {
                        CallActionActivationProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_loci_SemanticVisitorProfiler$2$b74c5ed0(loopNodeActivation2);
                    }
                }
                this.continueLoop();
            }
        }
        if (this.isSuspended().booleanValue()) {
            this.group.resume((IActivityNodeActivation)this);
        } else {
            super.resume();
        }
    }

    public void continueLoop() {
        LoopNode loopNode = (LoopNode)this.node;
        boolean continuing = true;
        if (!loopNode.isTestedFirst()) {
            continuing = this.runTest();
        }
        if (this.isRunning().booleanValue()) {
            this.activationGroup.terminateAll();
            this.doLoop(continuing);
        }
    }

    private List<OutputPin> getResults() {
        LoopNode node = (LoopNode)this.node;
        ArrayList<OutputPin> results = new ArrayList<OutputPin>((Collection<OutputPin>)node.getResults());
        EList loopVariables = node.getLoopVariables();
        results.removeAll((Collection<?>)loopVariables);
        return results;
    }
}

