/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.lsp4mp.commons.runtime.EnumConstantsProvider;
import org.eclipse.lsp4mp.commons.runtime.MicroProfileProjectRuntime;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProject;
import org.eclipse.lsp4mp.jdt.core.project.JDTMicroProfileProjectManager;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;

public abstract class AbtractJavaContext {
    private final String uri;
    private final ITypeRoot typeRoot;
    private final IJDTUtils utils;
    private Map<String, Object> cache;
    private CompilationUnit fASTRoot;
    private MicroProfileProjectRuntime projectRuntime;

    public AbtractJavaContext(String uri, ITypeRoot typeRoot, IJDTUtils utils) {
        this.uri = uri;
        this.typeRoot = typeRoot;
        this.utils = utils;
        this.fASTRoot = null;
    }

    public String getUri() {
        return this.uri;
    }

    public ITypeRoot getTypeRoot() {
        return this.typeRoot;
    }

    public IJavaProject getJavaProject() {
        return this.getTypeRoot().getJavaProject();
    }

    public IJDTUtils getUtils() {
        return this.utils;
    }

    public void put(String key, Object value) {
        if (this.cache == null) {
            this.cache = new HashMap<String, Object>();
        }
        this.cache.put(key, value);
    }

    public Object get(String key) {
        if (this.cache == null) {
            return null;
        }
        return this.cache.get(key);
    }

    public CompilationUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = ASTResolving.createQuickFixAST((ICompilationUnit)((ICompilationUnit)this.getTypeRoot()), null);
        }
        return this.fASTRoot;
    }

    public void setASTRoot(CompilationUnit root) {
        this.fASTRoot = root;
    }

    protected static String toQualifiedTypeString(ITypeBinding binding, EnumConstantsProvider.SimpleEnumConstantsProvider provider) {
        if (binding == null) {
            return "";
        }
        if (binding.isPrimitive() || binding.isArray() && binding.getComponentType() != null && binding.getComponentType().isPrimitive()) {
            return binding.getName();
        }
        String baseQualifieldName = binding.getErasure().getBinaryName();
        if (binding.isEnum()) {
            ArrayList<String> enumConstNames = new ArrayList<String>();
            IVariableBinding[] iVariableBindingArray = binding.getDeclaredFields();
            int n = iVariableBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVariableBinding field = iVariableBindingArray[n2];
                if (field.isEnumConstant()) {
                    enumConstNames.add(field.getName());
                }
                ++n2;
            }
            provider.addEnumConstants(baseQualifieldName, enumConstNames);
        }
        StringBuilder sb = new StringBuilder(baseQualifieldName);
        ITypeBinding[] typeArguments = binding.getTypeArguments();
        if (typeArguments != null && typeArguments.length > 0) {
            sb.append("<");
            int i = 0;
            while (i < typeArguments.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(AbtractJavaContext.toQualifiedTypeString(typeArguments[i], provider));
                ++i;
            }
            sb.append(">");
        }
        return sb.toString();
    }

    public MicroProfileProjectRuntime getProjectRuntime() {
        if (this.projectRuntime != null) {
            return this.projectRuntime;
        }
        JDTMicroProfileProject mpProject = this.getMicroProfileProject();
        if (mpProject == null) {
            return null;
        }
        this.projectRuntime = mpProject.getProjectRuntime();
        return this.projectRuntime;
    }

    public JDTMicroProfileProject getMicroProfileProject() {
        try {
            return JDTMicroProfileProjectManager.getInstance().getJDTMicroProfileProject(this.getJavaProject());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

