/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.diagnostics;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.operations.diagnostics.LSPDiagnosticsToMarkers;
import org.eclipse.lsp4e.test.color.ColorTest;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.BlockingWorkspaceJob;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DiagnosticsTest
extends AbstractTestWithProject {
    private LSPDiagnosticsToMarkers diagnosticsToMarkers = new LSPDiagnosticsToMarkers("dummy");

    @Test
    public void testDiagnostics() throws CoreException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Diagnostic Other Text");
        int markerLineIndex = 0;
        int markerCharStart = 0;
        int markerCharEnd = 10;
        Range range = new Range(new Position(markerLineIndex, markerCharStart), new Position(markerLineIndex, markerCharEnd));
        List<Diagnostic> diagnostics = List.of(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1"), this.createDiagnostic("2", "message2", range, DiagnosticSeverity.Warning, "source2"), this.createDiagnostic("3", "message3", range, DiagnosticSeverity.Information, "source3"), this.createDiagnostic("4", "message4", range, DiagnosticSeverity.Hint, "source4"));
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), diagnostics));
        TestUtils.waitForAndAssertCondition(10000, () -> {
            Assertions.assertEquals((int)diagnostics.size(), (int)file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2).length);
            return true;
        });
        IMarker[] markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2);
        for (Diagnostic diagnostic : diagnostics) {
            Optional<IMarker> marker = Stream.of(markers).filter(m -> {
                try {
                    return m.getAttribute("lspDiagnostic") == diagnostic;
                }
                catch (CoreException ex) {
                    throw new RuntimeException(ex);
                }
            }).findFirst();
            Assertions.assertTrue((boolean)marker.isPresent(), (String)("No marker found for " + String.valueOf(diagnostic)));
            Assertions.assertEquals((int)markerCharStart, (int)MarkerUtilities.getCharStart((IMarker)marker.get()));
            Assertions.assertEquals((int)markerCharEnd, (int)MarkerUtilities.getCharEnd((IMarker)marker.get()));
            Assertions.assertEquals((int)(markerLineIndex + 1), (int)MarkerUtilities.getLineNumber((IMarker)marker.get()));
            Assertions.assertEquals((Object)(diagnostic.getMessage() + " [" + String.valueOf(diagnostic.getCode().get()) + "]"), (Object)MarkerUtilities.getMessage((IMarker)marker.get()));
        }
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), Collections.emptyList()));
        TestUtils.waitForAndAssertCondition(10000, () -> {
            Assertions.assertEquals((int)0, (int)file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2).length);
            return true;
        });
    }

    @Test
    public void testDiagnosticsForMarkerUpdateAfterProjectClose() throws CoreException, InterruptedException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Diagnostic Marker Update After Project Close");
        int markerLineIndex = 0;
        int markerCharStart = 0;
        int markerCharEnd = 10;
        Range range = new Range(new Position(markerLineIndex, markerCharStart), new Position(markerLineIndex, markerCharEnd));
        List<Diagnostic> diagnostics = List.of(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1"), this.createDiagnostic("2", "message2", range, DiagnosticSeverity.Warning, "source2"), this.createDiagnostic("3", "message3", range, DiagnosticSeverity.Information, "source3"), this.createDiagnostic("4", "message4", range, DiagnosticSeverity.Hint, "source4"));
        PublishDiagnosticsParams diagnosticsParamsForFileDeletedInTheMeantime = new PublishDiagnosticsParams(file.getLocationURI().toString(), diagnostics);
        Job.getJobManager().suspend();
        this.diagnosticsToMarkers.accept(diagnosticsParamsForFileDeletedInTheMeantime);
        TestUtils.waitForAndAssertCondition(1000, () -> {
            Job[] allMarkerJobs = Job.getJobManager().find(LanguageServerPlugin.FAMILY_UPDATE_MARKERS);
            MatcherAssert.assertThat((String)"Marker Job not scheduled", (Object)allMarkerJobs.length, (Matcher)CoreMatchers.is((Object)1));
            return true;
        });
        Job[] allMarkerJobs = Job.getJobManager().find(LanguageServerPlugin.FAMILY_UPDATE_MARKERS);
        Job markerJob = allMarkerJobs[0];
        this.project.close(null);
        TestUtils.waitForAndAssertCondition(1000, () -> {
            Assertions.assertEquals((Object)this.project.isAccessible(), (Object)false);
            return true;
        });
        Job.getJobManager().resume();
        markerJob.join();
        MatcherAssert.assertThat((Object)markerJob.getResult().isOK(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testDiagnosticsForMarkerUpdateAfterDeletedFile() throws CoreException, InterruptedException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Diagnostic Marker Update After File Deletion");
        int markerLineIndex = 0;
        int markerCharStart = 0;
        int markerCharEnd = 10;
        Range range = new Range(new Position(markerLineIndex, markerCharStart), new Position(markerLineIndex, markerCharEnd));
        List<Diagnostic> diagnostics = List.of(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1"));
        PublishDiagnosticsParams diagnosticsParamsForFileDeletedInTheMeantime = new PublishDiagnosticsParams(file.getLocationURI().toString(), diagnostics);
        BlockingWorkspaceJob blockingWorkspaceJob = new BlockingWorkspaceJob("blockingJob");
        blockingWorkspaceJob.setRule(file.getWorkspace().getRuleFactory().markerRule((IResource)file));
        blockingWorkspaceJob.schedule();
        TestUtils.waitForAndAssertCondition(1000, () -> {
            Assertions.assertEquals((int)blockingWorkspaceJob.getState(), (int)4);
            return true;
        });
        this.diagnosticsToMarkers.accept(diagnosticsParamsForFileDeletedInTheMeantime);
        Job[] allMarkerJobs = Job.getJobManager().find(LanguageServerPlugin.FAMILY_UPDATE_MARKERS);
        MatcherAssert.assertThat((Object)allMarkerJobs.length, (Matcher)CoreMatchers.is((Object)1));
        Job markerJob = allMarkerJobs[0];
        TestUtils.waitForAndAssertCondition(2000, () -> {
            file.delete(true, null);
            Assertions.assertEquals((Object)file.exists(), (Object)false);
            return true;
        });
        blockingWorkspaceJob.progress();
        markerJob.join();
        MatcherAssert.assertThat((Object)markerJob.getResult().isOK(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testFileBuffersNotLeaked() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Diagnostic Other Text");
        Range range = new Range(new Position(0, 0), new Position(0, 10));
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        diagnostics.add(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1"));
        IDocument existingDocument = LSPEclipseUtils.getExistingDocument((IResource)file);
        Assertions.assertNull((Object)existingDocument);
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), diagnostics));
        TestUtils.waitForAndAssertCondition(10000, () -> {
            IDocument shouldHaveBeenClosed = LSPEclipseUtils.getExistingDocument((IResource)file);
            Assertions.assertNull((Object)shouldHaveBeenClosed);
            return true;
        });
    }

    @Test
    public void testDiagnosticsRangeAfterDocument() throws CoreException {
        String content = "Diagnostic Other Text";
        IFile file = TestUtils.createUniqueTestFile(this.project, "Diagnostic Other Text");
        Range range = new Range(new Position(1, 0), new Position(1, 5));
        List<Diagnostic> diagnostics = List.of(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1"));
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), diagnostics));
        TestUtils.waitForAndAssertCondition(10000, () -> {
            Assertions.assertEquals((int)diagnostics.size(), (int)file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2).length);
            return true;
        });
        IMarker[] markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2);
        int i = 0;
        while (i < diagnostics.size()) {
            Diagnostic diagnostic = diagnostics.get(i);
            IMarker marker = markers[i];
            Assertions.assertEquals((Object)(diagnostic.getMessage() + " [" + String.valueOf(diagnostic.getCode().get()) + "]"), (Object)MarkerUtilities.getMessage((IMarker)marker));
            Assertions.assertEquals((int)"Diagnostic Other Text".length(), (int)MarkerUtilities.getCharStart((IMarker)marker));
            Assertions.assertEquals((int)"Diagnostic Other Text".length(), (int)MarkerUtilities.getCharEnd((IMarker)marker));
            Assertions.assertEquals((int)1, (int)MarkerUtilities.getLineNumber((IMarker)marker));
            Assertions.assertEquals((Object)marker.getAttribute("lspDiagnostic"), (Object)diagnostic);
            ++i;
        }
    }

    @Test
    public void testDiagnosticsOnContainerResourceWithoutDocument() throws Exception {
        String projectUri = this.project.getLocationURI().toString();
        Range range = new Range(new Position(0, 1), new Position(0, 5));
        Diagnostic diagnostic = this.createDiagnostic("code", "message", range, DiagnosticSeverity.Warning, "source");
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(projectUri, List.of(diagnostic)));
        TestUtils.waitForAndAssertCondition(10000, () -> {
            IMarker[] markers = this.project.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
            return markers.length == 1;
        });
        IMarker[] initialMarkers = this.project.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
        Assertions.assertEquals((int)1, (int)initialMarkers.length);
        IMarker initialMarker = initialMarkers[0];
        Assertions.assertEquals((int)1, (int)MarkerUtilities.getLineNumber((IMarker)initialMarker));
        Assertions.assertEquals((Object)range.getStart().getLine(), (Object)initialMarker.getAttribute("lspStartLine"));
        Assertions.assertEquals((Object)range.getStart().getCharacter(), (Object)initialMarker.getAttribute("lspStartChar"));
        Assertions.assertEquals((Object)range.getEnd().getLine(), (Object)initialMarker.getAttribute("lspEndLine"));
        Assertions.assertEquals((Object)range.getEnd().getCharacter(), (Object)initialMarker.getAttribute("lspEndChar"));
        Assertions.assertEquals((int)-1, (int)MarkerUtilities.getCharStart((IMarker)initialMarker));
        Assertions.assertEquals((int)-1, (int)MarkerUtilities.getCharEnd((IMarker)initialMarker));
        long initialId = initialMarker.getId();
        this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(projectUri, List.of(diagnostic)));
        TestUtils.waitForAndAssertCondition(10000, () -> {
            IMarker[] markers = this.project.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
            return markers.length == 1;
        });
        IMarker[] markersAfterUpdate = this.project.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
        Assertions.assertEquals((int)1, (int)markersAfterUpdate.length);
        Assertions.assertEquals((long)initialId, (long)markersAfterUpdate[0].getId());
    }

    @Test
    public void testDiagnosticsFromVariousLS() throws Exception {
        String content = "Diagnostic Other Text";
        IFile file = TestUtils.createUniqueTestFileMultiLS(this.project, "Diagnostic Other Text");
        Range range = new Range(new Position(1, 0), new Position(1, 0));
        MockLanguageServer.INSTANCE.setDiagnostics(List.of(this.createDiagnostic("1", "message1", range, DiagnosticSeverity.Error, "source1")));
        IMarker[] markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0);
        Assertions.assertEquals((int)0, (int)markers.length, (String)"no marker should be shown at file initialization");
        TestUtils.openEditor(file);
        TestUtils.waitForAndAssertCondition(10000, () -> {
            Assertions.assertEquals((int)2, (int)file.findMarkers("org.eclipse.lsp4e.diagnostic", true, 0).length, (String)"there should be 1 marker for each language server");
            return true;
        });
    }

    @Test
    public void testDiagnosticRedrawingCalls() throws CoreException {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Diagnostic Other Text\nDiagnostic Other Text");
        Range range1 = new Range(new Position(0, 0), new Position(0, 10));
        Range range2 = new Range(new Position(1, 0), new Position(1, 10));
        Diagnostic pos1Info1 = this.createDiagnostic("1", "message1", range1, DiagnosticSeverity.Error, "source1");
        Diagnostic pos1Info2 = this.createDiagnostic("2", "message2", range1, DiagnosticSeverity.Error, "source2");
        Diagnostic pos2Info2 = this.createDiagnostic("2", "message2", range2, DiagnosticSeverity.Error, "source2");
        this.confirmResourceChanges(file, pos1Info1, 1);
        this.confirmResourceChanges(file, pos1Info2, 1);
        this.confirmResourceChanges(file, pos2Info2, 1);
        this.confirmResourceChanges(file, pos1Info1, 1);
        this.confirmResourceChanges(file, pos1Info1, 0);
    }

    @Test
    public void testDiagnosticsOnExternalFile() throws Exception {
        MockLanguageServer.INSTANCE.setDiagnostics(List.of(new Diagnostic(new Range(new Position(0, 0), new Position(0, 1)), "This is a warning", DiagnosticSeverity.Warning, null)));
        File file = TestUtils.createTempFile("testDiagnosticsOnExternalFile", ".lspt");
        Font font = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write(97);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)IDE.openEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI())));
            StyledText widget = viewer.getTextWidget();
            FontData biggerFont = new FontData();
            biggerFont.setHeight(40);
            biggerFont.setLocale(widget.getFont().getFontData()[0].getLocale());
            biggerFont.setName(widget.getFont().getFontData()[0].getName());
            biggerFont.setStyle(widget.getFont().getFontData()[0].getStyle());
            font = new Font((Device)widget.getDisplay(), biggerFont);
            widget.setFont(font);
            RGB warningColor = new RGB(244, 200, 45);
            TestUtils.waitForAndAssertCondition(10000, widget.getDisplay(), () -> ColorTest.containsColor((Control)widget, warningColor, 10));
        }
        finally {
            if (font != null) {
                font.dispose();
            }
        }
    }

    private void confirmResourceChanges(IFile file, Diagnostic diagnostic, int expectedChanges) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        MarkerRedrawCountListener redrawCountListener = new MarkerRedrawCountListener();
        workspace.addResourceChangeListener((IResourceChangeListener)redrawCountListener);
        try {
            this.diagnosticsToMarkers.accept(new PublishDiagnosticsParams(file.getLocationURI().toString(), List.of(diagnostic)));
            TestUtils.waitForAndAssertCondition(10000, () -> {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.lsp4e.diagnostic", false, 2);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    if (marker.getAttribute("lspDiagnostic").equals(diagnostic)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            });
            TestUtils.waitForAndAssertCondition(10000, () -> {
                Assertions.assertEquals((int)expectedChanges, (int)redrawCountListener.getAsInt());
                return true;
            });
        }
        finally {
            workspace.removeResourceChangeListener((IResourceChangeListener)redrawCountListener);
        }
    }

    private Diagnostic createDiagnostic(String code, String message, Range range, DiagnosticSeverity severity, String source) {
        Diagnostic diagnostic = new Diagnostic();
        diagnostic.setCode(code);
        diagnostic.setMessage(message);
        diagnostic.setRange(range);
        diagnostic.setSeverity(severity);
        diagnostic.setSource(source);
        return diagnostic;
    }

    private static final class MarkerRedrawCountListener
    implements IResourceChangeListener,
    IntSupplier {
        private int resourceChanges = 0;

        private MarkerRedrawCountListener() {
        }

        @Override
        public int getAsInt() {
            return this.resourceChanges;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            IResourceDelta[] childDeltas = delta.getAffectedChildren();
            if (childDeltas.length == 0) {
                return;
            }
            if ((childDeltas = childDeltas[0].getAffectedChildren()).length == 0 || childDeltas[0].getMarkerDeltas().length == 0) {
                return;
            }
            ++this.resourceChanges;
        }
    }
}

