/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.client.DockerConfig;
import org.mandas.docker.client.DockerCredentialHelper;
import org.mandas.docker.client.DockerHost;
import org.mandas.docker.client.ObjectMapperProvider;
import org.mandas.docker.client.messages.DockerCredentialHelperAuth;
import org.mandas.docker.client.messages.RegistryAuth;
import org.mandas.docker.client.messages.RegistryConfigs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerConfigReader {
    private static final Logger LOG = LoggerFactory.getLogger(DockerConfigReader.class);
    private static final ObjectMapper MAPPER = ObjectMapperProvider.objectMapper();

    public RegistryAuth anyRegistryAuth() throws IOException {
        return this.anyRegistryAuth(this.defaultConfigPath());
    }

    RegistryAuth anyRegistryAuth(Path configPath) throws IOException {
        Collection<RegistryAuth> registryAuths = this.authForAllRegistries(configPath).configs().values();
        return registryAuths.isEmpty() ? RegistryAuth.builder().build() : registryAuths.iterator().next();
    }

    public RegistryConfigs authForAllRegistries(Path configPath) throws IOException {
        Objects.requireNonNull(configPath);
        DockerConfig config = (DockerConfig)MAPPER.readValue(configPath.toFile(), DockerConfig.class);
        if (config == null) {
            return RegistryConfigs.empty();
        }
        RegistryConfigs.Builder registryConfigsBuilder = RegistryConfigs.builder();
        Map<String, String> credHelpers = config.credHelpers();
        boolean hasCredHelpers = credHelpers != null && !credHelpers.isEmpty();
        Map<String, RegistryAuth> auths = config.auths();
        boolean hasAuths = auths != null && !auths.isEmpty();
        String credsStore = config.credsStore();
        boolean hasCredsStore = credsStore != null;
        HashSet<String> addedRegistries = new HashSet<String>();
        if (hasCredHelpers) {
            for (Map.Entry<String, String> credHelpersEntry : credHelpers.entrySet()) {
                String registry = credHelpersEntry.getKey();
                String aCredsStore = credHelpersEntry.getValue();
                if (addedRegistries.contains(registry)) continue;
                addedRegistries.add(registry);
                RegistryAuth authWithCredentialHelper = this.authWithCredentialHelper(aCredsStore, registry);
                if (authWithCredentialHelper == null) continue;
                registryConfigsBuilder.addConfig(registry, authWithCredentialHelper);
            }
        }
        if (hasAuths) {
            RegistryAuth empty = RegistryAuth.builder().build();
            for (Map.Entry<String, RegistryAuth> authEntry : auths.entrySet()) {
                String registry = authEntry.getKey();
                if (addedRegistries.contains(registry)) continue;
                addedRegistries.add(registry);
                RegistryAuth registryAuth = authEntry.getValue();
                if (registryAuth == null || registryAuth.equals(empty)) {
                    if (!hasCredsStore) continue;
                    registryConfigsBuilder.addConfig(registry, this.authWithCredentialHelper(credsStore, registry));
                    continue;
                }
                registryConfigsBuilder.addConfig(registry, registryAuth.toBuilder().serverAddress(registry).build());
            }
        }
        if (!(hasAuths || hasCredHelpers || hasCredsStore)) {
            try {
                return (RegistryConfigs)MAPPER.readValue(configPath.toFile(), RegistryConfigs.class);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return registryConfigsBuilder.build();
    }

    public RegistryAuth authForRegistry(Path configPath, String registry) throws IOException {
        Objects.requireNonNull(configPath);
        Objects.requireNonNull(registry);
        DockerConfig config = (DockerConfig)MAPPER.readValue(configPath.toFile(), DockerConfig.class);
        if (config == null) {
            return RegistryAuth.builder().build();
        }
        RegistryAuth registryAuth = this.authForRegistry(config, registry);
        if (registryAuth != null) {
            return registryAuth;
        }
        try {
            URI serverAddressUri = new URI(registry);
            if (serverAddressUri.getScheme() == null) {
                for (String proto : Arrays.asList("https://", "http://")) {
                    RegistryAuth protoRegistryAuth = this.authForRegistry(config, proto + registry);
                    if (protoRegistryAuth == null) continue;
                    return protoRegistryAuth;
                }
            }
        }
        catch (URISyntaxException e) {
            LOG.error("Invalid URI", (Throwable)e);
        }
        throw new IllegalArgumentException("registry \"" + registry + "\" does not appear in config file at " + String.valueOf(configPath));
    }

    private RegistryAuth authForRegistry(DockerConfig config, String registry) throws IOException {
        Map<String, RegistryAuth> auths = config.auths();
        if (auths != null && auths.get(registry) != null) {
            return auths.get(registry).toBuilder().serverAddress(registry).build();
        }
        String credsStore = this.getCredentialStore(config, registry);
        if (credsStore != null) {
            return this.authWithCredentialHelper(credsStore, registry);
        }
        return null;
    }

    public Path defaultConfigPath() {
        if (DockerHost.configPathFromEnv() != null) {
            Path dockerConfig = Paths.get(DockerHost.configPathFromEnv(), "config.json");
            LOG.debug("Using config path from DOCKER_CONFIG: {}", (Object)dockerConfig);
            return dockerConfig;
        }
        String home = System.getProperty("user.home");
        Path dockerConfig = Paths.get(home, ".docker", "config.json");
        Path dockerCfg = Paths.get(home, ".dockercfg");
        if (Files.exists(dockerConfig, new LinkOption[0])) {
            LOG.debug("Using configfile: {}", (Object)dockerConfig);
            return dockerConfig;
        }
        LOG.debug("Using configfile: {} ", (Object)dockerCfg);
        return dockerCfg;
    }

    private RegistryAuth authWithCredentialHelper(String credsStore, String registry) throws IOException {
        DockerCredentialHelperAuth dockerCredentialHelperAuth = DockerCredentialHelper.get(credsStore, registry);
        return dockerCredentialHelperAuth == null ? null : dockerCredentialHelperAuth.toRegistryAuth();
    }

    private String getCredentialStore(DockerConfig config, String registry) {
        Objects.requireNonNull(config, "Docker config cannot be null");
        Objects.requireNonNull(registry, "registry cannot be null");
        Map<String, String> credHelpers = config.credHelpers();
        return credHelpers != null && credHelpers.containsKey(registry) ? credHelpers.get(registry) : config.credsStore();
    }
}

