/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.core;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerOpenConnectionException;
import org.eclipse.linuxtools.docker.core.DockerPingConnectionException;
import org.eclipse.terminal.view.core.ITerminalService;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends Plugin {
    private static BundleContext context;
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.docker.core";
    private static Activator plugin;
    private static ServiceTracker<ITerminalService, ITerminalService> serviceTracker;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        DockerConnectionManager.getInstance();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        if (Activator.getDefault() != null && Activator.getDefault().getLog() != null) {
            Activator.getDefault().getLog().log(status);
        }
    }

    public static void logWarningMessage(String message) {
        Activator.log(Status.warning((String)message));
    }

    public static void logErrorMessage(String message, Throwable e) {
        Activator.log(Status.error((String)message, (Throwable)e));
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : (e instanceof DockerPingConnectionException || e instanceof DockerOpenConnectionException ? Status.info((String)e.getMessage()) : Status.error((String)e.getMessage(), (Throwable)e));
        Activator.log(status);
    }

    public static synchronized ITerminalService getTerminalService() {
        if (serviceTracker == null) {
            serviceTracker = new ServiceTracker(Activator.getDefault().getBundle().getBundleContext(), ITerminalService.class, null);
            serviceTracker.open();
        }
        return (ITerminalService)serviceTracker.getService();
    }
}

