/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.broker.artemis.xml;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.kura.broker.artemis.core.ServerConfiguration;
import org.eclipse.kura.broker.artemis.core.ServerManager;
import org.eclipse.kura.broker.artemis.core.UserAuthentication;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceComponent
implements ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(ServiceComponent.class);
    private ServerConfiguration configuration;
    private ServerManager server;

    public void activate(Map<String, Object> properties) throws Exception {
        ServerConfiguration cfg = this.parse(properties);
        if (cfg != null) {
            this.start(cfg);
        }
    }

    public void modified(Map<String, Object> properties) throws Exception {
        ServerConfiguration cfg = this.parse(properties);
        if (this.configuration == cfg) {
            logger.debug("Configuration identical .... skipping update");
            return;
        }
        if (this.configuration != null && this.configuration.equals(cfg)) {
            logger.debug("Configuration equal .... skipping update");
            return;
        }
        this.stop();
        if (cfg != null) {
            this.start(cfg);
        }
    }

    public void deactivate() throws Exception {
        this.stop();
    }

    private void start(ServerConfiguration configuration) throws Exception {
        logger.info("Starting Artemis");
        this.server = new ServerManager(configuration);
        this.server.start();
        this.configuration = configuration;
    }

    private void stop() throws Exception {
        logger.info("Stopping Artemis");
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
        this.configuration = null;
    }

    private ServerConfiguration parse(Map<String, Object> properties) {
        if (!Boolean.TRUE.equals(properties.get("enabled"))) {
            return null;
        }
        String brokerXml = (String)properties.get("brokerXml");
        if (brokerXml == null || brokerXml.isEmpty()) {
            return null;
        }
        Set<String> requiredProtocols = this.parseRequiredProtocols(properties);
        UserAuthentication.Builder auth = new UserAuthentication.Builder();
        String defaultUser = (String)properties.get("defaultUser");
        if (defaultUser != null) {
            auth.defaultUser(defaultUser);
        }
        auth.parseUsers((String)properties.get("users"));
        ServerConfiguration cfg = new ServerConfiguration();
        cfg.setBrokerXml(brokerXml);
        cfg.setRequiredProtocols(requiredProtocols);
        cfg.setUserAuthentication(auth.build());
        return cfg;
    }

    private Set<String> parseRequiredProtocols(Map<String, Object> properties) {
        HashSet<String> requiredProtocols = new HashSet<String>();
        Object v = properties.get("requiredProtocols");
        if (v instanceof String[]) {
            requiredProtocols.addAll(Arrays.asList((String[])v));
        } else if (v instanceof String) {
            String vs = (String)v;
            String[] reqs = vs.split("\\s*,\\s*");
            requiredProtocols.addAll(Arrays.asList(reqs));
        }
        return requiredProtocols;
    }
}

