/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.broker.artemis.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.eclipse.kura.broker.artemis.core.internal.ProtocolTrackerListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolTracker {
    private static final Logger logger = LoggerFactory.getLogger(ProtocolTracker.class);
    private final BundleContext context;
    private final Map<String, Collection<ProtocolManagerFactory<?>>> protocols = new HashMap();
    private final ServiceTrackerCustomizer<ProtocolManagerFactory, ProtocolManagerFactory> customizer = new ServiceTrackerCustomizer<ProtocolManagerFactory, ProtocolManagerFactory>(){

        public ProtocolManagerFactory addingService(ServiceReference<ProtocolManagerFactory> reference) {
            ProtocolManagerFactory service = (ProtocolManagerFactory)ProtocolTracker.this.context.getService(reference);
            ProtocolTracker.this.addProtocols(service);
            return service;
        }

        public void modifiedService(ServiceReference<ProtocolManagerFactory> reference, ProtocolManagerFactory service) {
        }

        public void removedService(ServiceReference<ProtocolManagerFactory> reference, ProtocolManagerFactory service) {
            ProtocolTracker.this.removeProtocols(service);
            ProtocolTracker.this.context.ungetService(reference);
        }
    };
    private final ServiceTracker<ProtocolManagerFactory, ProtocolManagerFactory> tracker;
    private final ProtocolTrackerListener listener;

    public ProtocolTracker(BundleContext context, ProtocolTrackerListener listener) {
        this.context = context;
        this.listener = listener;
        this.tracker = new ServiceTracker(context, ProtocolManagerFactory.class, this.customizer);
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    protected synchronized void addProtocols(ProtocolManagerFactory<?> factory) {
        HashSet<String> referencedProtocols = new HashSet<String>(Arrays.asList(factory.getProtocols()));
        for (String protocol : referencedProtocols) {
            logger.info("Adding protocol - {} -> {}", (Object)protocol, factory);
            this.addProtocol(protocol, factory);
        }
        if (this.listener != null) {
            this.listener.protocolsAdded(referencedProtocols);
        }
    }

    protected synchronized void removeProtocols(ProtocolManagerFactory<?> factory) {
        HashSet<String> referencedProtocols = new HashSet<String>(Arrays.asList(factory.getProtocols()));
        for (String protocol : referencedProtocols) {
            logger.info("Removing protocol - {} -> {}", (Object)protocol, factory);
            this.removeProtocol(protocol, factory);
        }
        if (this.listener != null) {
            this.listener.protocolsRemoved(referencedProtocols);
        }
    }

    public synchronized Collection<ProtocolManagerFactory<?>> resolveProtocols(Set<String> requiredProtocols) {
        HashMap<String, ProtocolManagerFactory> result = new HashMap<String, ProtocolManagerFactory>();
        for (String string : requiredProtocols) {
            Collection factories = this.protocols.getOrDefault(string, Collections.emptyList());
            if (factories.isEmpty()) {
                return null;
            }
            result.put(string, (ProtocolManagerFactory)factories.iterator().next());
        }
        block1: for (Map.Entry entry : this.protocols.entrySet()) {
            String protocol = (String)entry.getKey();
            Collection factories = (Collection)entry.getValue();
            for (ProtocolManagerFactory factory : factories) {
                if (result.containsKey(protocol)) continue;
                result.put(protocol, factory);
                continue block1;
            }
        }
        return result.values();
    }

    private void addProtocol(String protocol, ProtocolManagerFactory<?> factory) {
        this.protocols.computeIfAbsent(protocol, p -> new ArrayList()).add(factory);
    }

    private void removeProtocol(String protocol, ProtocolManagerFactory<?> factory) {
        this.protocols.compute(protocol, (p, factories) -> {
            if (factories == null) {
                return null;
            }
            factories.remove(factory);
            return factories.isEmpty() ? null : factories;
        });
    }
}

