/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.kura.web.shared.IdHelper;
import org.eclipse.kura.web.shared.model.GwtConfigParameter;
import org.eclipse.kura.web.shared.model.KuraBaseModel;

public class GwtConfigComponent
extends KuraBaseModel
implements Serializable {
    private static final long serialVersionUID = -6388356998309026758L;
    private List<GwtConfigParameter> m_parameters = new ArrayList<GwtConfigParameter>();

    public GwtConfigComponent() {
    }

    public GwtConfigComponent(GwtConfigComponent other) {
        this();
        this.data.putAll(other.data);
        for (GwtConfigParameter parameter : other.m_parameters) {
            this.m_parameters.add(new GwtConfigParameter(parameter));
        }
    }

    public String getComponentDescription() {
        return (String)this.get("componentDescription");
    }

    public String getComponentIcon() {
        return (String)this.get("componentIcon");
    }

    public String getComponentId() {
        return (String)this.get("componentId");
    }

    public String getComponentName() {
        return (String)this.get("componentName");
    }

    public String getFactoryId() {
        return (String)this.get("factoryPid");
    }

    public GwtConfigParameter getParameter(String id) {
        for (GwtConfigParameter param : this.m_parameters) {
            if (!id.equals(param.getId())) continue;
            return param;
        }
        return null;
    }

    public List<GwtConfigParameter> getParameters() {
        return this.m_parameters;
    }

    public boolean isFactoryComponent() {
        if (this.get("factoryComponent") != null) {
            return (Boolean)this.get("factoryComponent");
        }
        return false;
    }

    public boolean isWireComponent() {
        if (this.get("isWireComponent") != null) {
            return (Boolean)this.get("isWireComponent");
        }
        return false;
    }

    public boolean isDriver() {
        if (this.get("isDriver") != null) {
            return (Boolean)this.get("isDriver");
        }
        return false;
    }

    public void setComponentDescription(String componentDescription) {
        this.set("componentDescription", componentDescription);
    }

    public void setComponentIcon(String componentIcon) {
        this.set("componentIcon", componentIcon);
    }

    public void setComponentId(String componentId) {
        this.set("componentId", componentId);
    }

    public void setComponentName(String componentName) {
        this.set("componentName", componentName);
    }

    public void setFactoryComponent(boolean isFactory) {
        this.set("factoryComponent", isFactory);
    }

    public void setFactoryPid(String factoryPid) {
        this.set("factoryPid", factoryPid);
    }

    public void setParameters(List<GwtConfigParameter> parameters) {
        this.m_parameters = parameters;
    }

    public void setIsWireComponent(boolean isWireComponent) {
        this.set("isWireComponent", isWireComponent);
    }

    public void setIsDriver(boolean isDriver) {
        this.set("isDriver", isDriver);
    }

    public boolean isValid() {
        return this.getComponentId() != null && this.getFactoryId() != null && this.getParameters() != null;
    }

    public String getParameterValue(String id) {
        for (GwtConfigParameter param : this.m_parameters) {
            if (!id.equals(param.getId())) continue;
            return param.getValue();
        }
        return null;
    }

    public String getOCDComponentHeader() {
        if (this.get("factoryPid") != null) {
            return IdHelper.getLastIdComponent(this.get("factoryPid") + " - " + this.get("componentName"));
        }
        if (this.get("componentId") != null) {
            return String.valueOf(IdHelper.getLastIdComponent((String)this.get("componentId"))) + " - " + this.get("componentName");
        }
        return (String)this.get("componentName");
    }
}

