/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.metatype.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.equinox.metatype.EquinoxMetaTypeInformation;
import org.eclipse.equinox.metatype.EquinoxMetaTypeService;
import org.eclipse.equinox.metatype.impl.MetaTypeInformationImpl;
import org.eclipse.equinox.metatype.impl.MetaTypeMsg;
import org.eclipse.equinox.metatype.impl.MetaTypeProviderTracker;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaTypeServiceImpl
implements EquinoxMetaTypeService,
SynchronousBundleListener {
    SAXParserFactory _parserFactory;
    private Hashtable<Long, EquinoxMetaTypeInformation> _mtps = new Hashtable(7);
    private final LogService logger;
    private final ServiceTracker<Object, Object> metaTypeProviderTracker;

    public MetaTypeServiceImpl(SAXParserFactory parserFactory, LogService logger, ServiceTracker<Object, Object> metaTypeProviderTracker) {
        this._parserFactory = parserFactory;
        this.logger = logger;
        this.metaTypeProviderTracker = metaTypeProviderTracker;
    }

    @Override
    public EquinoxMetaTypeInformation getMetaTypeInformation(Bundle bundle) {
        return this.getMetaTypeProvider(bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EquinoxMetaTypeInformation getMetaTypeProvider(final Bundle b) {
        final LogService loggerTemp = this.logger;
        final ServiceTracker<Object, Object> tracker = this.metaTypeProviderTracker;
        Long bID = b.getBundleId();
        Hashtable<Long, EquinoxMetaTypeInformation> hashtable = this._mtps;
        synchronized (hashtable) {
            if (this._mtps.containsKey(bID)) {
                return this._mtps.get(bID);
            }
            EquinoxMetaTypeInformation mti = AccessController.doPrivileged(new PrivilegedAction<EquinoxMetaTypeInformation>(){

                @Override
                public EquinoxMetaTypeInformation run() {
                    MetaTypeInformationImpl impl = null;
                    try {
                        impl = new MetaTypeInformationImpl(b, MetaTypeServiceImpl.this.newParser(), loggerTemp);
                    }
                    catch (Exception e) {
                        loggerTemp.log(1, NLS.bind((String)MetaTypeMsg.METADATA_PARSE_ERROR, (Object)b.getBundleId(), (Object)b.getSymbolicName()), (Throwable)e);
                    }
                    if (impl == null || !impl._isThereMeta) {
                        return new MetaTypeProviderTracker(b, loggerTemp, (ServiceTracker<Object, Object>)tracker);
                    }
                    return impl;
                }
            });
            this._mtps.put(bID, mti);
            return mti;
        }
    }

    SAXParser newParser() throws ParserConfigurationException, SAXException {
        boolean namespaceAware = this._parserFactory.isNamespaceAware();
        boolean validating = this._parserFactory.isValidating();
        this._parserFactory.setValidating(false);
        try {
            if (namespaceAware) {
                SAXParser sAXParser = this._parserFactory.newSAXParser();
                return sAXParser;
            }
            this._parserFactory.setNamespaceAware(true);
            try {
                SAXParser sAXParser = this._parserFactory.newSAXParser();
                return sAXParser;
            }
            catch (Exception exception) {
                this._parserFactory.setNamespaceAware(false);
                SAXParser sAXParser = this._parserFactory.newSAXParser();
                this._parserFactory.setNamespaceAware(namespaceAware);
                this._parserFactory.setValidating(validating);
                return sAXParser;
            }
        }
        finally {
            this._parserFactory.setNamespaceAware(namespaceAware);
            this._parserFactory.setValidating(validating);
        }
    }

    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        Long bID = event.getBundle().getBundleId();
        switch (type) {
            case 8: 
            case 16: {
                this._mtps.remove(bID);
                break;
            }
        }
    }
}

