/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.operations;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.glsp.server.internal.registry.MapRegistry;
import org.eclipse.glsp.server.internal.util.ReflectionUtil;
import org.eclipse.glsp.server.operations.CreateOperation;
import org.eclipse.glsp.server.operations.CreateOperationHandler;
import org.eclipse.glsp.server.operations.Operation;
import org.eclipse.glsp.server.operations.OperationHandler;
import org.eclipse.glsp.server.operations.OperationHandlerRegistry;

public class DefaultOperationHandlerRegistry
implements OperationHandlerRegistry {
    private final MapRegistry<String, OperationHandler<?>> internalRegistry;
    private final Map<String, Operation> operations = new HashMap<String, Operation>();

    @Inject
    public DefaultOperationHandlerRegistry(Set<OperationHandler<?>> handlers) {
        this.internalRegistry = new MapRegistry<String, OperationHandler<?>>(){};
        handlers.forEach(handler -> ReflectionUtil.construct(handler.getHandledOperationType()).ifPresent(operation -> {
            boolean bl = this.register((Operation)operation, (OperationHandler<?>)handler);
        }));
    }

    protected String deriveKey(Operation key) {
        String elementTypeId = key instanceof CreateOperation ? ((CreateOperation)key).getElementTypeId() : null;
        return this.deriveKey(key, elementTypeId);
    }

    protected String deriveKey(Operation key, String elementTypeId) {
        String derivedKey = key.getClass().getName();
        if (elementTypeId != null) {
            return derivedKey + "_" + elementTypeId;
        }
        return derivedKey;
    }

    @Override
    public boolean register(Operation key, OperationHandler<?> handler) {
        if (handler instanceof CreateOperationHandler) {
            return ((CreateOperationHandler)handler).getHandledElementTypeIds().stream().allMatch(typeId -> this.internalRegistry.register(this.deriveKey(key, (String)typeId), handler));
        }
        String strKey = this.deriveKey(key, null);
        this.operations.put(strKey, key);
        return this.internalRegistry.register(strKey, handler);
    }

    @Override
    public boolean deregister(Operation key) {
        return this.internalRegistry.deregister(this.deriveKey(key));
    }

    @Override
    public boolean hasKey(Operation key) {
        return this.internalRegistry.hasKey(this.deriveKey(key));
    }

    @Override
    public Optional<OperationHandler<?>> get(Operation key) {
        return this.internalRegistry.get(this.deriveKey(key));
    }

    @Override
    public Set<OperationHandler<?>> getAll() {
        return this.internalRegistry.getAll();
    }

    @Override
    public Set<Operation> keys() {
        return this.internalRegistry.keys().stream().map(this.operations::get).collect(Collectors.toSet());
    }
}

