/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.tooldef.typechecker;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.escet.common.app.framework.PlatformUtils;
import org.eclipse.escet.common.java.TextPosition;
import org.eclipse.escet.common.java.UncachedUrlClassLoader;
import org.eclipse.escet.common.typechecker.SemanticException;
import org.eclipse.escet.tooldef.common.ClassLoaderObtainer;
import org.eclipse.escet.tooldef.typechecker.CheckerContext;
import org.eclipse.escet.tooldef.typechecker.Message;
import org.osgi.framework.Bundle;

public class ImportClassLoaderObtainer
extends ClassLoaderObtainer {
    private final TextPosition pos;
    private final CheckerContext ctxt;
    private final String useText;

    public ImportClassLoaderObtainer(TextPosition pos, CheckerContext ctxt, String useText) {
        this.pos = pos;
        this.ctxt = ctxt;
        this.useText = useText;
    }

    protected RuntimeException createNotPluginProjException(String name) {
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_NOT_PLUGIN, this.pos, this.useText, name);
        return new SemanticException();
    }

    protected RuntimeException createPluginClassicFormatException(String name) {
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_CLASSIC_FORMAT, this.pos, this.useText, name);
        return new SemanticException();
    }

    protected RuntimeException createComputeClassPathException(String name, CoreException ex) {
        String exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "no additional details available.";
        }
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_NO_JAVA_NATURE, this.pos, this.useText, name, exMsg);
        return new SemanticException();
    }

    protected RuntimeException createMalformedUrlException(String name, MalformedURLException ex) {
        String exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "no additional details available.";
        }
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_MALFORMED_URL, this.pos, this.useText, name, exMsg);
        return new SemanticException();
    }

    protected RuntimeException createOpenUrlException(String name, UncachedUrlClassLoader.OpenUrlException ex) {
        String exMsg = ex.getMessage();
        if (exMsg == null) {
            exMsg = "no additional details available.";
        }
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_OPEN_URL, this.pos, this.useText, name, ex.url.toString(), exMsg);
        return new SemanticException();
    }

    protected RuntimeException createNotFoundException(String name) {
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_NOT_FOUND, this.pos, name);
        return new SemanticException();
    }

    protected RuntimeException createWrongStateException(String name, Bundle bundle, int state) {
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_STATE, this.pos, this.useText, name, PlatformUtils.getStateName((Bundle)bundle));
        return new SemanticException();
    }

    protected RuntimeException createNoClassLoaderException(String name, Bundle bundle) {
        this.ctxt.addProblem(Message.IMPORT_PLUGIN_ADAPT, this.pos, this.useText, name);
        return new SemanticException();
    }
}

