/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.ssh;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.shell.ShellFactory;
import org.eclipse.equinox.console.ssh.SshShell;
import org.osgi.framework.BundleContext;

public class SshShellFactory
implements ShellFactory {
    private final List<CommandProcessor> processors;
    private final BundleContext context;
    private final Set<SshShell> shells = new HashSet<SshShell>();

    public SshShellFactory(List<CommandProcessor> processors, BundleContext context) {
        this.processors = processors;
        this.context = context;
    }

    public synchronized Command createShell(ChannelSession channel) {
        SshShell shell = new SshShell(this.processors, this.context);
        this.shells.add(shell);
        return shell;
    }

    public synchronized void addCommandProcessor(CommandProcessor processor) {
        this.processors.add(processor);
        for (SshShell shell : this.shells) {
            shell.addCommandProcessor(processor);
        }
    }

    public synchronized void removeCommandProcessor(CommandProcessor processor) {
        this.processors.remove(processor);
        for (SshShell shell : this.shells) {
            shell.removeCommandProcessor(processor);
        }
    }

    public void exit() {
        for (SshShell shell : this.shells) {
            shell.onExit();
        }
    }
}

