/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.dap.variables;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.epsilon.eol.dap.variables.IVariableReference;
import org.eclipse.epsilon.eol.dap.variables.SuspendedState;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.types.EolAnyType;
import org.eclipse.epsilon.eol.types.EolPrimitiveType;
import org.eclipse.epsilon.eol.types.EolType;

public abstract class IdentifiableReference<T>
implements IVariableReference {
    public static final EolType[] PREDEFINED_TYPES = new EolType[]{EolPrimitiveType.Integer, EolPrimitiveType.Boolean, EolPrimitiveType.Real, EolPrimitiveType.String};
    protected final IEolContext context;
    protected final T target;
    protected int id;

    public IdentifiableReference(IEolContext context, T t) {
        this.context = context;
        this.target = t;
    }

    public T getTarget() {
        return this.target;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public IEolContext getContext() {
        return this.context;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getValue() {
        return "" + this.target;
    }

    @Override
    public String getTypeName() {
        if (this.target == null) {
            return new EolAnyType().getName();
        }
        EolType[] eolTypeArray = PREDEFINED_TYPES;
        int n = PREDEFINED_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            EolType type = eolTypeArray[n2];
            if (type.isKind(this.target)) {
                return type.getName();
            }
            ++n2;
        }
        return this.target.getClass().getName();
    }

    @Override
    public List<IVariableReference> getVariables(SuspendedState state) {
        return Collections.emptyList();
    }

    public int hashCode() {
        return System.identityHashCode(this.target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentifiableReference other = (IdentifiableReference)obj;
        return Objects.equals(this.target, other.target);
    }
}

