/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.resultSet.resultSet45;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class resultSetClient45
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.resultSet.resultSet45";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private Statement stmt = null;
    private DataSource ds1 = null;
    private String drManager = null;
    private String sqlStmt = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private Properties props = null;
    private Properties sqlp = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        resultSetClient45 theTests = new resultSetClient45();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.props = p;
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.rsSch = new rsSchema();
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString41() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Smallint_Query_Min", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            this.msg.setMsg("get the Minimum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            oRetVal = oRetVal.trim();
            sExtVal = sExtVal.trim();
            Short intRetVal = new Short(oRetVal);
            Short intExtVal = new Short(sExtVal);
            this.msg.addOutputMsg("" + intExtVal, "" + intRetVal);
            if (intRetVal.equals(intExtVal)) {
                this.msg.setMsg("getString returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the Minimum Value", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString42() throws Exception {
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Smallint_Query_Null", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(NullValue)");
            this.msg.setMsg("get the null value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            if (oRetVal == null) {
                this.msg.setMsg("getString returns the null value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the null value", "test getString Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString43() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Integer_Query_Max", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            this.msg.setMsg("get the Maximum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            oRetVal = oRetVal.trim();
            sExtVal = sExtVal.trim();
            Integer intRetVal = new Integer(oRetVal);
            Integer intExtVal = new Integer(sExtVal);
            this.msg.addOutputMsg("" + intExtVal, "" + intRetVal);
            if (intRetVal.equals(intExtVal)) {
                this.msg.setMsg("getString returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the Maximum Value", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString44() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Integer_Query_Min", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            this.msg.setMsg("get the Minimum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Integer_Tab", 2, this.sqlp, this.conn);
            oRetVal = oRetVal.trim();
            sExtVal = sExtVal.trim();
            Integer intRetVal = new Integer(oRetVal);
            Integer intExtVal = new Integer(sExtVal);
            this.msg.addOutputMsg("" + intExtVal, "" + intRetVal);
            if (intRetVal.equals(intExtVal)) {
                this.msg.setMsg("getString returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the Minimum Value", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString45() throws Exception {
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Integer_Query_Null", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(NullValue)");
            this.msg.setMsg("get the null value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            if (oRetVal == null) {
                this.msg.setMsg("getString returns the null value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the null value", "test getString Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString47() throws Exception {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Real_Query_Min", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            this.msg.setMsg("get the Minimum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Real_Tab", 2, this.sqlp, this.conn);
            oRetVal = oRetVal.trim();
            sExtVal = sExtVal.trim();
            Float fltRetVal = new Float(oRetVal);
            Float fltExtVal = new Float(sExtVal);
            this.msg.addOutputMsg("" + fltExtVal, "" + fltRetVal);
            if (fltRetVal.equals(fltExtVal)) {
                this.msg.setMsg("getString returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the Minimum Value", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString48() throws Exception {
        try {
            this.rsSch.createTab("Real_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Real_Query_Null", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(NullValue)");
            this.msg.setMsg("get the null value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            if (oRetVal == null) {
                this.msg.setMsg("getString returns the null value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the null value", "test getString Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Real_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString53() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Float_Query_Min", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            this.msg.setMsg("get the Minimum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Float_Tab", 2, this.sqlp, this.conn);
            oRetVal = oRetVal.trim();
            sExtVal = sExtVal.trim();
            Double dbRetVal = new Double(oRetVal);
            Double dbExtVal = new Double(sExtVal);
            if (dbRetVal.equals(dbExtVal)) {
                this.msg.setMsg("getString returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the Minimum Value", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString54() throws Exception {
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Float_Query_Null", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(NullValue)");
            this.msg.setMsg("get the null value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            if (oRetVal == null) {
                this.msg.setMsg("getString returns the null value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the null value", "test getString Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString58() throws Exception {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Decimal_Query_Max", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling.. ResultSet.getString(MaximumValue)");
            this.msg.setMsg("get the Maximum value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            this.msg.setMsg("get the Maximum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Decimal_Tab", 1, this.sqlp, this.conn);
            oRetVal = oRetVal.trim();
            sExtVal = sExtVal.trim();
            BigDecimal bdRetVal = new BigDecimal(oRetVal);
            BigDecimal bdExtVal = new BigDecimal(sExtVal);
            this.msg.addOutputMsg(String.valueOf(bdExtVal), String.valueOf(bdRetVal));
            if (bdRetVal.compareTo(bdExtVal) == 0) {
                this.msg.setMsg("getString returns the Maximum Value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the Maximum Value", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString59() throws Exception {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Decimal_Query_Min", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(MinimumValue)");
            this.msg.setMsg("get the Minimum value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            this.msg.setMsg("get the Minimum value from the Insert String");
            String sExtVal = this.rsSch.extractVal("Decimal_Tab", 2, this.sqlp, this.conn);
            oRetVal = oRetVal.trim();
            sExtVal = sExtVal.trim();
            BigDecimal bdRetVal = new BigDecimal(oRetVal);
            BigDecimal bdExtVal = new BigDecimal(sExtVal);
            this.msg.addOutputMsg(String.valueOf(bdExtVal), String.valueOf(bdRetVal));
            if (bdRetVal.compareTo(bdExtVal) == 0) {
                this.msg.setMsg("getString returns the Minimum Value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the Minimum Value", "test getString Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetString60() throws Exception {
        try {
            this.rsSch.createTab("Decimal_Tab", this.sqlp, this.conn);
            this.msg.setMsg("Execute the query and get the resultSet Object");
            String sQuery = this.sqlp.getProperty("Decimal_Query_Null", "");
            ResultSet oRes = this.stmt.executeQuery(sQuery);
            oRes.next();
            this.msg.setMsg("Calling ResultSet.getString(NullValue)");
            this.msg.setMsg("get the null value from the table using getString Method");
            ResultSetMetaData rsMetaData = oRes.getMetaData();
            String sColName = rsMetaData.getColumnName(1);
            String oRetVal = oRes.getString(sColName);
            if (oRetVal == null) {
                this.msg.setMsg("getString returns the null value " + oRetVal);
            } else {
                this.msg.printTestError("getString did not return the null value", "test getString Failed!");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getString is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getString is Failed!");
        }
        finally {
            try {
                this.stmt.close();
                this.rsSch.dropTab("Decimal_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

