/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.onexmanyuni;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.onexmanyuni.Customer1;
import ee.jakarta.tck.persistence.core.annotations.onexmanyuni.RetailOrder2;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long ORDER1_ID = 786L;
    private static final long ORDER2_ID = 787L;
    private static final long ORDER3_ID = 788L;
    private static final long ORDER4_ID = 789L;
    private static final double COST1 = 53.0;
    private static final double COST2 = 540.0;
    private static final double COST3 = 155.0;
    private static final double COST4 = 256.0;
    private static final long CUST1_ID = 2L;
    private static final long CUST2_ID = 4L;
    private static final String CUST1_NAME = "Ross";
    private static final String CUST2_NAME = "Joey";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            this.logErr("Exception:test failed ", e);
        }
    }

    public void oneXmanyUniJoinColumn() throws Exception {
        EntityManager em = this.getEntityManager();
        EntityTransaction tx = this.getEntityTransaction();
        Customer1 customer1 = this.createCustomer(2L, CUST1_NAME);
        Customer1 customer2 = this.createCustomer(4L, CUST2_NAME);
        RetailOrder2 order1 = this.createOrder(786L, 53.0);
        RetailOrder2 order2 = this.createOrder(787L, 540.0);
        RetailOrder2 order3 = this.createOrder(788L, 155.0);
        RetailOrder2 order4 = this.createOrder(789L, 256.0);
        try {
            tx.begin();
            em.persist((Object)customer1);
            em.persist((Object)customer2);
            em.flush();
            em.persist((Object)order1);
            em.persist((Object)order2);
            em.persist((Object)order3);
            em.persist((Object)order4);
            customer1.addOrder(order1);
            customer1.addOrder(order2);
            customer2.addOrder(order3);
            customer2.addOrder(order4);
            em.flush();
            this.logTrace("Test Passed");
        }
        catch (Exception e) {
            throw new Exception("Test failed" + String.valueOf(e));
        }
        finally {
            em.remove((Object)order1);
            em.remove((Object)order2);
            em.remove((Object)order3);
            em.remove((Object)order4);
            em.remove((Object)customer1);
            em.remove((Object)customer2);
            tx.commit();
        }
    }

    private RetailOrder2 createOrder(long id, double cost) {
        RetailOrder2 order = new RetailOrder2();
        order.setId(id);
        order.setCost(cost);
        return order;
    }

    private Customer1 createCustomer(long id, String name) {
        Customer1 customer = new Customer1();
        customer.setId(id);
        customer.setName(name);
        return customer;
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from CUSTOMER1").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from RETAILORDER2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

