/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.annotation.handlers;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.annotation.context.EjbContext;
import jakarta.ejb.ConcurrencyManagement;
import jakarta.ejb.ConcurrencyManagementType;
import java.lang.annotation.Annotation;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.ejb.deployment.annotation.handlers.AbstractAttributeHandler;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=ConcurrencyManagement.class)
public class ConcurrencyManagementHandler
extends AbstractAttributeHandler {
    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, EjbContext[] ejbContexts) throws AnnotationProcessorException {
        ConcurrencyManagement cmAn = (ConcurrencyManagement)ainfo.getAnnotation();
        ConcurrencyManagementType cmType = cmAn.value();
        for (EjbContext ejbContext : ejbContexts) {
            EjbDescriptor ejbDesc = ejbContext.getDescriptor();
            if (!(ejbDesc instanceof EjbSessionDescriptor)) continue;
            EjbSessionDescriptor.ConcurrencyManagementType descCMType = switch (cmType) {
                case ConcurrencyManagementType.CONTAINER -> EjbSessionDescriptor.ConcurrencyManagementType.Container;
                case ConcurrencyManagementType.BEAN -> EjbSessionDescriptor.ConcurrencyManagementType.Bean;
                default -> throw new AnnotationProcessorException("Unsupported concurrency management type = " + String.valueOf(cmType));
            };
            EjbSessionDescriptor sDesc = (EjbSessionDescriptor)ejbDesc;
            sDesc.setConcurrencyManagementTypeIfNotSet(descCMType);
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAnnotationTypes();
    }

    @Override
    protected boolean supportTypeInheritance() {
        return true;
    }
}

