/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.notification;

import com.sun.messaging.Destination;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.SequentialQueue;
import com.sun.messaging.jmq.jmsclient.notification.BrokerAddressListChangedEvent;
import com.sun.messaging.jmq.jmsclient.notification.ConnectionExitEvent;
import com.sun.messaging.jmq.jmsclient.resources.ClientResources;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jms.notification.ConnectionClosedEvent;
import com.sun.messaging.jms.notification.ConnectionClosingEvent;
import com.sun.messaging.jms.notification.ConnectionReconnectFailedEvent;
import com.sun.messaging.jms.notification.ConnectionReconnectedEvent;
import com.sun.messaging.jms.notification.ConsumerEvent;
import com.sun.messaging.jms.notification.Event;
import com.sun.messaging.jms.notification.EventListener;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class EventHandler
implements Runnable {
    private static final int CONSUMER_NOT_READY = 0;
    private static final int CONSUMER_READY = 1;
    private ConnectionImpl connection = null;
    private Thread handlerThread = null;
    protected static final String iMQEventHandler = "iMQEventHandler-";
    private SequentialQueue eventQueue = null;
    private boolean isClosed = false;
    private final HashMap<Destination, EventListener> consumerEventListeners = new HashMap();
    private boolean closedEventdelivered = false;
    private ExceptionListener exlistener = null;
    public static final long WAIT_TIMEOUT = 120000L;
    private boolean debug = Debug.debug;
    private static boolean debugEvent = Boolean.getBoolean("imq.debug.notification");

    public EventHandler(ConnectionImpl conn) {
        this.connection = conn;
        this.init();
    }

    private void init() {
        this.eventQueue = new SequentialQueue(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumerEventListener(Destination dest, EventListener listener) throws JMSException {
        if (this.isClosed) {
            throw new JMSException("Event handler is closed");
        }
        HashMap<Destination, EventListener> hashMap = this.consumerEventListeners;
        synchronized (hashMap) {
            this.consumerEventListeners.put(dest, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumerEventListener(Destination dest) throws JMSException {
        HashMap<Destination, EventListener> hashMap = this.consumerEventListeners;
        synchronized (hashMap) {
            if (this.consumerEventListeners.get(dest) == null) {
                throw new JMSException("XXXI18N -Consumer event listener for destination " + String.valueOf(dest) + " not found");
            }
            this.consumerEventListeners.remove(dest);
        }
    }

    private synchronized void onEvent(Event event) {
        if (debugEvent) {
            Debug.getPrintStream().println(String.valueOf(new Date()) + "-- event triggerred, code = " + event.getEventCode() + ", msg = " + event.getEventMessage());
        }
        if (this.isClosed) {
            return;
        }
        this.eventQueue.enqueue(event);
        if (this.handlerThread == null) {
            this.createHandlerThread();
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        this.isClosed = true;
        this.notifyAll();
        HashMap<Destination, EventListener> hashMap = this.consumerEventListeners;
        synchronized (hashMap) {
            this.consumerEventListeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHandlerThread() {
        EventHandler eventHandler = this;
        synchronized (eventHandler) {
            if (this.handlerThread == null) {
                this.handlerThread = new Thread(this);
                if (this.connection.hasDaemonThreads()) {
                    this.handlerThread.setDaemon(true);
                }
                this.handlerThread.setName(iMQEventHandler + this.connection.getLocalID());
                this.handlerThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean timeoutExit = false;
        boolean keepRunning = true;
        while (keepRunning) {
            timeoutExit = false;
            EventHandler eventHandler = this;
            synchronized (eventHandler) {
                if (this.shouldWait()) {
                    try {
                        this.wait(120000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (this.isClosed) {
                return;
            }
            if (this.eventQueue.isEmpty()) {
                timeoutExit = true;
            } else {
                Event event = (Event)this.eventQueue.dequeue();
                if (event instanceof ConsumerEvent) {
                    this.deliverConsumerEvent((ConsumerEvent)event);
                } else if (event instanceof ConnectionExitEvent) {
                    this.deliverException(event);
                } else {
                    this.deliverConnectionEvent(event);
                }
            }
            keepRunning = this.shouldContinue(timeoutExit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverException(Event event) {
        try {
            if (this.exlistener != null && !this.isClosed) {
                ConnectionExitEvent exitEvent = (ConnectionExitEvent)event;
                JMSException jmse = exitEvent.getJMSException();
                this.exlistener.onException(jmse);
                if (debugEvent) {
                    Debug.getPrintStream().println(String.valueOf(new Date()) + " Exception is delivered to the listener: " + String.valueOf(jmse));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.isClosed = true;
        }
    }

    private boolean shouldWait() {
        return this.eventQueue.isEmpty() && (this.connection.hasEventListener() || !this.consumerEventListeners.isEmpty()) && !this.isClosed;
    }

    private synchronized boolean shouldContinue(boolean timeoutExit) {
        boolean keepRunning = true;
        if (this.isClosed || timeoutExit && this.eventQueue.isEmpty()) {
            this.handlerThread = null;
            keepRunning = false;
        }
        return keepRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverConnectionEvent(Event event) {
        EventListener listener = this.connection.getEventListener();
        try {
            if (this.shouldDeliver(listener, event)) {
                listener.onEvent(event);
                if (debugEvent) {
                    Debug.getPrintStream().println(String.valueOf(new Date()) + "*** Delivered event, code = " + event.getEventCode() + ", msg = " + event.getEventMessage());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.postEventProcess(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverConsumerEvent(ConsumerEvent event) {
        Destination dest = event.getDestination();
        EventListener listener = null;
        HashMap<Destination, EventListener> hashMap = this.consumerEventListeners;
        synchronized (hashMap) {
            listener = this.consumerEventListeners.get(dest);
        }
        try {
            if (this.shouldDeliver(listener, event)) {
                listener.onEvent(event);
                if (debugEvent) {
                    Debug.getPrintStream().println(String.valueOf(new Date()) + "*** Delivered event, code = " + event.getEventCode() + ", msg = " + event.getEventMessage());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            this.postEventProcess(event);
        }
    }

    private boolean shouldDeliver(EventListener listener, Event event) {
        boolean canDeliver = true;
        if (listener == null || this.isClosed) {
            canDeliver = false;
        } else if (event instanceof ConnectionClosedEvent && this.closedEventdelivered) {
            canDeliver = false;
        }
        return canDeliver;
    }

    private void postEventProcess(Event event) {
        if (event instanceof ConnectionReconnectedEvent) {
            this.connection.setReconnecting(false);
            this.closedEventdelivered = false;
            this.startConnection();
        } else if (event instanceof ConnectionClosedEvent) {
            this.closedEventdelivered = true;
        }
    }

    private void startConnection() {
        block3: {
            try {
                if (!this.connection.getIsStopped()) {
                    this.connection.getProtocolHandler().start();
                }
            }
            catch (Exception e) {
                if (!this.debug) break block3;
                e.printStackTrace(Debug.getPrintStream());
            }
        }
    }

    public void triggerConnectionClosedEvent(String evCode, JMSException jmse) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        Object evMessage = ClientResources.getResources().getKString(evCode, this.connection.getLastContactedBrokerAddress());
        if (evCode.equals("E207")) {
            evMessage = (String)evMessage + ", imqPingAckTimeout: " + this.connection.getPingAckTimeout();
        }
        ConnectionClosedEvent event = new ConnectionClosedEvent(this.connection, evCode, (String)evMessage, jmse);
        this.onEvent(event);
    }

    public void triggerConnectionClosingEvent(String evCode, long timePeriod) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String millisecs = String.valueOf(timePeriod);
        String secs = String.valueOf(timePeriod / 1000L);
        Object[] params = new Object[]{secs, millisecs, this.connection.getLastContactedBrokerAddress()};
        String evMessage = ClientResources.getResources().getKString(evCode, params);
        ConnectionClosingEvent event = new ConnectionClosingEvent(this.connection, evCode, evMessage, timePeriod);
        this.onEvent(event);
    }

    public void triggerConnectionReconnectFailedEvent(JMSException jmse, String brokerAddr) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String evCode = "E401";
        String evMessage = ClientResources.getResources().getKString(evCode, brokerAddr);
        ConnectionReconnectFailedEvent event = new ConnectionReconnectFailedEvent(this.connection, evCode, evMessage, jmse);
        this.onEvent(event);
    }

    public void triggerConnectionReconnectedEvent() {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String brokerAddr = this.connection.getBrokerAddress();
        String evCode = "E301";
        String evMessage = ClientResources.getResources().getKString(evCode, brokerAddr);
        ConnectionReconnectedEvent event = new ConnectionReconnectedEvent(this.connection, evCode, evMessage);
        this.onEvent(event);
    }

    public void triggerConnectionExitEvent(JMSException jmse, ExceptionListener listener) {
        try {
            if (this.connection.getEventListener() == null) {
                return;
            }
            this.exlistener = listener;
            ConnectionExitEvent event = new ConnectionExitEvent(this.connection, "E500", jmse.getMessage(), jmse);
            this.onEvent(event);
        }
        catch (Exception ex) {
            ex.printStackTrace(Debug.getPrintStream());
        }
    }

    public void triggerConnectionAddressListChangedEvent(String addrList) {
        if (this.connection.getEventListener() == null) {
            return;
        }
        String evCode = "E600";
        String evMessage = ClientResources.getResources().getKString(evCode, addrList);
        BrokerAddressListChangedEvent event = new BrokerAddressListChangedEvent(this.connection, evCode, evMessage, addrList);
        this.onEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerConsumerEvent(int infoType, String destName, int destType) {
        String evCode = null;
        switch (infoType) {
            case 0: {
                evCode = "E701";
                break;
            }
            case 1: {
                evCode = "E700";
                break;
            }
            default: {
                Debug.println("Received unknown consumer event: " + infoType + " on destination " + destName);
                return;
            }
        }
        String evMessage = ClientResources.getResources().getKString(evCode, (DestType.isQueue((int)destType) ? DestType.toString((int)1) : DestType.toString((int)2)) + ":" + destName);
        HashMap<Destination, EventListener> hashMap = this.consumerEventListeners;
        synchronized (hashMap) {
            Iterator<Destination> itr = this.consumerEventListeners.keySet().iterator();
            Destination d = null;
            while (itr.hasNext()) {
                d = itr.next();
                if (!d.getName().equals(destName) || d.isQueue() != DestType.isQueue((int)destType) || d.isTemporary() != DestType.isTemporary((int)destType)) continue;
                this.onEvent(new ConsumerEvent(d, this.connection, evCode, evMessage));
                return;
            }
        }
        Debug.println("Listener not found for consumer INFO: " + evMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendConsumerInfoRequests(ProtocolHandler ph) throws JMSException {
        HashMap<Destination, EventListener> hashMap = this.consumerEventListeners;
        synchronized (hashMap) {
            Iterator<Destination> itr = this.consumerEventListeners.keySet().iterator();
            Destination d = null;
            while (itr.hasNext()) {
                d = itr.next();
                ph.requestConsumerInfo(d, false);
            }
        }
    }
}

