/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.impl;

import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.transport.Acceptor;
import com.sun.corba.ee.spi.transport.ORBSocketFactory;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.security.integration.AppClientSSL;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.IIOPSSLUtil;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.internal.api.Globals;
import org.glassfish.orb.admin.config.IiopListener;
import org.glassfish.orb.admin.config.IiopService;
import org.glassfish.security.common.CipherInfo;

public class IIOPSSLSocketFactory
implements ORBSocketFactory {
    private static final Logger LOG = LogDomains.getLogger(IIOPSSLSocketFactory.class, (String)"jakarta.enterprise.resource.corba", (boolean)false);
    private static final String TLS = "TLS";
    private static final String SSL3 = "SSLv3";
    private static final String SSL2 = "SSLv2";
    private static final String SSL = "SSL";
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String PERSISTENT_SSL = "PERSISTENT_SSL";
    private static final int BACKLOG = 50;
    private final Map<Integer, SSLInfo> portToSSLInfo = new Hashtable<Integer, SSLInfo>();
    private SSLInfo clientSslInfo = null;
    private ORB orb;

    public IIOPSSLSocketFactory() {
        try {
            boolean notServerOrACC;
            ProcessEnvironment penv = null;
            ProcessEnvironment.ProcessType processType = null;
            boolean bl = notServerOrACC = Globals.getDefaultHabitat() == null;
            if (!notServerOrACC) {
                penv = (ProcessEnvironment)Globals.get(ProcessEnvironment.class);
                processType = penv.getProcessType();
            }
            if (processType != null && processType.isServer()) {
                Ssl outboundSsl;
                Config conf = (Config)Globals.getDefaultHabitat().getService(Config.class, "default-instance-name", new Annotation[0]);
                IiopService iiopBean = (IiopService)conf.getExtensionByType(IiopService.class);
                List iiopListeners = iiopBean.getIiopListener();
                for (IiopListener listener : iiopListeners) {
                    Ssl ssl = listener.getSsl();
                    SSLInfo sslInfo = null;
                    boolean securityEnabled = Boolean.valueOf(listener.getSecurityEnabled());
                    if (!securityEnabled) continue;
                    if (ssl != null) {
                        boolean ssl2Enabled = Boolean.valueOf(ssl.getSsl2Enabled());
                        boolean tlsEnabled = Boolean.valueOf(ssl.getTlsEnabled());
                        boolean ssl3Enabled = Boolean.valueOf(ssl.getSsl3Enabled());
                        sslInfo = this.init(ssl.getCertNickname(), ssl2Enabled, ssl.getSsl2Ciphers(), ssl3Enabled, ssl.getSsl3TlsCiphers(), tlsEnabled);
                    } else {
                        sslInfo = this.getDefaultSslInfo();
                    }
                    this.portToSSLInfo.put(Integer.parseInt(listener.getPort()), sslInfo);
                }
                if (iiopBean.getSslClientConfig() != null && iiopBean.getSslClientConfig().getSsl() != null && (outboundSsl = iiopBean.getSslClientConfig().getSsl()) != null) {
                    boolean ssl2Enabled = Boolean.valueOf(outboundSsl.getSsl2Enabled());
                    boolean ssl3Enabled = Boolean.valueOf(outboundSsl.getSsl3Enabled());
                    boolean tlsEnabled = Boolean.valueOf(outboundSsl.getTlsEnabled());
                    this.clientSslInfo = this.init(outboundSsl.getCertNickname(), ssl2Enabled, outboundSsl.getSsl2Ciphers(), ssl3Enabled, outboundSsl.getSsl3TlsCiphers(), tlsEnabled);
                }
                if (this.clientSslInfo == null) {
                    this.clientSslInfo = this.getDefaultSslInfo();
                }
            } else {
                IIOPSSLUtil sslUtil;
                AppClientSSL clientSsl;
                this.clientSslInfo = processType != null && processType == ProcessEnvironment.ProcessType.ACC ? ((clientSsl = (AppClientSSL)(sslUtil = (IIOPSSLUtil)Globals.getDefaultHabitat().getService(IIOPSSLUtil.class, new Annotation[0])).getAppClientSSL()) != null ? this.init(clientSsl.getCertNickname(), clientSsl.getSsl2Enabled(), clientSsl.getSsl2Ciphers(), clientSsl.getSsl3Enabled(), clientSsl.getSsl3TlsCiphers(), clientSsl.getTlsEnabled()) : this.getDefaultSslInfo()) : this.getDefaultSslInfo();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("IIOPSSLSocketFactory initialization failed.", e);
        }
    }

    private SSLInfo getDefaultSslInfo() throws Exception {
        return this.init(null, false, null, true, null, true);
    }

    private SSLInfo init(String alias, boolean ssl2Enabled, String ssl2Ciphers, boolean ssl3Enabled, String ssl3TlsCiphers, boolean tlsEnabled) throws Exception {
        String protocol = tlsEnabled ? TLS : (ssl3Enabled ? SSL3 : (ssl2Enabled ? SSL2 : SSL));
        String[] ssl3TlsCipherArr = tlsEnabled || ssl3Enabled ? this.getEnabledCipherSuites(ssl3TlsCiphers, false, ssl3Enabled, tlsEnabled) : null;
        String[] ssl2CipherArr = ssl2Enabled ? this.getEnabledCipherSuites(ssl2Ciphers, true, false, false) : null;
        SSLContext ctx = SSLContext.getInstance(protocol);
        if (Globals.getDefaultHabitat() != null) {
            IIOPSSLUtil sslUtil = (IIOPSSLUtil)Globals.getDefaultHabitat().getService(IIOPSSLUtil.class, new Annotation[0]);
            KeyManager[] mgrs = sslUtil.getKeyManagers(alias);
            ctx.init(mgrs, sslUtil.getTrustManagers(), sslUtil.getInitializedSecureRandom());
        }
        return new SSLInfo(this, ctx, ssl3TlsCipherArr, ssl2CipherArr);
    }

    public void setORB(ORB orb) {
        this.orb = orb;
    }

    public ServerSocket createServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        ServerSocket serverSocket;
        LOG.log(Level.INFO, "Creating server socket for type =" + type + " inetSocketAddress =" + String.valueOf(inetSocketAddress));
        if (type.equals(SSL_MUTUALAUTH) || type.equals(SSL) || type.equals(PERSISTENT_SSL)) {
            return this.createSSLServerSocket(type, inetSocketAddress);
        }
        if (this.orb.getORBData().acceptorSocketType().equals("SocketChannel")) {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocket = serverSocketChannel.socket();
        } else {
            serverSocket = new ServerSocket();
        }
        Action<ServerSocket> action = () -> {
            serverSocket.bind(inetSocketAddress);
            return serverSocket;
        };
        return IIOPSSLSocketFactory.repeat(action, Duration.ofSeconds(10L));
    }

    public Socket createSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "createSocket(" + type + ", " + String.valueOf(inetSocketAddress) + ")");
        }
        try {
            Socket socket;
            int port = inetSocketAddress.getPort();
            if (type.equals(SSL) || type.equals(SSL_MUTUALAUTH)) {
                String host = inetSocketAddress.getHostName();
                return this.createSSLSocket(host, port);
            }
            LOG.log(Level.FINE, "Creating CLEAR_TEXT socket for: {0}", port);
            if ("SocketChannel".equals(this.orb.getORBData().connectionSocketType())) {
                SocketChannel socketChannel = ORBUtility.openSocketChannel((SocketAddress)inetSocketAddress);
                socket = socketChannel.socket();
            } else {
                String host = inetSocketAddress.getHostName();
                socket = new Socket(host, port);
            }
            socket.setTcpNoDelay(true);
            return socket;
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Exception creating socket", ex);
            throw new RuntimeException(ex);
        }
    }

    public void setAcceptedSocketOptions(Acceptor acceptor, ServerSocket serverSocket, Socket socket) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "setAcceptedSocketOptions: " + String.valueOf(acceptor) + " " + String.valueOf(serverSocket) + " " + String.valueOf(socket));
        }
        try {
            socket.setTcpNoDelay(true);
        }
        catch (SocketException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ServerSocket createSSLServerSocket(String type, InetSocketAddress inetSocketAddress) throws IOException {
        if (inetSocketAddress == null) {
            throw new IOException("Socket address must not be null.");
        }
        int port = inetSocketAddress.getPort();
        Integer iport = port;
        SSLInfo sslInfo = this.portToSSLInfo.get(iport);
        if (sslInfo == null) {
            throw new IOException("No SSL info found for port " + iport);
        }
        SSLServerSocketFactory ssf = sslInfo.getContext().getServerSocketFactory();
        String[] ssl3TlsCiphers = sslInfo.getSsl3TlsCiphers();
        String[] ssl2Ciphers = sslInfo.getSsl2Ciphers();
        String[] ciphers = null;
        if (ssl3TlsCiphers != null || ssl2Ciphers != null) {
            String[] socketCiphers = ssf.getDefaultCipherSuites();
            ciphers = this.mergeCiphers(socketCiphers, ssl3TlsCiphers, ssl2Ciphers);
        }
        LOG.log(Level.FINE, () -> "Supported cipher Suites: " + Arrays.toString(ssf.getSupportedCipherSuites()));
        Action<ServerSocket> action = () -> ssf.createServerSocket(port, 50, inetSocketAddress.getAddress());
        ServerSocket ss = IIOPSSLSocketFactory.repeat(action, Duration.ofSeconds(10L));
        if (ciphers != null) {
            ((SSLServerSocket)ss).setEnabledCipherSuites(ciphers);
        }
        try {
            if (type.equals(SSL_MUTUALAUTH)) {
                LOG.log(Level.FINE, "Setting Mutual auth");
                ((SSLServerSocket)ss).setNeedClientAuth(true);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        LOG.log(Level.FINE, () -> "Created server socket: " + String.valueOf(ss));
        return ss;
    }

    private Socket createSSLSocket(String host, int port) throws IOException {
        SSLSocket socket = null;
        SSLSocketFactory factory = null;
        try {
            factory = this.clientSslInfo.getContext().getSocketFactory();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Creating SSL Socket for host:" + host + " port:" + port);
            }
            String[] ssl3TlsCiphers = this.clientSslInfo.getSsl3TlsCiphers();
            String[] ssl2Ciphers = this.clientSslInfo.getSsl2Ciphers();
            String[] clientCiphers = null;
            if (ssl3TlsCiphers != null || ssl2Ciphers != null) {
                String[] socketCiphers = factory.getDefaultCipherSuites();
                clientCiphers = this.mergeCiphers(socketCiphers, ssl3TlsCiphers, ssl2Ciphers);
            }
            socket = (SSLSocket)factory.createSocket(host, port);
            if (clientCiphers != null) {
                socket.setEnabledCipherSuites(clientCiphers);
            }
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "createSSLSocket failed.", new Object[]{host, port});
                LOG.log(Level.FINE, "", e);
            }
            throw new IOException("Error opening SSL socket to host=" + host + " port=" + port, e);
        }
        return socket;
    }

    private String[] getEnabledCipherSuites(String cipherSuiteStr, boolean ssl2Enabled, boolean ssl3Enabled, boolean tlsEnabled) {
        String[] cipherArr = null;
        if (cipherSuiteStr != null && cipherSuiteStr.length() > 0) {
            ArrayList<String> cipherList = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(cipherSuiteStr, ",");
            while (tokens.hasMoreTokens()) {
                CipherInfo cipherInfo;
                String cipher;
                String cipherAction = tokens.nextToken();
                if (cipherAction.startsWith("+")) {
                    cipher = cipherAction.substring(1);
                    cipherInfo = CipherInfo.getCipherInfo((String)cipher);
                    if (cipherInfo != null && this.isValidProtocolCipher(cipherInfo, ssl2Enabled, ssl3Enabled, tlsEnabled)) {
                        cipherList.add(cipherInfo.getCipherName());
                        continue;
                    }
                    throw new IllegalStateException("Unrecognized cipher [" + cipher + "]");
                }
                if (cipherAction.startsWith("-")) {
                    cipher = cipherAction.substring(1);
                    cipherInfo = CipherInfo.getCipherInfo((String)cipher);
                    if (cipherInfo != null && this.isValidProtocolCipher(cipherInfo, ssl2Enabled, ssl3Enabled, tlsEnabled)) continue;
                    throw new IllegalStateException("Unrecognized cipher [" + cipher + "]");
                }
                if (cipherAction.trim().length() <= 0) continue;
                throw new IllegalStateException("Unrecognized cipher action [" + cipherAction + "]");
            }
            cipherArr = cipherList.toArray(new String[cipherList.size()]);
        }
        return cipherArr;
    }

    private String[] mergeCiphers(String[] enableCiphers, String[] ssl3TlsCiphers, String[] ssl2Ciphers) {
        int i;
        int eSize;
        if (ssl3TlsCiphers == null && ssl2Ciphers == null) {
            return null;
        }
        int n = eSize = enableCiphers != null ? enableCiphers.length : 0;
        if (LOG.isLoggable(Level.FINE)) {
            StringBuilder buf = new StringBuilder("Default socket ciphers: ");
            for (i = 0; i < eSize; ++i) {
                buf.append(enableCiphers[i] + ", ");
            }
            LOG.log(Level.FINE, buf.toString());
        }
        ArrayList<String> cList = new ArrayList<String>();
        if (ssl3TlsCiphers != null) {
            for (String ssl3TlsCipher : ssl3TlsCiphers) {
                cList.add(ssl3TlsCipher);
            }
        } else {
            for (i = 0; i < eSize; ++i) {
                String cipher = enableCiphers[i];
                CipherInfo cInfo = CipherInfo.getCipherInfo((String)cipher);
                if (cInfo == null || !cInfo.isTLS() && !cInfo.isSSL3()) continue;
                cList.add(cipher);
            }
        }
        if (ssl2Ciphers != null) {
            for (String ssl2Cipher : ssl2Ciphers) {
                cList.add(ssl2Cipher);
            }
        } else {
            for (int i2 = 0; i2 < eSize; ++i2) {
                String cipher = enableCiphers[i2];
                CipherInfo cInfo = CipherInfo.getCipherInfo((String)cipher);
                if (cInfo == null || !cInfo.isSSL2()) continue;
                cList.add(cipher);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Merged socket ciphers: " + String.valueOf(cList));
        }
        return cList.toArray(new String[cList.size()]);
    }

    private boolean isValidProtocolCipher(CipherInfo cipherInfo, boolean ssl2Enabled, boolean ssl3Enabled, boolean tlsEnabled) {
        return tlsEnabled && cipherInfo.isTLS() || ssl3Enabled && cipherInfo.isSSL3() || ssl2Enabled && cipherInfo.isSSL2();
    }

    private static <T> T repeat(Action<T> action, Duration timeout) throws IOException {
        Instant deadline = Instant.now().plus(timeout);
        while (true) {
            try {
                return action.get();
            }
            catch (Exception e) {
                if (!Instant.now().isAfter(deadline)) continue;
                throw e;
            }
            break;
        }
    }

    class SSLInfo {
        private final SSLContext ctx;
        private String[] ssl3TlsCiphers = null;
        private String[] ssl2Ciphers = null;

        SSLInfo(IIOPSSLSocketFactory this$0, SSLContext ctx, String[] ssl3TlsCiphers, String[] ssl2Ciphers) {
            this.ctx = ctx;
            this.ssl3TlsCiphers = ssl3TlsCiphers;
            this.ssl2Ciphers = ssl2Ciphers;
        }

        SSLContext getContext() {
            return this.ctx;
        }

        String[] getSsl3TlsCiphers() {
            return this.ssl3TlsCiphers;
        }

        String[] getSsl2Ciphers() {
            return this.ssl2Ciphers;
        }
    }

    @FunctionalInterface
    private static interface Action<T> {
        public T get() throws IOException;
    }
}

