/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.api.impl;

import com.ibm.jbatch.container.jobinstance.JobInstanceImpl;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IJobExecution;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.JobStatus;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.jbatch.spi.services.IJobXMLLoaderService;
import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionIsRunningException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobOperator;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobSecurityException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.operations.NoSuchJobInstanceException;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.JobExecution;
import jakarta.batch.runtime.JobInstance;
import jakarta.batch.runtime.StepExecution;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JobOperatorImplDelegate
implements JobOperator {
    private static final String sourceClass = JobOperatorImplDelegate.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private ServicesManager servicesManager = ServicesManagerImpl.getInstance();
    private IBatchKernelService batchKernel = this.servicesManager.getBatchKernelService();
    private IPersistenceManagerService persistenceService = this.servicesManager.getPersistenceManagerService();
    private IJobXMLLoaderService jobXMLLoaderService = this.servicesManager.getDelegatingJobXMLLoaderService();
    private IJobStatusManagerService _jobStatusManagerService = this.servicesManager.getJobStatusManagerService();

    public long start(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        long retVal = 0L;
        try {
            retVal = this.startInternal(jobXMLName, jobParameters);
        }
        catch (JobSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobStartException((Throwable)e);
        }
        return retVal;
    }

    private long startInternal(String jobXMLName, Properties jobParameters) throws JobStartException, JobSecurityException {
        StringWriter jobParameterWriter = new StringWriter();
        if (jobParameters != null) {
            try {
                jobParameters.store(jobParameterWriter, "Job parameters on start: ");
            }
            catch (IOException e) {
                jobParameterWriter.write("Job parameters on start: not printable");
            }
        } else {
            jobParameterWriter.write("Job parameters on start = null");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobOperator start, with jobXMLName = " + jobXMLName + "\n" + jobParameterWriter.toString());
        }
        String jobXML = this.jobXMLLoaderService.loadJSL(jobXMLName);
        long executionId = 0L;
        if (logger.isLoggable(Level.FINE)) {
            int concatLen = jobXML.length() > 200 ? 200 : jobXML.length();
            logger.fine("Starting job: " + jobXML.substring(0, concatLen) + "... truncated ...");
        }
        IJobExecution execution = this.batchKernel.startJob(jobXML, jobParameters);
        executionId = execution.getExecutionId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Started job with instanceId: " + execution.getInstanceId() + ", executionId: " + executionId);
        }
        return executionId;
    }

    public void abandon(long executionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        IJobExecution jobEx;
        if (this.isAuthorized(this.persistenceService.getJobInstanceIdByExecutionId(executionId))) {
            jobEx = this.persistenceService.jobOperatorGetJobExecution(executionId);
            List<BatchStatus> runningStatusesList = Arrays.asList(BatchStatus.STARTED, BatchStatus.STARTING);
            Set<BatchStatus> runningStatusesSet = Collections.unmodifiableSet(new HashSet<BatchStatus>(runningStatusesList));
            if (runningStatusesSet.contains(jobEx.getBatchStatus())) {
                logger.warning("Job Execution: " + executionId + " is still running");
                throw new JobExecutionIsRunningException("Job Execution: " + executionId + " is still running");
            }
        } else {
            throw new JobSecurityException("The current user is not authorized to perform this operation");
        }
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.persistenceService.updateBatchStatusOnly(jobEx.getExecutionId(), BatchStatus.ABANDONED, timestamp);
        logger.fine("Job Execution: " + executionId + " was abandoned");
        this._jobStatusManagerService.updateJobBatchStatus(jobEx.getInstanceId(), BatchStatus.ABANDONED);
    }

    public IJobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (this.isAuthorized(this.persistenceService.getJobInstanceIdByExecutionId(executionId))) {
            return this.batchKernel.getJobExecution(executionId);
        }
        throw new JobSecurityException("The current user is not authorized to perform this operation");
    }

    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        if (this.isAuthorized(instance.getInstanceId())) {
            List<IJobExecution> executionImpls = this.persistenceService.jobOperatorGetJobExecutions(instance.getInstanceId());
            if (executionImpls.size() == 0) {
                logger.warning("The current user is not authorized to perform this operation");
                throw new NoSuchJobInstanceException("Job: " + instance.getJobName() + " does not exist");
            }
            for (IJobExecution e : executionImpls) {
                executions.add(e);
            }
        } else {
            logger.warning("The current user is not authorized to perform this operation");
            throw new JobSecurityException("The current user is not authorized to perform this operation");
        }
        return executions;
    }

    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (this.isAuthorized(this.persistenceService.getJobInstanceIdByExecutionId(executionId))) {
            return this.batchKernel.getJobInstance(executionId);
        }
        throw new JobSecurityException("The current user is not authorized to perform this operation");
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        int jobInstanceCount = 0;
        BatchSecurityHelper helper = this.getBatchSecurityHelper();
        jobInstanceCount = this.isCurrentTagAdmin(helper) ? this.persistenceService.jobOperatorGetJobInstanceCount(jobName) : this.persistenceService.jobOperatorGetJobInstanceCount(jobName, helper.getCurrentTag());
        if (jobInstanceCount > 0) {
            return jobInstanceCount;
        }
        logger.fine("getJobInstanceCount: Job Name " + jobName + " not found");
        throw new NoSuchJobException("Job " + jobName + " not found");
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        logger.entering(sourceClass, "getJobInstances", new Object[]{jobName, start, count});
        ArrayList<JobInstance> jobInstances = new ArrayList<JobInstance>();
        if (count == 0) {
            return new ArrayList<JobInstance>();
        }
        if (count < 0) {
            throw new IllegalArgumentException("Count should be a positive integer (or 0, which will return an empty list)");
        }
        BatchSecurityHelper helper = this.getBatchSecurityHelper();
        List<Long> instanceIds = this.isCurrentTagAdmin(helper) ? this.persistenceService.jobOperatorGetJobInstanceIds(jobName, start, count) : this.persistenceService.jobOperatorGetJobInstanceIds(jobName, helper.getCurrentTag(), start, count);
        if (instanceIds.size() > 0) {
            for (long id : instanceIds) {
                JobStatus jobStatus = this._jobStatusManagerService.getJobStatus(id);
                JobInstanceImpl jobInstance = jobStatus.getJobInstance();
                logger.finest("Matched jobInstance = " + jobInstance.getInstanceId());
                if (!this.isAuthorized(jobInstance.getInstanceId())) continue;
                logger.finest("Authorized so adding to list jobInstance =  " + jobInstance.getInstanceId());
                jobInstances.add(jobInstance);
            }
            logger.exiting(sourceClass, "getJobInstances", jobInstances);
            return jobInstances;
        }
        logger.fine("getJobInstances: Job Name " + jobName + " not found");
        throw new NoSuchJobException("Job Name " + jobName + " not found");
    }

    public Set<String> getJobNames() throws JobSecurityException {
        HashSet<String> jobNames = new HashSet<String>();
        Map<Long, String> data = this.persistenceService.jobOperatorGetExternalJobInstanceData();
        for (Map.Entry<Long, String> entry : data.entrySet()) {
            long instanceId = entry.getKey();
            if (!this.isAuthorized(instanceId)) continue;
            String name = entry.getValue();
            jobNames.add(name);
        }
        return jobNames;
    }

    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        Properties props = null;
        JobInstance requestedJobInstance = this.batchKernel.getJobInstance(executionId);
        if (!this.isAuthorized(requestedJobInstance.getInstanceId())) {
            logger.warning("getParameters: The current user is not authorized to perform this operation");
            throw new JobSecurityException("The current user is not authorized to perform this operation");
        }
        props = this.persistenceService.getParameters(executionId);
        return props;
    }

    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        logger.entering(sourceClass, "getRunningExecutions", jobName);
        ArrayList<Long> jobExecutions = new ArrayList<Long>();
        Set<Long> executionIds = this.persistenceService.jobOperatorGetRunningExecutions(jobName);
        if (executionIds.size() > 0) {
            for (long id : executionIds) {
                try {
                    logger.finer("Examining executionId: " + id);
                    if (this.isAuthorized(this.persistenceService.getJobInstanceIdByExecutionId(id))) {
                        if (this.batchKernel.isExecutionRunning(id)) {
                            IJobExecution jobEx = this.batchKernel.getJobExecution(id);
                            jobExecutions.add(jobEx.getExecutionId());
                            continue;
                        }
                        logger.finer("Found executionId: " + id + " with a BatchStatus indicating running, but kernel doesn't currently have an entry for this execution in the kernel's in-memory map.");
                        continue;
                    }
                    logger.finer("Don't have authorization for executionId: " + id);
                }
                catch (NoSuchJobExecutionException e) {
                    String errorMsg = "Just found execution with id = " + id + " in table, but now seeing it as gone";
                    logger.severe(errorMsg);
                    throw new IllegalStateException(errorMsg, e);
                }
            }
            logger.exiting(sourceClass, "getRunningExecutions", jobExecutions);
            return jobExecutions;
        }
        logger.fine("getRunningExecutions: Job Name " + jobName + " not found");
        throw new NoSuchJobException("Job Name " + jobName + " not found");
    }

    public List<StepExecution> getStepExecutions(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        logger.entering(sourceClass, "getStepExecutions", executionId);
        ArrayList<StepExecution> stepExecutions = new ArrayList();
        IJobExecution jobEx = this.batchKernel.getJobExecution(executionId);
        if (jobEx == null) {
            logger.fine("Job Execution: " + executionId + " not found");
            throw new NoSuchJobExecutionException("Job Execution: " + executionId + " not found");
        }
        if (!this.isAuthorized(this.persistenceService.getJobInstanceIdByExecutionId(executionId))) {
            logger.warning("getStepExecutions: The current user is not authorized to perform this operation");
            throw new JobSecurityException("The current user is not authorized to perform this operation");
        }
        stepExecutions = this.persistenceService.getStepExecutionsForJobExecution(executionId);
        logger.exiting(sourceClass, "getStepExecutions", stepExecutions);
        return stepExecutions;
    }

    public long restart(long oldExecutionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        long retVal = 0L;
        try {
            retVal = this.restartInternal(oldExecutionId, restartParameters);
        }
        catch (JobExecutionAlreadyCompleteException e) {
            throw e;
        }
        catch (NoSuchJobExecutionException e) {
            throw e;
        }
        catch (JobExecutionNotMostRecentException e) {
            throw e;
        }
        catch (JobSecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JobRestartException((Throwable)e);
        }
        return retVal;
    }

    private long restartInternal(long oldExecutionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        long newExecutionId = -1L;
        if (this.isAuthorized(this.persistenceService.getJobInstanceIdByExecutionId(oldExecutionId))) {
            StringWriter jobParameterWriter = new StringWriter();
            if (restartParameters != null) {
                try {
                    restartParameters.store(jobParameterWriter, "Job parameters on restart: ");
                }
                catch (IOException e) {
                    jobParameterWriter.write("Job parameters on restart: not printable");
                }
            } else {
                jobParameterWriter.write("Job parameters on restart = null");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JobOperator restart, with old executionId = " + oldExecutionId + "\n" + jobParameterWriter.toString());
            }
            IJobExecution execution = this.batchKernel.restartJob(oldExecutionId, restartParameters);
            newExecutionId = execution.getExecutionId();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Restarted job with instanceID: " + execution.getInstanceId() + ", new executionId: " + newExecutionId + ", and old executionID: " + oldExecutionId);
            }
        } else {
            throw new JobSecurityException("The current user is not authorized to perform this operation");
        }
        return newExecutionId;
    }

    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        logger.entering(sourceClass, "stop", executionId);
        if (!this.isAuthorized(this.persistenceService.getJobInstanceIdByExecutionId(executionId))) {
            throw new JobSecurityException("The current user is not authorized to perform this operation");
        }
        this.batchKernel.stopJob(executionId);
        logger.exiting(sourceClass, "stop");
    }

    public void purge(String apptag) {
        BatchSecurityHelper bsh = this.getBatchSecurityHelper();
        if (this.isCurrentTagAdmin(bsh)) {
            logger.finer("Current tag is admin, so authorized to purge.");
            this.persistenceService.purge(apptag);
        } else if (bsh.getCurrentTag().equals(apptag)) {
            logger.finer("Current tag is the tag of record so authorized to purge.");
            this.persistenceService.purge(apptag);
        } else {
            logger.finer("Current tag does not match the tag of record so will not purge.");
        }
    }

    private boolean isAuthorized(long instanceId) {
        logger.entering(sourceClass, "isAuthorized", instanceId);
        boolean retVal = false;
        String apptag = this.persistenceService.getJobCurrentTag(instanceId);
        BatchSecurityHelper bsh = this.getBatchSecurityHelper();
        if (this.isCurrentTagAdmin(bsh)) {
            logger.finer("Current tag is admin, so always authorized");
            retVal = true;
        } else if (bsh.getCurrentTag().equals(apptag)) {
            logger.finer("Current tag is the tag of record");
            retVal = true;
        } else {
            logger.finer("Current tag does not match the tag of record");
            retVal = false;
        }
        logger.exiting(sourceClass, "isAuthorized", retVal);
        return retVal;
    }

    private boolean isCurrentTagAdmin(BatchSecurityHelper helper) {
        return helper.isAdmin(helper.getCurrentTag());
    }

    private BatchSecurityHelper getBatchSecurityHelper() {
        BatchSecurityHelper bsh = this.batchKernel.getBatchSecurityHelper();
        if (bsh == null) {
            throw new IllegalStateException("Expect to have a security helper, at least the NoOp security helper.");
        }
        return bsh;
    }
}

