/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.tlsutil;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.net.tls.DefaultTrustManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.tlsutil.SSLPropertyMap;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class KeystoreUtil
implements SSLPropertyMap {
    public static final String KEYSTORE_DIR_PROP = "imq.keystore.file.dirpath";
    public static final String KEYSTORE_FILE_PROP = "imq.keystore.file.name";
    public static final String KEYSTORE_PASSWORD_PROP = "imq.keystore.password";
    private static String keystore_location = null;
    private static String pass_phrase = null;
    protected static final BrokerResources br = Globals.getBrokerResources();
    public static final String KEYSTORE_FILE = "javax.net.ssl.keyStore";
    public static final String KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String TRUSTSTORE_FILE = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String TRUSTSTORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String KEYSTORE_ALGORITHM = "ssl.KeyManagerFactory.algorithm";
    public static final String TRUSTSTORE_ALGORITHM = "ssl.TrustManagerFactory.algorithm";
    public static final String SECURESOCKET_PROTOCOL = "securesocket.protocol";

    public static void clear() {
        keystore_location = null;
        pass_phrase = null;
    }

    public static String getKeystoreLocation() throws IOException {
        if (keystore_location == null) {
            Object dir;
            BrokerConfig bcfg = Globals.getConfig();
            String file_sep = System.getProperty("file.separator");
            String value = bcfg.getProperty(KEYSTORE_DIR_PROP);
            if (value != null) {
                value = StringUtil.expandVariables((String)value, (Properties)bcfg);
                dir = value;
            } else {
                dir = bcfg.getProperty("imq.varhome") + file_sep + "security";
            }
            keystore_location = (String)dir + file_sep + bcfg.getProperty(KEYSTORE_FILE_PROP);
        }
        return keystore_location;
    }

    public static String getKeystorePassword() throws IOException {
        if (pass_phrase == null) {
            Password pw = null;
            BrokerConfig bcfg = Globals.getConfig();
            pass_phrase = bcfg.getProperty(KEYSTORE_PASSWORD_PROP);
            int retry = 0;
            pw = new Password();
            if (pw.echoPassword()) {
                System.err.println(Globals.getBrokerResources().getString("B2242"));
            }
            while ((pass_phrase == null || pass_phrase.equals("")) && retry <= 5) {
                System.err.print(br.getString("B0004", KeystoreUtil.getKeystoreLocation()));
                System.err.flush();
                if (Broker.getBroker().background) {
                    System.err.print("\n");
                    break;
                }
                pass_phrase = pw.getPassword();
                ++retry;
            }
        }
        return pass_phrase;
    }

    @Override
    public String mapSSLProperty(String prop) {
        return prop;
    }

    public static Properties getDefaultSSLContextConfig(String caller, SSLPropertyMap pm) throws Exception {
        if (pm == null) {
            pm = new KeystoreUtil();
        }
        Properties props = new Properties();
        String keystoreloc = KeystoreUtil.getKeystoreLocation();
        File kf = new File(keystoreloc);
        if (!kf.exists()) {
            throw new IOException(Globals.getBrokerResources().getKString("B3019", keystoreloc));
        }
        props.setProperty(pm.mapSSLProperty(KEYSTORE_FILE), keystoreloc);
        props.setProperty(pm.mapSSLProperty(TRUSTSTORE_FILE), keystoreloc);
        String keystorepwd = KeystoreUtil.getKeystorePassword();
        if (keystorepwd == null) {
            throw new IOException(Globals.getBrokerResources().getKString("B3021"));
        }
        props.setProperty(pm.mapSSLProperty(KEYSTORE_PASSWORD), keystorepwd);
        props.setProperty(pm.mapSSLProperty(TRUSTSTORE_PASSWORD), keystorepwd);
        props.setProperty(pm.mapSSLProperty(KEYSTORE_TYPE), "JKS");
        props.setProperty(pm.mapSSLProperty(TRUSTSTORE_TYPE), "JKS");
        String alg = "SunX509";
        try {
            KeyManagerFactory.getInstance("SunX509");
        }
        catch (NoSuchAlgorithmException e) {
            alg = KeyManagerFactory.getDefaultAlgorithm();
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(8, caller + ":" + e.getMessage() + ", use default KeyManagerFactory algorithm " + alg);
        }
        props.setProperty(pm.mapSSLProperty(KEYSTORE_ALGORITHM), alg);
        alg = "SunX509";
        try {
            TrustManagerFactory.getInstance("SunX509");
        }
        catch (NoSuchAlgorithmException e) {
            alg = TrustManagerFactory.getDefaultAlgorithm();
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(8, caller + ":" + e.getMessage() + ", use default TrustManagerFactory algorithm " + alg);
        }
        props.setProperty(pm.mapSSLProperty(TRUSTSTORE_ALGORITHM), alg);
        props.setProperty(pm.mapSSLProperty(SECURESOCKET_PROTOCOL), "TLS");
        return props;
    }

    private static SSLContext getDefaultSSLContext(String caller, boolean trustAll) throws Exception {
        KeyStore ks = null;
        KeyManagerFactory kmf = null;
        if (!trustAll) {
            String keystorepwd = KeystoreUtil.getKeystorePassword();
            if (keystorepwd == null) {
                throw new IOException(Globals.getBrokerResources().getKString("B3021"));
            }
            char[] keystorepwdc = keystorepwd.toCharArray();
            ks = KeystoreUtil.getKeyStore(keystorepwdc);
            kmf = KeystoreUtil.getKeyManagerFactory(ks, keystorepwdc, caller);
        }
        TrustManager[] tm = null;
        if (!trustAll) {
            TrustManagerFactory tmf = null;
            try {
                tmf = TrustManagerFactory.getInstance("SunX509");
            }
            catch (NoSuchAlgorithmException e) {
                String alg = TrustManagerFactory.getDefaultAlgorithm();
                Logger logger = Globals.getLogger();
                Globals.getLogger();
                logger.log(8, caller + ":" + e.getMessage() + ", use default TrustManagerFactory algorithm " + alg);
                tmf = TrustManagerFactory.getInstance(alg);
            }
            tmf.init(ks);
            tm = tmf.getTrustManagers();
        } else {
            tm = new TrustManager[]{new DefaultTrustManager()};
        }
        SSLContext ctx = SSLContext.getInstance("TLS");
        SecureRandom random = null;
        if (!trustAll) {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        ctx.init(kmf == null ? null : kmf.getKeyManagers(), tm, random);
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(char[] keystorepwdc) throws Exception {
        String keystoreloc = KeystoreUtil.getKeystoreLocation();
        File kf = new File(keystoreloc);
        if (!kf.exists()) {
            throw new IOException(Globals.getBrokerResources().getKString("B3019", keystoreloc));
        }
        KeyStore ks = KeyStore.getInstance("JKS");
        FileInputStream is = new FileInputStream(keystoreloc);
        try {
            ks.load(is, keystorepwdc);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
        return ks;
    }

    private static KeyManagerFactory getKeyManagerFactory(KeyStore ks, char[] keystorepwdc, String caller) throws Exception {
        KeyManagerFactory kmf;
        try {
            kmf = KeyManagerFactory.getInstance("SunX509");
        }
        catch (NoSuchAlgorithmException e) {
            String alg = KeyManagerFactory.getDefaultAlgorithm();
            Logger logger = Globals.getLogger();
            Globals.getLogger();
            logger.log(8, caller + ":" + e.getMessage() + ", use default KeyManagerFactory algorithm " + alg);
            kmf = KeyManagerFactory.getInstance(alg);
        }
        kmf.init(ks, keystorepwdc);
        return kmf;
    }

    public static String[] getKnownSSLEnabledProtocols(String caller) {
        try {
            SSLContext sc = KeystoreUtil.getDefaultSSLContext(caller, true);
            SSLEngine se = sc.createSSLEngine();
            return se.getEnabledProtocols();
        }
        catch (Exception exception) {
            return new String[]{"TLSv1"};
        }
    }
}

