/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.gms.common;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.glassfish.shoal.gms.api.core.GMSMember;
import org.glassfish.shoal.gms.api.core.GroupManagementService;
import org.glassfish.shoal.gms.common.AliveAndReadyViewWindow;
import org.glassfish.shoal.gms.common.GMSContext;
import org.glassfish.shoal.gms.common.GMSMonitor;
import org.glassfish.shoal.gms.common.Router;
import org.glassfish.shoal.gms.common.ShutdownHelper;
import org.glassfish.shoal.gms.common.ViewWindow;
import org.glassfish.shoal.gms.logging.GMSLogDomain;

public abstract class GMSContextBase
implements GMSContext {
    protected String serverToken = null;
    protected String groupName = null;
    protected Router router;
    protected ViewWindow viewWindow;
    protected static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    protected String memberType;
    protected GMSMember gmsMember;
    protected final ArrayList<String> suspectList;
    protected final Long startTime;
    protected boolean shuttingDown = false;
    protected final ShutdownHelper shutdownHelper;
    protected final GroupManagementService.MemberType gmsMemberType;

    protected GMSContextBase(String serverToken, String groupName, GroupManagementService.MemberType memberType) {
        this.serverToken = serverToken;
        this.groupName = groupName;
        this.gmsMemberType = memberType;
        this.memberType = GMSContextBase.getMemberType(memberType);
        this.startTime = System.currentTimeMillis();
        this.gmsMember = new GMSMember(serverToken, this.memberType, groupName, this.startTime);
        this.suspectList = new ArrayList();
        this.shutdownHelper = new ShutdownHelper();
    }

    protected static String getMemberType(GroupManagementService.MemberType memberType) {
        if (memberType == null) {
            return GroupManagementService.MemberType.CORE.toString();
        }
        return memberType.toString();
    }

    @Override
    public GroupManagementService.MemberType getMemberType() {
        return this.gmsMemberType;
    }

    @Override
    public String getServerIdentityToken() {
        return this.serverToken;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public Router getRouter() {
        return this.router;
    }

    protected abstract void createDistributedStateCache();

    @Override
    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    @Override
    public abstract AliveAndReadyViewWindow getAliveAndReadyViewWindow();

    @Override
    public abstract GMSMonitor getGMSMonitor();
}

