/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupRunnable;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupService;
import com.sun.messaging.jmq.jmsserver.service.imq.group.SelectThread;
import com.sun.messaging.jmq.util.log.Logger;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

class MapEntry {
    Logger logger = Globals.getLogger();
    int min = 0;
    List l = null;
    Class selectClass = null;
    int mask = 0;
    int limit = 0;
    GroupService svc = null;

    MapEntry(GroupService svc, int min, int limit, Class selectClass, int mask) {
        this.svc = svc;
        this.min = min;
        this.limit = limit;
        this.selectClass = selectClass;
        this.mask = mask;
        this.l = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        try {
            ht.put("MapEntry", String.valueOf(this.hashCode()));
            ArrayList mylist = null;
            MapEntry mapEntry = this;
            synchronized (mapEntry) {
                if (this.l != null) {
                    mylist = new ArrayList(this.l);
                }
            }
            this.logger.log(8, "... ... ... Dumping MapEntry" + this.hashCode());
            Hashtable<String, Hashtable> thrInfo = new Hashtable<String, Hashtable>();
            for (int i = 0; mylist != null && i < mylist.size(); ++i) {
                SelectThread thr = (SelectThread)mylist.get(i);
                this.logger.log(8, "... ... ... ....  thread info " + thr.toString());
                thrInfo.put(String.valueOf(i), thr.getDebugState());
            }
            ht.put("SelectThreads", thrInfo);
            if (mylist != null) {
                ht.put("SelectThreadCnt", String.valueOf(mylist.size()));
            }
            if (this.svc != null) {
                ht.put("Service", this.svc.getName());
            }
            ht.put("min", String.valueOf(this.min));
            ht.put("limit", String.valueOf(this.limit));
            ht.put("mask", String.valueOf(this.mask));
        }
        catch (Exception ex) {
            ht.put("Exception ", ex.toString());
            this.logger.log(8, "Error dumping ", ex);
        }
        return ht;
    }

    public synchronized void destroy(String reason) {
        for (int i = 0; i < this.l.size(); ++i) {
            SelectThread thr = (SelectThread)this.l.get(i);
            thr.destroy(reason);
        }
        this.l.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRemoveThread(SelectThread thr, boolean force) {
        boolean free = false;
        MapEntry mapEntry = this;
        synchronized (mapEntry) {
            int indx = this.l.indexOf(thr);
            if (force || thr != null && !thr.isValid() || indx == -1 || indx > this.min) {
                this.l.remove(thr);
                free = true;
            }
        }
        if (free) {
            GroupRunnable grp = thr.getParent();
            if (grp != null) {
                grp.freeThread();
            } else if (thr.isValid()) {
                thr.destroy("Unused thread");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SelectThread findThread() {
        Iterator itr = this.l.iterator();
        SelectThread selthr = null;
        int size = 0;
        while (itr.hasNext()) {
            SelectThread thr = (SelectThread)itr.next();
            if (!thr.isValid()) {
                itr.remove();
                continue;
            }
            if (this.limit != -1 && thr.size() >= this.limit || selthr != null && thr.size() >= size) continue;
            selthr = thr;
            size = thr.totalSize();
            size = thr.size();
        }
        if (selthr != null && selthr.totalSize() > 0 && this.l.size() < this.min || selthr == null) {
            boolean finished = false;
            int attempt = 0;
            int max_attempt = 5;
            while (!finished && attempt < max_attempt) {
                try {
                    Class[] args = new Class[]{Service.class, MapEntry.class};
                    Object[] objs = new Object[]{this.svc, this};
                    GroupRunnable runner = null;
                    GroupService groupService = this.svc;
                    synchronized (groupService) {
                        runner = (GroupRunnable)this.svc.getPool().getAvailRunnable(false);
                        if (runner == null) {
                            finished = true;
                            throw new Exception("no threads available from pool " + this.l.size());
                        }
                        Constructor con = this.selectClass.getConstructor(args);
                        selthr = (SelectThread)con.newInstance(objs);
                        this.l.add(selthr);
                        runner.assignThread(selthr, this.mask);
                        finished = true;
                    }
                }
                catch (Exception ex) {
                    Globals.getLogger().logStack(32, "B3100", "error creating a selector.", (Throwable)ex);
                    ++attempt;
                }
            }
        }
        return selthr;
    }
}

