/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.css.swt.theme.ITheme;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.themes.CascadingColorRegistry;
import org.eclipse.ui.internal.themes.CascadingFontRegistry;
import org.eclipse.ui.internal.themes.CascadingTheme;
import org.eclipse.ui.internal.themes.ColorDefinition;
import org.eclipse.ui.internal.themes.FontDefinition;
import org.eclipse.ui.internal.themes.ICategorizedThemeElementDefinition;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeElementDefinition;
import org.eclipse.ui.internal.themes.IThemeRegistry;
import org.eclipse.ui.internal.themes.ThemeElementCategory;
import org.eclipse.ui.internal.themes.ThemeElementDefinition;
import org.eclipse.ui.internal.themes.ThemeElementHelper;
import org.eclipse.ui.internal.themes.ThemeRegistry;
import org.eclipse.ui.internal.themes.WorkbenchThemeManager;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipse.ui.themes.IThemePreview;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class ColorsAndFontsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String EMPTY = "";
    private static final String SPACE = " ";
    private static final String SELECTED_ELEMENT_PREF = "ColorsAndFontsPreferencePage.selectedElement";
    private static final String EXPANDED_ELEMENTS_PREF = "ColorsAndFontsPreferencePage.expandedCategories";
    private static final String EXPANDED_ELEMENTS_TOKEN = "\t";
    private static final char MARKER_CATEGORY = 'T';
    private static final char MARKER_COLOR = 'C';
    private static final char MARKER_FONT = 'F';
    private static final int DEFINITION_NOT_AVAIL_COLOR = 19;
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(ColorsAndFontsPreferencePage.class.getName());
    private Map<String, Object[]> categoryMap = new HashMap<String, Object[]>(7);
    private Font appliedDialogFont;
    private Map<ColorDefinition, RGB> colorPreferencesToSet = new HashMap<ColorDefinition, RGB>(7);
    private CascadingColorRegistry colorRegistry;
    private Map<String, RGB> colorValuesToSet = new HashMap<String, RGB>(7);
    private Composite defaultColorPreview;
    private Composite defaultFontPreview;
    private Composite defaultNoPreview;
    private Font currentFont;
    private Color currentColor;
    private Canvas colorSampler;
    private Canvas fontSampler;
    private String fontSampleText;
    private List<Control> dialogFontWidgets = new ArrayList<Control>();
    private Button fontChangeButton;
    private Button editDefaultButton;
    private Button goToDefaultButton;
    private Button expandAllButton;
    private Map<FontDefinition, FontData[]> fontPreferencesToSet = new HashMap<FontDefinition, FontData[]>(7);
    private CascadingFontRegistry fontRegistry;
    private Button fontResetButton;
    private Button fontSystemButton;
    @Deprecated
    private Map<String, FontData[]> fontValuesToSet = new HashMap<String, FontData[]>(7);
    private Composite previewComposite;
    private Map<ThemeElementCategory, Composite> previewMap = new HashMap<ThemeElementCategory, Composite>(7);
    private Set<IThemePreview> previewSet = new HashSet<IThemePreview>(7);
    private StackLayout stackLayout;
    private final IThemeRegistry themeRegistry;
    private org.eclipse.ui.themes.ITheme currentTheme;
    private PresentationLabelProvider labelProvider;
    private CascadingThemeExt cascadingTheme;
    private IPropertyChangeListener themeChangeListener;
    private Workbench workbench;
    private FilteredTree tree;
    private Text descriptionText;
    private IEventBroker eventBroker;
    private EventHandler themeRegistryRestyledHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (this.isAnyThemeChanged()) {
                ColorsAndFontsPreferencePage.this.updateThemeInfo(ColorsAndFontsPreferencePage.this.workbench.getThemeManager());
            }
            ColorsAndFontsPreferencePage.this.refreshCategory();
            ColorsAndFontsPreferencePage.this.refreshAllLabels();
            ColorsAndFontsPreferencePage.this.clearPreviews();
            ColorsAndFontsPreferencePage.this.previewMap.clear();
            ColorsAndFontsPreferencePage.this.restoreTreeSelection();
            ColorsAndFontsPreferencePage.this.updateControls();
        }

        private boolean isAnyThemeChanged() {
            return ColorsAndFontsPreferencePage.this.currentTheme != ColorsAndFontsPreferencePage.this.workbench.getThemeManager().getCurrentTheme() || ColorsAndFontsPreferencePage.this.currentCSSTheme != ColorsAndFontsPreferencePage.this.getActiveTheme();
        }
    };
    private ITheme currentCSSTheme;
    private IThemeEngine themeEngine;

    public ColorsAndFontsPreferencePage() {
        this.themeRegistry = WorkbenchPlugin.getDefault().getThemeRegistry();
    }

    public void applyData(Object data) {
        String id;
        ColorDefinition colorDef;
        if (this.tree == null || !(data instanceof String)) {
            return;
        }
        ThemeRegistry themeRegistry = (ThemeRegistry)this.tree.getViewer().getInput();
        String command = (String)data;
        if (command.startsWith("selectCategory:")) {
            String categoryId = command.substring(15);
            ThemeElementCategory category = themeRegistry.findCategory(categoryId);
            if (category != null) {
                this.selectAndReveal(category);
                this.tree.getViewer().expandToLevel((Object)category, 1);
            }
        } else if (command.startsWith("selectFont:")) {
            String id2 = command.substring(11);
            FontDefinition fontDef = themeRegistry.findFont(id2);
            if (fontDef != null) {
                this.selectAndReveal(fontDef);
            }
        } else if (command.startsWith("selectColor:") && (colorDef = themeRegistry.findColor(id = command.substring(12))) != null) {
            this.selectAndReveal(colorDef);
        }
    }

    private void selectAndReveal(Object selection) {
        TreeViewer viewer = this.tree.getViewer();
        viewer.setSelection((ISelection)new StructuredSelection(selection), false);
        viewer.reveal(selection);
        viewer.getTree().setFocus();
    }

    private static boolean equals(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private ITheme getActiveTheme() {
        if (this.themeEngine != null) {
            return this.themeEngine.getActiveTheme();
        }
        return null;
    }

    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, 0x1000008);
        button.setText(label);
        this.myApplyDialogFont((Control)button);
        this.setButtonLayoutData(button);
        button.setEnabled(false);
        return button;
    }

    private Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setFont(parent.getFont());
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.font_preference_page_context");
        parent.addDisposeListener(e -> {
            if (this.appliedDialogFont != null) {
                this.appliedDialogFont.dispose();
            }
        });
        SashForm advancedComposite = new SashForm(parent, 512);
        GridData sashData = new GridData(4, 4, true, true);
        advancedComposite.setLayoutData((Object)sashData);
        Composite mainColumn = new Composite((Composite)advancedComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        mainColumn.setFont(parent.getFont());
        mainColumn.setLayout((Layout)layout);
        GridData data = new GridData(1);
        data.horizontalSpan = 2;
        Label label = new Label(mainColumn, 16384);
        label.setText(RESOURCE_BUNDLE.getString("colorsAndFonts"));
        this.myApplyDialogFont((Control)label);
        label.setLayoutData((Object)data);
        this.createTree(mainColumn);
        Composite controlColumn = new Composite(mainColumn, 0);
        data = new GridData(1040);
        controlColumn.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        controlColumn.setLayout((Layout)layout);
        Label placeholder = new Label(controlColumn, 0);
        GridData placeholderData = new GridData(128);
        placeholderData.heightHint = this.convertVerticalDLUsToPixels(12);
        placeholder.setLayoutData((Object)placeholderData);
        this.fontChangeButton = this.createButton(controlColumn, RESOURCE_BUNDLE.getString("openChange"));
        this.fontSystemButton = this.createButton(controlColumn, WorkbenchMessages.FontsPreference_useSystemFont);
        this.fontResetButton = this.createButton(controlColumn, RESOURCE_BUNDLE.getString("reset"));
        this.createSeparator(controlColumn);
        this.editDefaultButton = this.createButton(controlColumn, RESOURCE_BUNDLE.getString("editDefault"));
        this.goToDefaultButton = this.createButton(controlColumn, RESOURCE_BUNDLE.getString("goToDefault"));
        this.createSeparator(controlColumn);
        this.expandAllButton = this.createButton(controlColumn, RESOURCE_BUNDLE.getString("expandAll"));
        this.expandAllButton.setEnabled(true);
        this.createDescriptionControl(mainColumn);
        Composite previewColumn = new Composite((Composite)advancedComposite, 0);
        GridLayout previewLayout = new GridLayout();
        previewLayout.marginTop = 7;
        previewLayout.marginWidth = 0;
        previewLayout.marginHeight = 0;
        previewColumn.setFont(parent.getFont());
        previewColumn.setLayout((Layout)previewLayout);
        Composite composite = new Composite(previewColumn, 0);
        GridData data2 = new GridData(1808);
        composite.setLayoutData((Object)data2);
        GridLayout layout2 = new GridLayout(1, true);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        composite.setLayout((Layout)layout2);
        Label label2 = new Label(composite, 16384);
        label2.setText(RESOURCE_BUNDLE.getString("preview"));
        this.myApplyDialogFont((Control)label2);
        this.previewComposite = new Composite(composite, 0);
        this.previewComposite.setLayoutData((Object)new GridData(1808));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.previewComposite.setLayout((Layout)this.stackLayout);
        this.defaultFontPreview = this.createFontPreviewControl();
        this.defaultColorPreview = this.createColorPreviewControl();
        this.defaultNoPreview = this.createNoPreviewControl();
        this.hookListeners();
        this.updateTreeSelection(this.tree.getViewer().getSelection());
        advancedComposite.setWeights(new int[]{75, 25});
        return advancedComposite;
    }

    private void createTree(Composite parent) {
        this.labelProvider = new PresentationLabelProvider();
        PatternFilter filter = new PatternFilter(){

            @Override
            protected boolean isLeafMatch(Viewer viewer, Object element) {
                if (super.isLeafMatch(viewer, element)) {
                    return true;
                }
                return this.wordMatches(this.getText(element));
            }

            private String getText(Object element) {
                FontData[] fontDataArray;
                Font font;
                StringBuilder text = new StringBuilder(ColorsAndFontsPreferencePage.EMPTY);
                if (element instanceof ICategorizedThemeElementDefinition) {
                    text.append(((ICategorizedThemeElementDefinition)element).getDescription());
                }
                if (element instanceof FontDefinition && (font = ColorsAndFontsPreferencePage.this.fontRegistry.get(((FontDefinition)element).getId())) != null && (fontDataArray = font.getFontData()).length != 0) {
                    FontData data = fontDataArray[0];
                    text.append(ColorsAndFontsPreferencePage.SPACE);
                    text.append(String.valueOf(data.getName()) + ColorsAndFontsPreferencePage.SPACE);
                    text.append(String.valueOf(data.getHeight()) + ColorsAndFontsPreferencePage.SPACE);
                    text.append(data.getStyle() == 0 ? String.valueOf(RESOURCE_BUNDLE.getString("normalFont")) + ColorsAndFontsPreferencePage.SPACE : ColorsAndFontsPreferencePage.EMPTY);
                    text.append((data.getStyle() & 1) == 1 ? String.valueOf(RESOURCE_BUNDLE.getString("boldFont")) + ColorsAndFontsPreferencePage.SPACE : ColorsAndFontsPreferencePage.EMPTY);
                    text.append((data.getStyle() & 2) == 2 ? String.valueOf(RESOURCE_BUNDLE.getString("italicFont")) + ColorsAndFontsPreferencePage.SPACE : ColorsAndFontsPreferencePage.EMPTY);
                }
                return text.toString();
            }
        };
        filter.setIncludeLeadingWildcard(true);
        this.tree = new FilteredTree(parent, 2820, filter, true);
        this.tree.setQuickSelectionMode(true);
        GridData data = new GridData(1808);
        data.widthHint = Math.max(285, this.convertWidthInCharsToPixels(30));
        data.heightHint = Math.max(175, this.convertHeightInCharsToPixels(10));
        this.tree.setLayoutData(data);
        this.myApplyDialogFont(this.tree.getViewer().getControl());
        Text filterText = this.tree.getFilterControl();
        if (filterText != null) {
            this.myApplyDialogFont((Control)filterText);
        }
        this.tree.getViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tree.getViewer().setContentProvider((IContentProvider)new ThemeContentProvider());
        this.tree.getViewer().setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof ThemeElementCategory) {
                    return 0;
                }
                return 1;
            }
        });
        this.tree.getViewer().setInput((Object)WorkbenchPlugin.getDefault().getThemeRegistry());
        this.tree.getViewer().addDoubleClickListener(event -> {
            IStructuredSelection s = (IStructuredSelection)event.getSelection();
            Object element = s.getFirstElement();
            if (this.tree.getViewer().isExpandable(element)) {
                this.tree.getViewer().setExpandedState(element, !this.tree.getViewer().getExpandedState(element));
            }
            if (element instanceof ThemeElementDefinition) {
                ThemeElementDefinition definition = (ThemeElementDefinition)element;
                if (element instanceof FontDefinition) {
                    this.editFont(this.tree.getDisplay());
                } else if (element instanceof ColorDefinition && this.isAvailableInCurrentTheme(definition)) {
                    this.editColor(this.tree.getDisplay());
                }
                this.updateControls();
            }
        });
        this.restoreTreeExpansion();
        this.restoreTreeSelection();
    }

    public void dispose() {
        this.eventBroker.unsubscribe(this.themeRegistryRestyledHandler);
        this.workbench.getThemeManager().removePropertyChangeListener(this.themeChangeListener);
        this.clearPreviews();
        this.colorRegistry.dispose();
        this.fontRegistry.dispose();
        super.dispose();
    }

    private void clearPreviews() {
        if (this.cascadingTheme != null) {
            this.cascadingTheme.dispose();
        }
        for (IThemePreview preview : this.previewSet) {
            try {
                preview.dispose();
            }
            catch (RuntimeException e) {
                WorkbenchPlugin.log(RESOURCE_BUNDLE.getString("errorDisposePreviewLog"), StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
            }
        }
        this.previewSet.clear();
    }

    private ColorDefinition getColorAncestor(ColorDefinition definition) {
        String defaultsTo = definition.getDefaultsTo();
        if (defaultsTo == null) {
            return null;
        }
        return this.themeRegistry.findColor(defaultsTo);
    }

    private RGB getColorAncestorValue(ColorDefinition definition) {
        ColorDefinition ancestor = this.getColorAncestor(definition);
        if (ancestor == null) {
            return null;
        }
        return this.getColorValue(ancestor);
    }

    private RGB getColorValue(ColorDefinition definition) {
        String id = definition.getId();
        RGB updatedRGB = this.colorPreferencesToSet.get(definition);
        if (updatedRGB == null && (updatedRGB = this.colorValuesToSet.get(id)) == null) {
            updatedRGB = this.currentTheme.getColorRegistry().getRGB(id);
        }
        return updatedRGB;
    }

    private ColorDefinition[] getDescendantColors(ColorDefinition definition) {
        ArrayList<ColorDefinition> list = new ArrayList<ColorDefinition>(5);
        String id = definition.getId();
        IHierarchalThemeElementDefinition[] colors = this.themeRegistry.getColors();
        ColorDefinition[] sorted = new ColorDefinition[colors.length];
        System.arraycopy(colors, 0, sorted, 0, sorted.length);
        Arrays.sort(sorted, new IThemeRegistry.HierarchyComparator(colors));
        ColorDefinition[] colorDefinitionArray = sorted;
        int n = sorted.length;
        int n2 = 0;
        while (n2 < n) {
            ColorDefinition colorDefinition = colorDefinitionArray[n2];
            if (id.equals(colorDefinition.getDefaultsTo())) {
                list.add(colorDefinition);
            }
            ++n2;
        }
        return list.toArray(new ColorDefinition[list.size()]);
    }

    private FontDefinition[] getDescendantFonts(FontDefinition definition) {
        ArrayList<FontDefinition> list = new ArrayList<FontDefinition>(5);
        String id = definition.getId();
        IHierarchalThemeElementDefinition[] fonts = this.themeRegistry.getFonts();
        FontDefinition[] sorted = new FontDefinition[fonts.length];
        System.arraycopy(fonts, 0, sorted, 0, sorted.length);
        Arrays.sort(sorted, new IThemeRegistry.HierarchyComparator(fonts));
        FontDefinition[] fontDefinitionArray = sorted;
        int n = sorted.length;
        int n2 = 0;
        while (n2 < n) {
            FontDefinition fontDefinition = fontDefinitionArray[n2];
            if (id.equals(fontDefinition.getDefaultsTo())) {
                list.add(fontDefinition);
            }
            ++n2;
        }
        return list.toArray(new FontDefinition[list.size()]);
    }

    private FontDefinition getFontAncestor(FontDefinition definition) {
        String defaultsTo = definition.getDefaultsTo();
        if (defaultsTo == null) {
            return null;
        }
        return this.themeRegistry.findFont(defaultsTo);
    }

    private FontData[] getFontAncestorValue(FontDefinition definition) {
        FontDefinition ancestor = this.getFontAncestor(definition);
        if (ancestor == null) {
            return PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)this.createPreferenceKey(definition));
        }
        return this.getFontValue(ancestor);
    }

    protected FontData[] getFontValue(FontDefinition definition) {
        String id = definition.getId();
        FontData[] updatedFD = this.fontPreferencesToSet.get(definition);
        if (updatedFD == null && (updatedFD = this.fontValuesToSet.get(id)) == null) {
            updatedFD = this.currentTheme.getFontRegistry().getFontData(id);
        }
        return updatedFD;
    }

    protected ColorDefinition getSelectedColorDefinition() {
        Object o = this.tree.getViewer().getStructuredSelection().getFirstElement();
        if (o instanceof ColorDefinition) {
            return this.themeRegistry.findColor(((ColorDefinition)o).getId());
        }
        return null;
    }

    protected FontDefinition getSelectedFontDefinition() {
        Object o = this.tree.getViewer().getStructuredSelection().getFirstElement();
        if (o instanceof FontDefinition) {
            return this.themeRegistry.findFont(((FontDefinition)o).getId());
        }
        return null;
    }

    protected boolean isFontSelected() {
        Object o = this.tree.getViewer().getStructuredSelection().getFirstElement();
        return o instanceof FontDefinition;
    }

    protected boolean isColorSelected() {
        Object o = this.tree.getViewer().getStructuredSelection().getFirstElement();
        return o instanceof ColorDefinition;
    }

    private void hookListeners() {
        TreeViewer viewer = this.tree.getViewer();
        viewer.addSelectionChangedListener(event -> this.updateTreeSelection(event.getSelection()));
        this.fontChangeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            Display display = event.display;
            if (this.isFontSelected()) {
                this.editFont(display);
            } else if (this.isColorSelected()) {
                this.editColor(display);
            }
            this.updateControls();
        }));
        this.fontResetButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.isFontSelected()) {
                this.resetFont(this.getSelectedFontDefinition(), false);
            } else if (this.isColorSelected()) {
                this.resetColor(this.getSelectedColorDefinition(), false);
            }
            this.updateControls();
        }));
        this.fontSystemButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            FontDefinition definition = this.getSelectedFontDefinition();
            if (definition == null) {
                return;
            }
            FontData[] defaultFontData = JFaceResources.getDefaultFont().getFontData();
            this.setFontPreferenceValue(definition, defaultFontData, false);
            this.updateControls();
        }));
        this.editDefaultButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            Display display = event.display;
            FontDefinition fontDefinition = this.getSelectedFontDefinition();
            if (fontDefinition != null) {
                String defaultFontId = fontDefinition.getDefaultsTo();
                FontDefinition defaultFontDefinition = this.themeRegistry.findFont(defaultFontId);
                this.editFont(defaultFontDefinition, display);
            } else {
                ColorDefinition colorDefinition = this.getSelectedColorDefinition();
                if (colorDefinition != null) {
                    String defaultColorId = colorDefinition.getDefaultsTo();
                    ColorDefinition defaultColorDefinition = this.themeRegistry.findColor(defaultColorId);
                    this.editColor(defaultColorDefinition, display);
                }
            }
            this.updateControls();
        }));
        this.goToDefaultButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            FontDefinition fontDefinition = this.getSelectedFontDefinition();
            if (fontDefinition != null) {
                String defaultFontId = fontDefinition.getDefaultsTo();
                FontDefinition defaultFontDefinition = this.themeRegistry.findFont(defaultFontId);
                this.selectAndReveal(defaultFontDefinition);
            } else {
                ColorDefinition colorDefinition = this.getSelectedColorDefinition();
                if (colorDefinition != null) {
                    String defaultColorId = colorDefinition.getDefaultsTo();
                    ColorDefinition defaultColorDefinition = this.themeRegistry.findColor(defaultColorId);
                    this.selectAndReveal(defaultColorDefinition);
                }
            }
            this.updateControls();
        }));
        this.expandAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.tree.getViewer().expandAll()));
    }

    @Override
    public void init(IWorkbench aWorkbench) {
        this.workbench = (Workbench)aWorkbench;
        this.themeEngine = this.workbench.getService(IThemeEngine.class);
        this.setPreferenceStore(PrefUtil.getInternalPreferenceStore());
        IThemeManager themeManager = aWorkbench.getThemeManager();
        this.themeChangeListener = event -> {
            if (event.getProperty().equals("CHANGE_CURRENT_THEME")) {
                this.updateThemeInfo(themeManager);
                this.refreshCategory();
                this.refreshAllLabels();
            }
        };
        themeManager.addPropertyChangeListener(this.themeChangeListener);
        this.updateThemeInfo(themeManager);
        this.eventBroker = this.workbench.getService(IEventBroker.class);
        this.eventBroker.subscribe("org/eclipse/ui/internal/themes/WorkbenchThemeManager/themeRegistryRestyled", this.themeRegistryRestyledHandler);
    }

    private void updateThemeInfo(IThemeManager manager) {
        this.clearPreviews();
        this.categoryMap.clear();
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.colorRegistry != null) {
            this.colorRegistry.dispose();
        }
        if (this.fontRegistry != null) {
            this.fontRegistry.dispose();
        }
        this.currentTheme = manager.getCurrentTheme();
        this.currentCSSTheme = this.getActiveTheme();
        this.colorRegistry = new CascadingColorRegistry(this.currentTheme.getColorRegistry());
        this.fontRegistry = new CascadingFontRegistry(this.currentTheme.getFontRegistry());
        if (this.cascadingTheme != null) {
            this.cascadingTheme.dispose();
            this.cascadingTheme = new CascadingThemeExt(this.currentTheme, this.colorRegistry, this.fontRegistry);
        }
        this.fontPreferencesToSet.clear();
        this.fontValuesToSet.clear();
        this.colorPreferencesToSet.clear();
        this.colorValuesToSet.clear();
        if (this.labelProvider != null) {
            this.labelProvider.hookListeners();
        }
    }

    private boolean isDefault(ColorDefinition definition) {
        RGB rgb;
        String id = definition.getId();
        return this.colorPreferencesToSet.containsKey(definition) ? (definition.getValue() != null ? this.colorPreferencesToSet.get(definition).equals((Object)definition.getValue()) : this.colorPreferencesToSet.get(definition).equals((Object)this.getColorAncestorValue(definition))) : (this.colorValuesToSet.containsKey(id) ? (definition.getValue() != null ? this.colorValuesToSet.get(id).equals((Object)definition.getValue()) : this.colorValuesToSet.get(id).equals((Object)this.getColorAncestorValue(definition))) : (definition.getValue() != null ? this.getPreferenceStore().isDefault(this.createPreferenceKey(definition)) : (rgb = this.getColorValue(definition)) != null && rgb.equals((Object)this.getColorAncestorValue(definition))));
    }

    private boolean isDefault(FontDefinition definition) {
        String id = definition.getId();
        if (this.fontPreferencesToSet.containsKey(definition)) {
            if (definition.getValue() != null) {
                if (Arrays.equals(this.fontPreferencesToSet.get(definition), definition.getValue())) {
                    return true;
                }
            } else {
                Object[] ancestor = this.getFontAncestorValue(definition);
                if (Arrays.equals(this.fontPreferencesToSet.get(definition), ancestor)) {
                    return true;
                }
            }
        } else if (this.fontValuesToSet.containsKey(id)) {
            if (definition.getValue() != null) {
                if (Arrays.equals(this.fontValuesToSet.get(id), definition.getValue())) {
                    return true;
                }
            } else {
                Object[] ancestor = this.getFontAncestorValue(definition);
                if (Arrays.equals(this.fontValuesToSet.get(id), ancestor)) {
                    return true;
                }
            }
        } else if (definition.getValue() != null) {
            if (this.getPreferenceStore().isDefault(this.createPreferenceKey(definition))) {
                return true;
            }
        } else {
            Object[] ancestor = this.getFontAncestorValue(definition);
            if (ancestor == null) {
                return true;
            }
            if (Arrays.equals(this.getFontValue(definition), ancestor)) {
                return true;
            }
        }
        return false;
    }

    private void myApplyDialogFont(Control control) {
        control.setFont(JFaceResources.getDialogFont());
        this.dialogFontWidgets.add(control);
    }

    protected void performApply() {
        super.performApply();
        Font oldFont = this.appliedDialogFont;
        FontDefinition fontDefinition = this.themeRegistry.findFont("org.eclipse.jface.dialogfont");
        if (fontDefinition == null) {
            return;
        }
        FontData[] newData = this.getFontValue(fontDefinition);
        this.appliedDialogFont = new Font((Device)this.getControl().getDisplay(), newData);
        this.updateForDialogFontChange(this.appliedDialogFont);
        this.getApplyButton().setFont(this.appliedDialogFont);
        this.getDefaultsButton().setFont(this.appliedDialogFont);
        if (oldFont != null) {
            oldFont.dispose();
        }
        if (this.performColorOk() && this.performFontOk()) {
            this.publishThemeRegistryModifiedEvent();
        }
    }

    private void performColorDefaults() {
        IHierarchalThemeElementDefinition[] definitions = this.themeRegistry.getColors();
        ColorDefinition[] definitionsCopy = new ColorDefinition[definitions.length];
        System.arraycopy(definitions, 0, definitionsCopy, 0, definitions.length);
        Arrays.sort(definitionsCopy, new IThemeRegistry.HierarchyComparator(definitions));
        ColorDefinition[] colorDefinitionArray = definitionsCopy;
        int n = definitionsCopy.length;
        int n2 = 0;
        while (n2 < n) {
            ColorDefinition colorDefinition = colorDefinitionArray[n2];
            this.resetColor(colorDefinition, true);
            ++n2;
        }
    }

    private boolean performColorOk() {
        for (Map.Entry<ColorDefinition, RGB> entry : this.colorPreferencesToSet.entrySet()) {
            String storeString;
            String key = this.createPreferenceKey(entry.getKey());
            String rgbString = StringConverter.asString((RGB)entry.getValue());
            if (rgbString.equals(storeString = this.getPreferenceStore().getString(key))) continue;
            this.getPreferenceStore().setValue(key, rgbString);
        }
        this.colorValuesToSet.clear();
        this.colorPreferencesToSet.clear();
        return true;
    }

    private String createPreferenceKey(ThemeElementDefinition definition) {
        if (definition.isOverridden() || definition.isAddedByCss()) {
            return ThemeElementHelper.createPreferenceKey(this.currentCSSTheme, this.currentTheme, definition.getId());
        }
        return ThemeElementHelper.createPreferenceKey(this.currentTheme, definition.getId());
    }

    public void performDefaults() {
        this.performColorDefaults();
        this.performFontDefaults();
        this.updateControls();
        this.tree.getViewer().refresh();
    }

    private void performFontDefaults() {
        IHierarchalThemeElementDefinition[] definitions = this.themeRegistry.getFonts();
        FontDefinition[] definitionsCopy = new FontDefinition[definitions.length];
        System.arraycopy(definitions, 0, definitionsCopy, 0, definitions.length);
        Arrays.sort(definitionsCopy, new IThemeRegistry.HierarchyComparator(definitions));
        FontDefinition[] fontDefinitionArray = definitionsCopy;
        int n = definitionsCopy.length;
        int n2 = 0;
        while (n2 < n) {
            FontDefinition fontDefinition = fontDefinitionArray[n2];
            this.resetFont(fontDefinition, true);
            ++n2;
        }
    }

    private boolean performFontOk() {
        for (Map.Entry<FontDefinition, FontData[]> entry : this.fontPreferencesToSet.entrySet()) {
            String storeString;
            String key = this.createPreferenceKey(entry.getKey());
            String fdString = PreferenceConverter.getStoredRepresentation((FontData[])entry.getValue());
            if (fdString.equals(storeString = this.getPreferenceStore().getString(key))) continue;
            this.getPreferenceStore().setValue(key, fdString);
        }
        this.fontValuesToSet.clear();
        this.fontPreferencesToSet.clear();
        return true;
    }

    public boolean performOk() {
        boolean result;
        this.saveTreeExpansion();
        this.saveTreeSelection();
        boolean bl = result = this.performColorOk() && this.performFontOk();
        if (result) {
            PrefUtil.savePrefs();
            this.publishThemeRegistryModifiedEvent();
        }
        return result;
    }

    private void refreshCategory() {
        this.updateControls();
    }

    private boolean resetColor(ColorDefinition definition, boolean force) {
        RGB newRGB;
        if ((force || !this.isDefault(definition)) && (newRGB = definition.getValue() != null ? definition.getValue() : this.getColorAncestorValue(definition)) != null) {
            this.setColorPreferenceValue(definition, newRGB, true);
            this.setRegistryValue(definition, newRGB);
            this.refreshElement(definition);
            return true;
        }
        return false;
    }

    protected boolean resetFont(FontDefinition definition, boolean force) {
        FontData[] newFD;
        if ((force || !this.isDefault(definition)) && (newFD = definition.isOverridden() ? definition.getValue() : (!force && definition.getDefaultsTo() != null ? this.getFontAncestorValue(definition) : PreferenceConverter.getDefaultFontDataArray((IPreferenceStore)this.getPreferenceStore(), (String)this.createPreferenceKey(definition)))) != null) {
            this.setFontPreferenceValue(definition, newFD, true);
            this.refreshElement(definition);
            return true;
        }
        return false;
    }

    protected void setColorPreferenceValue(ColorDefinition definition, RGB newRGB, boolean reset) {
        this.setDescendantRegistryValues(definition, newRGB);
        this.colorPreferencesToSet.put(definition, newRGB);
        this.updateDefinitionState(definition, reset);
    }

    private void setDescendantRegistryValues(ColorDefinition definition, RGB newRGB) {
        ColorDefinition[] colorDefinitionArray = this.getDescendantColors(definition);
        int n = colorDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColorDefinition colorDefinition = colorDefinitionArray[n2];
            if (this.isDefault(colorDefinition)) {
                this.setDescendantRegistryValues(colorDefinition, newRGB);
                this.setRegistryValue(colorDefinition, newRGB);
                this.colorValuesToSet.put(colorDefinition.getId(), newRGB);
            }
            ++n2;
        }
    }

    private void setDescendantRegistryValues(FontDefinition definition, FontData[] datas, boolean reset) {
        FontDefinition[] fontDefinitionArray = this.getDescendantFonts(definition);
        int n = fontDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            FontDefinition fontDefinition = fontDefinitionArray[n2];
            if (this.isDefault(fontDefinition)) {
                this.setFontPreferenceValue(fontDefinition, datas, reset);
            }
            ++n2;
        }
    }

    protected void setFontPreferenceValue(FontDefinition definition, FontData[] datas, boolean reset) {
        this.setDescendantRegistryValues(definition, datas, reset);
        this.fontPreferencesToSet.put(definition, datas);
        this.setRegistryValue(definition, datas);
        this.updateDefinitionState(definition, reset);
    }

    protected void setRegistryValue(ColorDefinition definition, RGB newRGB) {
        this.colorRegistry.put(definition.getId(), newRGB);
    }

    protected void setRegistryValue(FontDefinition definition, FontData[] datas) {
        this.fontRegistry.put(definition.getId(), datas);
    }

    private IThemePreview getThemePreview(ThemeElementCategory category) throws CoreException {
        int idx;
        IThemePreview preview = category.createPreview();
        if (preview != null) {
            return preview;
        }
        if (category.getParentId() != null && (idx = Arrays.binarySearch(this.themeRegistry.getCategories(), category.getParentId(), IThemeRegistry.ID_COMPARATOR)) >= 0) {
            return this.getThemePreview(this.themeRegistry.getCategories()[idx]);
        }
        return null;
    }

    private CascadingThemeExt getCascadingTheme() {
        if (this.cascadingTheme == null) {
            this.cascadingTheme = new CascadingThemeExt(this.currentTheme, this.colorRegistry, this.fontRegistry);
        }
        return this.cascadingTheme;
    }

    private void updateForDialogFontChange(Font newFont) {
        Iterator<Control> iterator = this.dialogFontWidgets.iterator();
        while (iterator.hasNext()) {
            iterator.next().setFont(newFont);
        }
        this.labelProvider.clearFontCacheAndUpdate();
    }

    private void updateTreeSelection(ISelection selection) {
        String categoryID;
        ThemeElementCategory category = null;
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof ThemeElementCategory) {
            category = (ThemeElementCategory)element;
        } else if (element instanceof ColorDefinition) {
            categoryID = ((ColorDefinition)element).getCategoryId();
            category = WorkbenchPlugin.getDefault().getThemeRegistry().findCategory(categoryID);
        } else if (element instanceof FontDefinition) {
            categoryID = ((FontDefinition)element).getCategoryId();
            category = WorkbenchPlugin.getDefault().getThemeRegistry().findCategory(categoryID);
        }
        Composite previewControl = null;
        if (category != null && (previewControl = this.previewMap.get(category)) == null) {
            try {
                IThemePreview preview = this.getThemePreview(category);
                if (preview != null) {
                    previewControl = new Composite(this.previewComposite, 0);
                    previewControl.setLayout((Layout)new FillLayout());
                    CascadingThemeExt theme = this.getCascadingTheme();
                    preview.createControl(previewControl, theme);
                    this.previewSet.add(preview);
                    this.previewMap.put(category, previewControl);
                }
            }
            catch (CoreException e) {
                previewControl = new Composite(this.previewComposite, 0);
                previewControl.setLayout((Layout)new FillLayout());
                this.myApplyDialogFont((Control)previewControl);
                Text error = new Text(previewControl, 72);
                error.setText(RESOURCE_BUNDLE.getString("errorCreatingPreview"));
                WorkbenchPlugin.log(RESOURCE_BUNDLE.getString("errorCreatePreviewLog"), StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
            }
        }
        if (previewControl == null) {
            previewControl = element instanceof ColorDefinition ? this.defaultColorPreview : (element instanceof FontDefinition ? this.defaultFontPreview : this.defaultNoPreview);
        }
        this.stackLayout.topControl = previewControl;
        this.previewComposite.layout();
        this.updateControls();
    }

    private void restoreTreeSelection() {
        String selectedElementString = this.getPreferenceStore().getString(SELECTED_ELEMENT_PREF);
        if (selectedElementString == null) {
            return;
        }
        IThemeElementDefinition element = this.findElementFromMarker(selectedElementString);
        if (element == null) {
            return;
        }
        this.tree.getViewer().setSelection((ISelection)new StructuredSelection((Object)element), true);
    }

    private void saveTreeSelection() {
        ITreeSelection selection = this.tree.getViewer().getStructuredSelection();
        Object element = selection.getFirstElement();
        StringBuilder buffer = new StringBuilder();
        this.appendMarkerToBuffer(buffer, element);
        if (buffer.length() > 0) {
            buffer.append(((IThemeElementDefinition)element).getId());
        }
        this.getPreferenceStore().setValue(SELECTED_ELEMENT_PREF, buffer.toString());
    }

    private void restoreTreeExpansion() {
        String expandedElementsString = this.getPreferenceStore().getString(EXPANDED_ELEMENTS_PREF);
        if (expandedElementsString == null) {
            return;
        }
        String[] expandedElementIDs = expandedElementsString.split(EXPANDED_ELEMENTS_TOKEN);
        if (expandedElementIDs.length == 0) {
            return;
        }
        ArrayList<IThemeElementDefinition> elements = new ArrayList<IThemeElementDefinition>(expandedElementIDs.length);
        String[] stringArray = expandedElementIDs;
        int n = expandedElementIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String expandedElementID = stringArray[n2];
            IThemeElementDefinition def = this.findElementFromMarker(expandedElementID);
            if (def != null) {
                elements.add(def);
            }
            ++n2;
        }
        this.tree.getViewer().setExpandedElements(elements.toArray());
    }

    private IThemeElementDefinition findElementFromMarker(String string) {
        if (string.length() < 2) {
            return null;
        }
        char marker = string.charAt(0);
        String id = string.substring(1);
        IThemeElementDefinition def = null;
        switch (marker) {
            case 'F': {
                def = this.themeRegistry.findFont(id);
                break;
            }
            case 'C': {
                def = this.themeRegistry.findColor(id);
                break;
            }
            case 'T': {
                def = this.themeRegistry.findCategory(id);
            }
        }
        return def;
    }

    private void saveTreeExpansion() {
        Object[] elements = this.tree.getViewer().getExpandedElements();
        ArrayList<String> elementIds = new ArrayList<String>(elements.length);
        StringBuilder buffer = new StringBuilder();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this.appendMarkerToBuffer(buffer, object);
            if (buffer.length() != 0) {
                buffer.append(((IThemeElementDefinition)object).getId());
                elementIds.add(buffer.toString());
            }
            buffer.setLength(0);
            ++n2;
        }
        Iterator i = elementIds.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            buffer.append(id);
            if (!i.hasNext()) continue;
            buffer.append(EXPANDED_ELEMENTS_TOKEN);
        }
        this.getPreferenceStore().setValue(EXPANDED_ELEMENTS_PREF, buffer.toString());
    }

    private void appendMarkerToBuffer(StringBuilder buffer, Object object) {
        if (object instanceof FontDefinition) {
            buffer.append('F');
        } else if (object instanceof ColorDefinition) {
            buffer.append('C');
        } else if (object instanceof ThemeElementCategory) {
            buffer.append('T');
        }
    }

    private void editFont(Display display) {
        this.editFont(this.getSelectedFontDefinition(), display);
    }

    private void editFont(FontDefinition definition, Display display) {
        if (definition != null) {
            FontDialog fontDialog = new FontDialog(this.getShell());
            fontDialog.setEffectsVisible(false);
            fontDialog.setFontList(this.getFontValue(definition));
            FontData data = fontDialog.open();
            if (data != null) {
                this.setFontPreferenceValue(definition, fontDialog.getFontList(), false);
                this.refreshElement(definition);
            }
        }
    }

    private void editColor(Display display) {
        this.editColor(this.getSelectedColorDefinition(), display);
    }

    private void editColor(ColorDefinition definition, Display display) {
        if (definition == null) {
            return;
        }
        RGB currentColor = this.colorRegistry.getRGB(definition.getId());
        ColorDialog colorDialog = new ColorDialog(display.getActiveShell());
        colorDialog.setRGB(currentColor);
        RGB selectedColor = colorDialog.open();
        if (selectedColor != null && !selectedColor.equals((Object)currentColor)) {
            this.setColorPreferenceValue(definition, selectedColor, false);
            this.setRegistryValue(definition, selectedColor);
            this.refreshElement(definition);
        }
    }

    protected void updateControls() {
        FontDefinition fontDefinition = this.getSelectedFontDefinition();
        if (fontDefinition != null) {
            boolean isSetToDefault = this.isDefault(fontDefinition);
            boolean hasEditableDefault = this.defaultIsEditable(fontDefinition);
            this.fontChangeButton.setEnabled(true);
            this.fontSystemButton.setEnabled(true);
            this.fontResetButton.setEnabled(!isSetToDefault);
            this.editDefaultButton.setEnabled(hasEditableDefault && isSetToDefault);
            this.goToDefaultButton.setEnabled(hasEditableDefault);
            this.setCurrentFont(fontDefinition);
            return;
        }
        ColorDefinition colorDefinition = this.getSelectedColorDefinition();
        if (colorDefinition != null) {
            boolean isSetToDefault = this.isDefault(this.getSelectedColorDefinition());
            boolean hasEditableDefault = this.defaultIsEditable(colorDefinition);
            this.fontChangeButton.setEnabled(true);
            this.fontSystemButton.setEnabled(false);
            this.fontResetButton.setEnabled(!isSetToDefault);
            this.editDefaultButton.setEnabled(hasEditableDefault && isSetToDefault);
            this.goToDefaultButton.setEnabled(hasEditableDefault);
            this.setCurrentColor(colorDefinition);
            return;
        }
        this.fontChangeButton.setEnabled(false);
        this.fontSystemButton.setEnabled(false);
        this.fontResetButton.setEnabled(false);
        this.editDefaultButton.setEnabled(false);
        this.goToDefaultButton.setEnabled(false);
        this.descriptionText.setText(EMPTY);
    }

    private boolean defaultIsEditable(IHierarchalThemeElementDefinition definition) {
        assert (definition instanceof ColorDefinition || definition instanceof FontDefinition);
        String defaultId = definition.getDefaultsTo();
        if (defaultId == null) {
            return false;
        }
        ThemeElementDefinition defaultDefinition = null;
        if (definition instanceof ColorDefinition) {
            defaultDefinition = this.themeRegistry.findColor(defaultId);
        } else if (definition instanceof FontDefinition) {
            defaultDefinition = this.themeRegistry.findFont(defaultId);
        }
        return defaultDefinition != null && defaultDefinition.isEditable();
    }

    private Composite createNoPreviewControl() {
        Composite noPreviewControl = new Composite(this.previewComposite, 0);
        noPreviewControl.setLayout((Layout)new FillLayout());
        Label l = new Label(noPreviewControl, 16384);
        l.setText(RESOURCE_BUNDLE.getString("noPreviewAvailable"));
        this.myApplyDialogFont((Control)l);
        return noPreviewControl;
    }

    private void setCurrentFont(FontDefinition fontDefinition) {
        this.currentFont = this.fontRegistry.get(fontDefinition.getId());
        FontData[] fontData = this.currentFont != null ? this.currentFont.getFontData() : new FontData[]{};
        StringBuilder tmp = new StringBuilder();
        FontData[] fontDataArray = fontData;
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData currentFontData = fontDataArray[n2];
            tmp.append(currentFontData.getName());
            tmp.append(' ');
            tmp.append(currentFontData.getHeight());
            int style = currentFontData.getStyle();
            if ((style & 1) != 0) {
                tmp.append(' ');
                tmp.append(RESOURCE_BUNDLE.getString("boldFont"));
            }
            if ((style & 2) != 0) {
                tmp.append(' ');
                tmp.append(RESOURCE_BUNDLE.getString("italicFont"));
            }
            ++n2;
        }
        this.fontSampleText = tmp.toString();
        this.descriptionText.setText(this.fomatDescription(fontDefinition));
        this.fontSampler.redraw();
    }

    public void setCurrentColor(ColorDefinition colorDefinition) {
        this.currentColor = this.colorRegistry.get(colorDefinition.getId());
        this.colorSampler.redraw();
        this.descriptionText.setText(this.fomatDescription(colorDefinition));
    }

    private Composite createFontPreviewControl() {
        this.fontSampler = new Canvas(this.previewComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.fontSampler.setLayout((Layout)gridLayout);
        this.fontSampler.setLayoutData((Object)new GridData(1808));
        this.fontSampler.addPaintListener(e -> {
            if (this.currentFont != null) {
                this.paintFontSample(e.gc);
            }
        });
        return this.fontSampler;
    }

    private void paintFontSample(GC gc) {
        if (this.currentFont == null || this.currentFont.isDisposed()) {
            return;
        }
        Rectangle clientArea = this.colorSampler.getClientArea();
        FontMetrics standardFontMetrics = gc.getFontMetrics();
        int standardLineHeight = standardFontMetrics.getHeight();
        int maxHeight = standardLineHeight * 4;
        if (clientArea.height > maxHeight) {
            clientArea = new Rectangle(clientArea.x, clientArea.y, clientArea.width, maxHeight);
        }
        gc.setForeground(this.previewComposite.getDisplay().getSystemColor(18));
        gc.drawRectangle(0, 0, clientArea.width - 1, clientArea.height - 1);
        gc.setForeground(this.previewComposite.getDisplay().getSystemColor(2));
        gc.setFont(this.currentFont);
        FontMetrics fontMetrics = gc.getFontMetrics();
        int lineHeight = fontMetrics.getHeight();
        int topY = clientArea.y + 5;
        gc.setClipping(1, 1, clientArea.width - 2, clientArea.height - 2);
        gc.drawText(this.fontSampleText, clientArea.x + 5, topY);
        gc.drawText(RESOURCE_BUNDLE.getString("fontTextSample"), clientArea.x + 5, topY + lineHeight);
    }

    private Composite createColorPreviewControl() {
        this.colorSampler = new Canvas(this.previewComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.colorSampler.setLayout((Layout)gridLayout);
        this.colorSampler.setLayoutData((Object)new GridData(1808));
        this.colorSampler.addPaintListener(e -> {
            if (this.currentColor != null) {
                this.paintColorSample(e.gc);
            }
        });
        return this.colorSampler;
    }

    private void paintColorSample(GC gc) {
        int textBottomY;
        if (this.currentColor == null || this.currentColor.isDisposed()) {
            return;
        }
        gc.setFont(this.previewComposite.getDisplay().getSystemFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        int lineHeight = fontMetrics.getHeight();
        Rectangle clientArea = this.colorSampler.getClientArea();
        int maxHeight = lineHeight * 4;
        if (clientArea.height > maxHeight) {
            clientArea = new Rectangle(clientArea.x, clientArea.y, clientArea.width, maxHeight);
        }
        String messageTop = RESOURCE_BUNDLE.getString("fontColorSample");
        String fontColorString = RESOURCE_BUNDLE.getString("fontColorString");
        RGB rgb = this.currentColor.getRGB();
        String messageBottom = MessageFormat.format(fontColorString, rgb.red, rgb.green, rgb.blue);
        int separator = (clientArea.width - 2) / 3;
        int verticalCenter = clientArea.height / 2;
        int textTopY = (verticalCenter - lineHeight) / 2;
        if (textTopY < 1) {
            textTopY = 1;
        }
        if ((textBottomY = verticalCenter + (textTopY += clientArea.y)) > clientArea.height - 2) {
            textBottomY = clientArea.height - 2;
        }
        textBottomY += clientArea.y;
        int stringWidthTop = gc.stringExtent((String)messageTop).x;
        int textTopX = (separator - stringWidthTop - 1) / 2;
        if (textTopX < 1) {
            textTopX = 1;
        }
        textTopX += clientArea.x;
        int stringWidthBottom = gc.stringExtent((String)messageBottom).x;
        int textBottomX = (separator - stringWidthBottom - 1) / 2;
        if (textBottomX < 1) {
            textBottomX = 1;
        }
        gc.setForeground(this.currentColor);
        gc.drawText(messageTop, textTopX, textTopY);
        gc.drawText(messageBottom, textBottomX += clientArea.x, textBottomY);
        gc.setBackground(this.previewComposite.getDisplay().getSystemColor(25));
        int rightWidth = clientArea.width - 2 - separator * 2;
        gc.fillRectangle(separator * 2, 1, rightWidth, clientArea.height - 2);
        gc.setForeground(this.currentColor);
        gc.drawText(messageTop, separator * 2 + textTopX, textTopY);
        gc.drawText(messageBottom, separator * 2 + textBottomX, textBottomY);
        gc.setBackground(this.currentColor);
        gc.fillRectangle(separator, 1, separator, clientArea.height - 2);
        gc.setForeground(this.previewComposite.getDisplay().getSystemColor(2));
        gc.drawText(messageTop, separator + textTopX, textTopY);
        gc.setForeground(this.previewComposite.getDisplay().getSystemColor(1));
        gc.drawText(messageBottom, separator + textBottomX, textBottomY);
        gc.setForeground(this.previewComposite.getDisplay().getSystemColor(18));
        gc.drawLine(separator, verticalCenter, separator * 2 - 1, verticalCenter);
        gc.setForeground(this.previewComposite.getDisplay().getSystemColor(18));
        gc.drawRectangle(0, 0, clientArea.width - 1, clientArea.height - 1);
    }

    private void createDescriptionControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 16384);
        label.setText(RESOURCE_BUNDLE.getString("description"));
        this.myApplyDialogFont((Control)label);
        this.descriptionText = new Text(composite, 2120);
        data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(3);
        data.widthHint = this.convertWidthInCharsToPixels(30);
        this.descriptionText.setLayoutData((Object)data);
        this.myApplyDialogFont((Control)this.descriptionText);
    }

    private void publishThemeRegistryModifiedEvent() {
        if (this.eventBroker != null) {
            this.eventBroker.send("org/eclipse/ui/internal/themes/WorkbenchThemeManager/themeRegistryModified", null);
        }
    }

    private void refreshAllLabels() {
        this.tree.getViewer().refresh();
    }

    private boolean isAvailableInCurrentTheme(ThemeElementDefinition definition) {
        if (definition instanceof ColorDefinition) {
            ColorDefinition colorDef = (ColorDefinition)definition;
            RGB value = colorDef.getValue();
            if ((value == null || value == WorkbenchThemeManager.EMPTY_COLOR_VALUE) && colorDef.getDefaultsTo() == null) {
                return false;
            }
            return this.colorRegistry.get(definition.getId()) != null;
        }
        return true;
    }

    private String fomatDescription(ThemeElementDefinition definition) {
        String description;
        String string = description = definition.getDescription() != null ? definition.getDescription() : EMPTY;
        if (this.isAvailableInCurrentTheme(definition)) {
            return description;
        }
        return MessageFormat.format(RESOURCE_BUNDLE.getString("definitionNotAvailInTheme"), description).trim();
    }

    private void updateDefinitionState(ThemeElementDefinition definition, boolean reset) {
        if (reset) {
            definition.removeState(4);
        } else {
            definition.appendState(4);
        }
    }

    private void refreshElement(ThemeElementDefinition definition) {
        this.tree.getViewer().refresh((Object)definition);
        this.updateTreeSelection(this.tree.getViewer().getSelection());
        FontData[] newValue = definition instanceof ColorDefinition ? ((ColorDefinition)definition).getValue() : ((FontDefinition)definition).getValue();
        this.getCascadingTheme().fire(new PropertyChangeEvent((Object)this, definition.getId(), null, (Object)newValue));
    }

    private static class CascadingThemeExt
    extends CascadingTheme {
        public CascadingThemeExt(org.eclipse.ui.themes.ITheme currentTheme, CascadingColorRegistry colorRegistry, CascadingFontRegistry fontRegistry) {
            super(currentTheme, colorRegistry, fontRegistry);
        }

        @Override
        public void fire(PropertyChangeEvent event) {
            super.fire(event);
        }
    }

    private class PresentationLabelProvider
    extends LabelProvider
    implements IFontProvider,
    IColorProvider {
        private HashMap<Font, Font> fonts = new HashMap();
        private HashMap<Color, Image> images = new HashMap();
        private int imageSize = -1;
        private int usableImageSize = -1;
        private IPropertyChangeListener listener = event -> {
            if (event.getNewValue() != null) {
                this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
            } else {
                ColorsAndFontsPreferencePage.this.refreshAllLabels();
            }
        };
        private Image emptyImage;

        public PresentationLabelProvider() {
            this.hookListeners();
        }

        public void hookListeners() {
            ColorsAndFontsPreferencePage.this.colorRegistry.addListener(this.listener);
            ColorsAndFontsPreferencePage.this.fontRegistry.addListener(this.listener);
        }

        public void dispose() {
            super.dispose();
            ColorsAndFontsPreferencePage.this.colorRegistry.removeListener(this.listener);
            ColorsAndFontsPreferencePage.this.fontRegistry.removeListener(this.listener);
            for (Image image : this.images.values()) {
                image.dispose();
            }
            this.images.clear();
            if (this.emptyImage != null) {
                this.emptyImage.dispose();
                this.emptyImage = null;
            }
            this.clearFontCache();
        }

        public void clearFontCache() {
            for (Font font : this.fonts.values()) {
                font.dispose();
            }
            this.fonts.clear();
        }

        public void clearFontCacheAndUpdate() {
            this.clearFontCache();
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }

        public Font getFont(Object element) {
            Display display = ColorsAndFontsPreferencePage.this.tree.getDisplay();
            if (element instanceof FontDefinition) {
                int parentHeight = ColorsAndFontsPreferencePage.this.tree.getViewer().getControl().getFont().getFontData()[0].getHeight();
                Font baseFont = ColorsAndFontsPreferencePage.this.fontRegistry.get(((FontDefinition)element).getId());
                Font font = this.fonts.get(baseFont);
                if (font == null) {
                    FontData[] data;
                    FontData[] fontDataArray = data = baseFont.getFontData();
                    int n = data.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FontData fontData = fontDataArray[n2];
                        fontData.setHeight(parentHeight);
                        ++n2;
                    }
                    font = new Font((Device)display, data);
                    this.fonts.put(baseFont, font);
                }
                return font;
            }
            return JFaceResources.getDialogFont();
        }

        public Image getImage(Object element) {
            if (element instanceof ColorDefinition) {
                Image image;
                Display display = ColorsAndFontsPreferencePage.this.tree.getDisplay();
                Color c = ColorsAndFontsPreferencePage.this.colorRegistry.get(((ColorDefinition)element).getId());
                Color foregroundColor = display.getSystemColor(2);
                if (!ColorsAndFontsPreferencePage.this.isAvailableInCurrentTheme((ColorDefinition)element)) {
                    c = display.getSystemColor(1);
                    foregroundColor = display.getSystemColor(19);
                }
                if ((image = this.images.get(c)) == null) {
                    this.ensureImageSize();
                    image = new Image((Device)display, this.imageSize, this.imageSize);
                    GC gc = new GC((Drawable)image);
                    gc.setBackground(ColorsAndFontsPreferencePage.this.tree.getViewer().getControl().getBackground());
                    gc.setForeground(ColorsAndFontsPreferencePage.this.tree.getViewer().getControl().getBackground());
                    gc.drawRectangle(0, 0, this.imageSize - 1, this.imageSize - 1);
                    gc.setForeground(foregroundColor);
                    gc.setBackground(c);
                    int offset = (this.imageSize - this.usableImageSize) / 2;
                    gc.drawRectangle(offset, offset, this.usableImageSize - offset, this.usableImageSize - offset);
                    gc.fillRectangle(offset + 1, offset + 1, this.usableImageSize - offset - 1, this.usableImageSize - offset - 1);
                    gc.dispose();
                    this.images.put(c, image);
                }
                return image;
            }
            if (element instanceof FontDefinition) {
                return ColorsAndFontsPreferencePage.this.workbench.getSharedImages().getImage("IMG_OBJ_FONT");
            }
            return ColorsAndFontsPreferencePage.this.workbench.getSharedImages().getImage("IMG_OBJ_THEME_CATEGORY");
        }

        private void ensureImageSize() {
            if (this.imageSize == -1) {
                this.imageSize = ColorsAndFontsPreferencePage.this.tree.getViewer().getTree().getItemHeight();
                this.usableImageSize = Math.max(1, this.imageSize - 4);
            }
        }

        public String getText(Object element) {
            IHierarchalThemeElementDefinition themeElement;
            if (element instanceof IHierarchalThemeElementDefinition && (themeElement = (IHierarchalThemeElementDefinition)element).getDefaultsTo() != null) {
                String myCategory = ((ICategorizedThemeElementDefinition)((Object)themeElement)).getCategoryId();
                ThemeElementDefinition def = element instanceof ColorDefinition ? ColorsAndFontsPreferencePage.this.themeRegistry.findColor(themeElement.getDefaultsTo()) : ColorsAndFontsPreferencePage.this.themeRegistry.findFont(themeElement.getDefaultsTo());
                if (def != null && !ColorsAndFontsPreferencePage.equals(def.getCategoryId(), myCategory)) {
                    if (this.isDefault(themeElement)) {
                        return MessageFormat.format(RESOURCE_BUNDLE.getString("defaultFormat_default"), themeElement.getName(), def.getName());
                    }
                    return MessageFormat.format(RESOURCE_BUNDLE.getString("defaultFormat_override"), themeElement.getName(), def.getName());
                }
            }
            return ((IThemeElementDefinition)element).getName();
        }

        private boolean isDefault(IThemeElementDefinition def) {
            if (def instanceof FontDefinition) {
                FontDefinition fontDef = (FontDefinition)def;
                String defaultFontID = fontDef.getDefaultsTo();
                return defaultFontID != null && Arrays.equals(ColorsAndFontsPreferencePage.this.fontRegistry.getFontData(def.getId()), ColorsAndFontsPreferencePage.this.fontRegistry.getFontData(defaultFontID));
            }
            if (def instanceof ColorDefinition) {
                ColorDefinition colorDef = (ColorDefinition)def;
                String defaultColorID = colorDef.getDefaultsTo();
                if (defaultColorID == null) {
                    return false;
                }
                RGB defaultRGB = ColorsAndFontsPreferencePage.this.colorRegistry.getRGB(defaultColorID);
                return defaultRGB != null && defaultRGB.equals((Object)ColorsAndFontsPreferencePage.this.colorRegistry.getRGB(colorDef.getId()));
            }
            return false;
        }

        public Color getForeground(Object element) {
            if (element instanceof ThemeElementDefinition && !ColorsAndFontsPreferencePage.this.isAvailableInCurrentTheme((ThemeElementDefinition)element)) {
                return ColorsAndFontsPreferencePage.this.tree.getDisplay().getSystemColor(19);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private class ThemeContentProvider
    implements ITreeContentProvider {
        private IThemeRegistry registry;

        private ThemeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ThemeElementCategory) {
                String categoryId = ((ThemeElementCategory)parentElement).getId();
                Object[] defintions = ColorsAndFontsPreferencePage.this.categoryMap.get(categoryId);
                if (defintions == null) {
                    defintions = this.getCategoryChildren(categoryId);
                    ColorsAndFontsPreferencePage.this.categoryMap.put(categoryId, defintions);
                }
                return defintions;
            }
            ArrayList<ThemeElementDefinition> list = new ArrayList<ThemeElementDefinition>();
            IHierarchalThemeElementDefinition def = (IHierarchalThemeElementDefinition)parentElement;
            String id = def.getId();
            ThemeElementDefinition[] defs = def instanceof ColorDefinition ? this.registry.getColors() : this.registry.getFonts();
            ThemeElementDefinition[] themeElementDefinitionArray = defs;
            int n = defs.length;
            int n2 = 0;
            while (n2 < n) {
                ThemeElementDefinition elementDefinition = themeElementDefinitionArray[n2];
                if (id.equals(elementDefinition.getDefaultsTo()) && ColorsAndFontsPreferencePage.equals(((ICategorizedThemeElementDefinition)((Object)def)).getCategoryId(), ((ICategorizedThemeElementDefinition)((Object)elementDefinition)).getCategoryId())) {
                    list.add(elementDefinition);
                }
                ++n2;
            }
            return list.toArray();
        }

        private Object[] getCategoryChildren(String categoryId) {
            FontDefinition[] fontDefinitions;
            ColorDefinition[] colorDefinitions;
            int n;
            ArrayList<Object> list = new ArrayList<Object>();
            if (categoryId != null) {
                ThemeElementCategory[] themeElementCategoryArray = this.registry.getCategories();
                n = themeElementCategoryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Set<?> bindings;
                    ThemeElementCategory category = themeElementCategoryArray[n2];
                    if (categoryId.equals(category.getParentId()) && (bindings = ColorsAndFontsPreferencePage.this.themeRegistry.getPresentationsBindingsFor(category)) == null) {
                        list.add(category);
                    }
                    ++n2;
                }
            }
            ColorDefinition[] colorDefinitionArray = colorDefinitions = ColorsAndFontsPreferencePage.this.themeRegistry.getColorsFor(ColorsAndFontsPreferencePage.this.currentTheme.getId());
            int n3 = colorDefinitions.length;
            n = 0;
            while (n < n3) {
                String catId;
                ColorDefinition colorDefinition = colorDefinitionArray[n];
                if (colorDefinition.isEditable() && ((catId = colorDefinition.getCategoryId()) == null && categoryId == null || catId != null && categoryId != null && categoryId.equals(catId)) && (colorDefinition.getDefaultsTo() == null || !this.parentIsInSameCategory(colorDefinition))) {
                    list.add(colorDefinition);
                }
                ++n;
            }
            FontDefinition[] fontDefinitionArray = fontDefinitions = ColorsAndFontsPreferencePage.this.themeRegistry.getFontsFor(ColorsAndFontsPreferencePage.this.currentTheme.getId());
            int n4 = fontDefinitions.length;
            n3 = 0;
            while (n3 < n4) {
                String catId;
                FontDefinition fontDefinition = fontDefinitionArray[n3];
                if (fontDefinition.isEditable() && ((catId = fontDefinition.getCategoryId()) == null && categoryId == null || catId != null && categoryId != null && categoryId.equals(catId)) && (fontDefinition.getDefaultsTo() == null || !this.parentIsInSameCategory(fontDefinition))) {
                    list.add(fontDefinition);
                }
                ++n3;
            }
            return list.toArray(new Object[list.size()]);
        }

        private boolean parentIsInSameCategory(ColorDefinition definition) {
            String defaultsTo = definition.getDefaultsTo();
            ColorDefinition[] colorDefinitionArray = this.registry.getColors();
            int n = colorDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColorDefinition colorDef = colorDefinitionArray[n2];
                if (colorDef.getId().equals(defaultsTo) && ColorsAndFontsPreferencePage.equals(colorDef.getCategoryId(), definition.getCategoryId())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private boolean parentIsInSameCategory(FontDefinition definition) {
            String defaultsTo = definition.getDefaultsTo();
            FontDefinition[] fontDefinitionArray = this.registry.getFonts();
            int n = fontDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                FontDefinition fontDef = fontDefinitionArray[n2];
                if (fontDef.getId().equals(defaultsTo) && ColorsAndFontsPreferencePage.equals(fontDef.getCategoryId(), definition.getCategoryId())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof ThemeElementCategory) {
                return this.registry;
            }
            if (element instanceof ColorDefinition) {
                ColorDefinition defaultElement;
                String defaultId = ((IHierarchalThemeElementDefinition)element).getDefaultsTo();
                if (defaultId != null && this.parentIsInSameCategory(defaultElement = this.registry.findColor(defaultId))) {
                    return defaultElement;
                }
                String categoryId = ((ColorDefinition)element).getCategoryId();
                return this.registry.findCategory(categoryId);
            }
            if (element instanceof FontDefinition) {
                FontDefinition defaultElement;
                String defaultId = ((FontDefinition)element).getDefaultsTo();
                if (defaultId != null && this.parentIsInSameCategory(defaultElement = this.registry.findFont(defaultId))) {
                    return defaultElement;
                }
                String categoryId = ((FontDefinition)element).getCategoryId();
                return this.registry.findCategory(categoryId);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ThemeElementCategory) {
                return true;
            }
            IHierarchalThemeElementDefinition def = (IHierarchalThemeElementDefinition)element;
            String id = def.getId();
            ThemeElementDefinition[] defs = def instanceof ColorDefinition ? this.registry.getColors() : this.registry.getFonts();
            ThemeElementDefinition[] themeElementDefinitionArray = defs;
            int n = defs.length;
            int n2 = 0;
            while (n2 < n) {
                ThemeElementDefinition elementDefinition = themeElementDefinitionArray[n2];
                if (id.equals(elementDefinition.getDefaultsTo()) && ColorsAndFontsPreferencePage.equals(((ICategorizedThemeElementDefinition)((Object)def)).getCategoryId(), ((ICategorizedThemeElementDefinition)((Object)elementDefinition)).getCategoryId())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Object> list = new ArrayList<Object>();
            Object[] uncatChildren = this.getCategoryChildren(null);
            list.addAll(Arrays.asList(uncatChildren));
            ThemeElementCategory[] themeElementCategoryArray = ((IThemeRegistry)inputElement).getCategories();
            int n = themeElementCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] children;
                Set<?> bindings;
                ThemeElementCategory category = themeElementCategoryArray[n2];
                if (category.getParentId() == null && (bindings = ColorsAndFontsPreferencePage.this.themeRegistry.getPresentationsBindingsFor(category)) == null && (children = this.getChildren(category)) != null && children.length > 0) {
                    list.add(category);
                }
                ++n2;
            }
            return list.toArray(new Object[list.size()]);
        }

        public void dispose() {
            ColorsAndFontsPreferencePage.this.categoryMap.clear();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            ColorsAndFontsPreferencePage.this.categoryMap.clear();
            this.registry = (IThemeRegistry)newInput;
        }
    }
}

