/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.team.ui.mapping.ITeamStateDescription;

public class TeamStateDescription
implements ITeamStateDescription {
    private int state;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public TeamStateDescription(int state) {
        this.state = state;
    }

    @Override
    public int getStateFlags() {
        return this.state;
    }

    @Override
    public int getKind() {
        return this.getStateFlags() & 0xFF;
    }

    @Override
    public int getDirection() {
        return this.getStateFlags() & 0x300;
    }

    @Override
    public String[] getPropertyNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public Object getProperty(String property) {
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        this.properties.put(property, value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TeamStateDescription) {
            TeamStateDescription dsd = (TeamStateDescription)obj;
            if (dsd.getStateFlags() == this.state && this.haveSameProperties(this, dsd)) {
                String[] properties;
                String[] stringArray = properties = this.getPropertyNames();
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o2;
                    String property = stringArray[n2];
                    Object o1 = this.getProperty(property);
                    if (!o1.equals(o2 = dsd.getProperty(property))) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }
        return super.equals(obj);
    }

    private boolean haveSameProperties(TeamStateDescription d1, TeamStateDescription d2) {
        String[] p2;
        String[] p1 = d1.getPropertyNames();
        if (p1.length != (p2 = d2.getPropertyNames()).length) {
            return false;
        }
        String[] stringArray = p1;
        int n = p1.length;
        int n2 = 0;
        while (n2 < n) {
            String s1 = stringArray[n2];
            boolean found = false;
            String[] stringArray2 = p2;
            int n3 = p2.length;
            int n4 = 0;
            while (n4 < n3) {
                String s2 = stringArray2[n4];
                if (s1.equals(s2)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

