/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.test.fragmentation.ju.utils.initegrity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DView;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.commandline.core.AbstractCommandLine;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;
import org.polarsys.capella.test.fragmentation.ju.utils.initegrity.IChecker;

public class IntegrityChecker
implements IChecker {
    @Override
    public IStatus getStatus(Session session_p, Logger logger_p, IProgressMonitor monitor_p) {
        monitor_p.beginTask("Fragmentation integrity checking..", 5);
        SubProgressMonitor submonitor = new SubProgressMonitor(monitor_p, 2);
        HashMapSet objects = new HashMapSet();
        for (Resource resource : session_p.getSemanticResources()) {
            TreeIterator resourceContent = resource.getAllContents();
            while (resourceContent.hasNext()) {
                EObject object = (EObject)resourceContent.next();
                String id = EcoreUtil.getID((EObject)object);
                objects.put((Object)id, (Object)object);
            }
        }
        submonitor.worked(1);
        HashMapSet idPerResources = new HashMapSet();
        HashSet<String> idResourceMany = new HashSet<String>();
        for (String key : objects.keySet()) {
            if (!objects.containsValue((Object)key)) continue;
            HashSet resources = new HashSet();
            for (EObject item : objects.get((Object)key)) {
                resources.add(item.eResource());
            }
            boolean isMany = false;
            StringBuffer buffer = new StringBuffer();
            Iterator itResources = resources.iterator();
            while (itResources.hasNext()) {
                Resource matchingResource = (Resource)itResources.next();
                String id = matchingResource.getURI().lastSegment();
                buffer.append(id);
                if (!itResources.hasNext()) continue;
                buffer.append(", ");
                isMany = true;
            }
            String id = buffer.toString();
            idPerResources.put((Object)id, (Object)key);
            if (!isMany) continue;
            idResourceMany.add(id);
        }
        submonitor.worked(1);
        ArrayList<Status> statuses = new ArrayList<Status>();
        for (String resourcesIdentifier : idPerResources.keySet()) {
            StringBuffer buffer = new StringBuffer();
            if (!idResourceMany.contains(resourcesIdentifier)) {
                buffer.append(NLS.bind((String)"Some elements are duplicated in one fragment : ''{0}'':\r\n", (Object)resourcesIdentifier));
            } else {
                buffer.append(NLS.bind((String)"Some elements are defined in more than one fragment : ''{0}'':\r\n", (Object)resourcesIdentifier));
            }
            for (String idDuplicate : idPerResources.get((Object)resourcesIdentifier)) {
                buffer.append(NLS.bind((String)"\t{0}\tid=\"{1}\r\n", (Object)EObjectLabelProviderHelper.getText(objects.get((Object)idDuplicate).iterator().next()), (Object)idDuplicate));
            }
            statuses.add(new Status(AbstractCommandLine.FATAL, "org.polarsys.capella.test.fragmentation.ju", buffer.toString()));
        }
        submonitor.worked(1);
        HashMapSet objectsUses = new HashMapSet();
        HashSet<DRepresentation> diagrams = new HashSet<DRepresentation>();
        Collection views = session_p.getOwnedViews();
        Collection semanticResources = session_p.getSemanticResources();
        submonitor.beginTask("Retrieve diagrams with duplicated semantic elements", semanticResources.size());
        submonitor.setTaskName("Retrieve diagrams with duplicated semantic elements");
        for (DView airdView : views) {
            for (DRepresentation representation : new DViewQuery(airdView).getLoadedRepresentations()) {
                for (DRepresentationElement element : representation.getRepresentationElements()) {
                    String uriFragment;
                    if (element.getTarget() == null || element.getTarget().eIsProxy() || !objects.containsValue((Object)(uriFragment = EcoreUtil.getID((EObject)element.getTarget())))) continue;
                    objectsUses.put((Object)representation, (Object)element.getTarget());
                    diagrams.add(representation);
                }
            }
        }
        monitor_p.worked(1);
        for (DRepresentation diagram : diagrams) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(NLS.bind((String)"Diagram ''{0}'' into ''{1}'' uses some duplicated elements\n", (Object)EObjectExt.getText((EObject)diagram), (Object)diagram.eResource().getURI().lastSegment()));
            HashSet<Resource> resources = new HashSet<Resource>();
            for (EObject objectUsed : objectsUses.get((Object)diagram)) {
                resources.add(objectUsed.eResource());
            }
            for (Resource resource : resources) {
                buffer.append(NLS.bind((String)"from\t{0}\r\n", (Object)resource.getURI().lastSegment()));
                for (EObject object : objectsUses.get((Object)diagram)) {
                    if (!object.eResource().equals(resource)) continue;
                    String uriFragment = EcoreUtil.getID((EObject)object);
                    buffer.append("\t\";");
                    buffer.append(NLS.bind((String)"\t{0}\tid=\"{1}\r\n", (Object)EObjectLabelProviderHelper.getText((Object)object), (Object)uriFragment));
                }
            }
            statuses.add(new Status(AbstractCommandLine.FATAL, "org.polarsys.capella.test.fragmentation.ju", buffer.toString()));
        }
        submonitor.worked(1);
        submonitor.done();
        monitor_p.done();
        if (statuses.size() > 0) {
            return new MultiStatus("org.polarsys.capella.test.fragmentation.ju", 4, statuses.toArray(new IStatus[0]), "Fragmentation integrity failed: duplication of some semantic elements", null);
        }
        return new Status(0, "org.polarsys.capella.test.fragmentation.ju", "Fragmentation integrity OK: no semantic duplication");
    }
}

