/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.validation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.buildpath.Buildpath;
import org.eclipse.fordiac.ide.model.buildpath.BuildpathAttributes;
import org.eclipse.fordiac.ide.model.buildpath.SourceFolder;
import org.eclipse.fordiac.ide.model.buildpath.util.BuildpathUtil;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;

public final class ValidationUtil {
    public static boolean shouldProcess(Issue issue, boolean ignoreWarnings) {
        return issue.getSeverity() == Severity.ERROR || !ignoreWarnings;
    }

    public static boolean isIgnoreWarnings(IFile file) {
        return Boolean.parseBoolean(ValidationUtil.findSourceFolder(file).map(sourceFolder -> BuildpathAttributes.getAttributeValue((List)sourceFolder.getAttributes(), (String)"ignore_warnings")).orElse(null));
    }

    public static Optional<SourceFolder> findSourceFolder(IFile file) {
        return ValidationUtil.getBuildpath(file).flatMap(buildpath -> BuildpathUtil.findSourceFolder((Buildpath)buildpath, (IResource)file));
    }

    public static Optional<Buildpath> getBuildpath(IFile file) {
        return Optional.ofNullable(file).map(IResource::getProject).map(arg_0 -> ((TypeLibraryManager)TypeLibraryManager.INSTANCE).getTypeLibrary(arg_0)).map(TypeLibrary::getBuildpath);
    }

    public static Issue createModelIssue(Severity severity, String message, EObject target, EStructuralFeature feature) {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setMessage(message);
        issue.setSeverity(severity);
        issue.setCode("org.eclipse.fordiac.ide.model.libraryElement");
        issue.setType(CheckType.FAST);
        if (target != null) {
            issue.setUriToProblem(EcoreUtil.getURI((EObject)target));
            issue.setData(new String[]{FordiacMarkerHelper.getLocation((EObject)target), EcoreUtil.getURI((EObject)target).toString(), EcoreUtil.getURI((EObject)target.eClass()).toString(), feature != null ? EcoreUtil.getURI((EObject)feature).toString() : null});
        }
        return issue;
    }

    public static Issue convertToModelIssue(Issue issue, EObject target) {
        return ValidationUtil.convertToModelIssue(issue, target, null);
    }

    public static Issue convertToModelIssue(Issue issue, EObject target, EStructuralFeature feature) {
        return ValidationUtil.createModelIssue(issue.getSeverity(), issue.getMessage(), target, feature);
    }

    public static int getModelMarkerCode(Issue issue) {
        String issueCode = issue.getCode();
        int index = issueCode.lastIndexOf(46);
        if (index >= 0) {
            try {
                return Integer.parseInt(issueCode.substring(index + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static String getModelMarkerSource(Issue issue) {
        String issueCode = issue.getCode();
        int index = issueCode.lastIndexOf(46);
        if (index >= 0) {
            return issueCode.substring(0, index);
        }
        return issueCode;
    }

    public static Map<String, Object> getModelMarkerAttributes(Issue issue) {
        URI canonicalURI = LibraryElementXtextResource.toExternalURI((URI)issue.getUriToProblem());
        if (canonicalURI != null) {
            String[] data;
            if (ValidationUtil.isModelValidationIssue(issue) && (data = issue.getData()) != null) {
                if (data.length >= 4 && data[3] != null) {
                    return Map.of("location", data[0], "org.eclipse.fordiac.ide.model.iec61499.targetUri", canonicalURI.toString(), "org.eclipse.fordiac.ide.model.iec61499.targetType", data[2], "org.eclipse.fordiac.ide.model.iec61499.targetFeature", data[3], "org.eclipse.fordiac.ide.model.iec61499.data", Stream.of(data).skip(4L).collect(Collectors.joining("\u0000")));
                }
                if (data.length >= 3) {
                    return Map.of("location", data[0], "org.eclipse.fordiac.ide.model.iec61499.targetUri", canonicalURI.toString(), "org.eclipse.fordiac.ide.model.iec61499.targetType", data[2], "org.eclipse.fordiac.ide.model.iec61499.data", Stream.of(data).skip(3L).collect(Collectors.joining("\u0000")));
                }
            }
            return Map.of("org.eclipse.fordiac.ide.model.iec61499.targetUri", canonicalURI.toString());
        }
        return Collections.emptyMap();
    }

    public static int getMarkerSeverity(Issue issue) {
        return switch (issue.getSeverity()) {
            case Severity.ERROR -> 2;
            case Severity.WARNING -> 1;
            case Severity.INFO -> 0;
            default -> throw new IllegalArgumentException(String.valueOf(issue.getSeverity()));
        };
    }

    public static boolean isModelValidationIssue(Issue issue) {
        return issue.getCode() != null && issue.getCode().startsWith("org.eclipse.fordiac.ide.model.libraryElement");
    }

    public static boolean isContainedInTypedInstance(IInterfaceElement element) {
        BlockFBNetworkElement fbNetworkElement = element.getBlockFBNetworkElement();
        return fbNetworkElement != null && fbNetworkElement.getTypeEntry() != null;
    }

    private ValidationUtil() {
        throw new UnsupportedOperationException();
    }
}

