/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.types;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.STFunctionBody;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.GlobalConstantsMatcher;
import org.eclipse.fordiac.ide.model.search.ISearchFactory;
import org.eclipse.fordiac.ide.model.search.ISearchSupport;
import org.eclipse.fordiac.ide.model.search.LocalLiveSearchContext;
import org.eclipse.fordiac.ide.model.search.types.IEC61499ElementSearch;
import org.eclipse.fordiac.ide.model.search.types.IEC61499SearchFilter;
import org.eclipse.fordiac.ide.model.search.types.ISearchChildrenProvider;
import org.eclipse.fordiac.ide.model.search.types.SearchChildrenProviderHelper;
import org.eclipse.fordiac.ide.model.typelibrary.GlobalConstantsEntry;

public class GlobalConstantsTypeInstanceSearch
extends IEC61499ElementSearch {
    public GlobalConstantsTypeInstanceSearch(GlobalConstantsEntry gcEntry) {
        super(new LocalLiveSearchContext(gcEntry.getTypeLibrary()), GlobalConstantsTypeInstanceSearch.createSearchFilter(new GlobalConstantsMatcher(gcEntry)), new GlobalConstantsTypeInstanceSearchChildrenProvider());
    }

    public static IEC61499SearchFilter createSearchFilter(GlobalConstantsMatcher matcher) {
        return searchCandidate -> {
            boolean bl;
            if (searchCandidate == null) return false;
            EObject eObject = searchCandidate;
            Objects.requireNonNull(eObject);
            EObject eObject2 = eObject;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarDeclaration.class, Attribute.class, Algorithm.class, Method.class, STFunctionBody.class}, (Object)eObject2, 0)) {
                case 0: {
                    VarDeclaration varDecl = (VarDeclaration)eObject2;
                    bl = GlobalConstantsTypeInstanceSearch.isGlobalConstantValue(varDecl, matcher);
                    break;
                }
                case 1: {
                    Attribute attr = (Attribute)eObject2;
                    bl = GlobalConstantsTypeInstanceSearch.isGlobalConstantValue(attr, matcher);
                    break;
                }
                case 2: {
                    Algorithm alg = (Algorithm)eObject2;
                    bl = GlobalConstantsTypeInstanceSearch.isGlobalConstantValue((EObject)alg, matcher);
                    break;
                }
                case 3: {
                    Method meth = (Method)eObject2;
                    bl = GlobalConstantsTypeInstanceSearch.isGlobalConstantValue((EObject)meth, matcher);
                    break;
                }
                case 4: {
                    STFunctionBody func = (STFunctionBody)eObject2;
                    bl = GlobalConstantsTypeInstanceSearch.isGlobalConstantValue((EObject)func, matcher);
                    break;
                }
                default: {
                    return false;
                }
            }
            if (!bl) return false;
            return true;
        };
    }

    public static boolean isGlobalConstantValue(VarDeclaration varDecl, GlobalConstantsMatcher matcher) {
        if (varDecl.getValue() == null) {
            return false;
        }
        String value = varDecl.getValue().getValue();
        if (value == null || value.isBlank() || value.chars().noneMatch(Character::isLetter) || VariableOperations.isSimpleInitialValue((VarDeclaration)varDecl)) {
            return false;
        }
        return GlobalConstantsTypeInstanceSearch.isGlobalConstantValue((EObject)varDecl, matcher);
    }

    private static boolean isGlobalConstantValue(Attribute attr, GlobalConstantsMatcher matcher) {
        String value = attr.getValue();
        if (value == null || value.isBlank() || value.chars().noneMatch(Character::isLetter) || VariableOperations.isSimpleAttributeValue((Attribute)attr)) {
            return false;
        }
        return GlobalConstantsTypeInstanceSearch.isGlobalConstantValue((EObject)attr, matcher);
    }

    private static boolean isGlobalConstantValue(EObject context, GlobalConstantsMatcher matcher) {
        ISearchSupport searchSupport = ISearchFactory.createSearchSupport(context, context.eClass().getInstanceClass());
        return searchSupport != null && searchSupport.search(matcher).count() > 0L;
    }

    private static final class GlobalConstantsTypeInstanceSearchChildrenProvider
    implements ISearchChildrenProvider {
        private GlobalConstantsTypeInstanceSearchChildrenProvider() {
        }

        @Override
        public boolean hasChildren(EObject obj) {
            return obj instanceof FBType || obj instanceof AutomationSystem || obj instanceof UntypedSubApp || obj instanceof StructuredType || obj instanceof AttributeDeclaration || obj instanceof Application || obj instanceof FBNetworkElement || obj instanceof IInterfaceElement;
        }

        @Override
        public Stream<? extends EObject> getChildren(EObject obj) {
            if (obj instanceof FBType) {
                FBType fbType = (FBType)obj;
                Stream<? extends EObject> stream = SearchChildrenProviderHelper.getFBTypeChildren(fbType);
                if (obj instanceof BaseFBType) {
                    BaseFBType base = (BaseFBType)obj;
                    stream = Stream.concat(stream, base.getAlgorithm().stream());
                    stream = Stream.concat(stream, base.getMethods().stream());
                } else if (obj instanceof FunctionFBType) {
                    FunctionFBType func = (FunctionFBType)obj;
                    stream = Stream.concat(stream, Stream.of(func.getBody()));
                }
                return stream;
            }
            if (obj instanceof AutomationSystem) {
                AutomationSystem system = (AutomationSystem)obj;
                return Stream.concat(system.getAttributes().stream(), system.getApplication().stream());
            }
            if (obj instanceof Application) {
                Application application = (Application)obj;
                return Stream.concat(application.getFBNetwork().getNetworkElements().stream(), application.getAttributes().stream());
            }
            if (obj instanceof UntypedSubApp) {
                UntypedSubApp untypedSubapp = (UntypedSubApp)obj;
                return SearchChildrenProviderHelper.getUntypedSubappChildren(untypedSubapp);
            }
            if (obj instanceof StructuredType) {
                StructuredType structType = (StructuredType)obj;
                return SearchChildrenProviderHelper.getStructChildren(structType);
            }
            if (obj instanceof AttributeDeclaration) {
                AttributeDeclaration attrdecl = (AttributeDeclaration)obj;
                return SearchChildrenProviderHelper.getAttributeDeclChildren(attrdecl);
            }
            if (obj instanceof BlockFBNetworkElement) {
                BlockFBNetworkElement elem = (BlockFBNetworkElement)obj;
                return Stream.concat(elem.getAttributes().stream(), SearchChildrenProviderHelper.getInterfaceListChildren(elem.getInterface()));
            }
            if (obj instanceof IInterfaceElement) {
                IInterfaceElement interfaceElement = (IInterfaceElement)obj;
                return interfaceElement.getAttributes().stream();
            }
            if (obj instanceof ConfigurableObject) {
                ConfigurableObject object = (ConfigurableObject)obj;
                return object.getAttributes().stream();
            }
            return Stream.empty();
        }
    }
}

