/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.LrealType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyRealValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class LRealValue
implements AnyRealValue {
    public static final LRealValue DEFAULT = new LRealValue(0.0);
    private final double value;

    private LRealValue(double value) {
        this.value = value;
    }

    public static LRealValue toLRealValue(double value) {
        return new LRealValue(value);
    }

    public static LRealValue toLRealValue(Number value) {
        return new LRealValue(value.doubleValue());
    }

    public static LRealValue toLRealValue(String value) {
        return LRealValue.toLRealValue((Number)NumericValueConverter.INSTANCE.toValue(value));
    }

    public static LRealValue toLRealValue(AnyMagnitudeValue value) {
        return LRealValue.toLRealValue(value.doubleValue());
    }

    public LrealType getType() {
        return IecTypes.ElementaryTypes.LREAL;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.bigDecimalValue().toBigInteger();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.value);
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LRealValue other = (LRealValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Double.toString(this.value);
    }
}

