/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeInterfaceElementCommand;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class ChangeArraySizeCommand
extends AbstractChangeInterfaceElementCommand {
    private final String newArraySize;
    private String oldArraySize;
    private final CompoundCommand additionalCommands = new CompoundCommand();

    protected ChangeArraySizeCommand(VarDeclaration variable, String newArraySize) {
        super((IInterfaceElement)variable);
        this.newArraySize = newArraySize;
    }

    public static ChangeArraySizeCommand forArraySize(VarDeclaration variable, String newArraySize) {
        SubApp subApp;
        BlockFBNetworkElement blockFBNetworkElement;
        ChangeArraySizeCommand result = new ChangeArraySizeCommand(variable, newArraySize);
        if (variable != null && (blockFBNetworkElement = variable.getBlockFBNetworkElement()) instanceof SubApp && (subApp = (SubApp)blockFBNetworkElement).isMapped()) {
            result.getAdditionalCommands().add((Command)new ChangeArraySizeCommand(subApp.getOpposite().getInterface().getVariable(variable.getName()), newArraySize));
        }
        return result;
    }

    public boolean canExecute() {
        return super.canExecute() && !this.isSubAppPinAndConnected();
    }

    @Override
    protected void doExecute() {
        VarDeclaration variable = this.getInterfaceElement();
        this.oldArraySize = ArraySizeHelper.getArraySize((IInterfaceElement)variable);
        ArraySizeHelper.setArraySize((VarDeclaration)variable, (String)this.newArraySize);
        this.additionalCommands.execute();
    }

    @Override
    protected void doUndo() {
        this.additionalCommands.undo();
        ArraySizeHelper.setArraySize((VarDeclaration)this.getInterfaceElement(), (String)this.oldArraySize);
    }

    @Override
    protected void doRedo() {
        ArraySizeHelper.setArraySize((VarDeclaration)this.getInterfaceElement(), (String)this.newArraySize);
        this.additionalCommands.redo();
    }

    public VarDeclaration getInterfaceElement() {
        return (VarDeclaration)super.getInterfaceElement();
    }

    public CompoundCommand getAdditionalCommands() {
        return this.additionalCommands;
    }
}

