/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextalgorithm.validation;

import com.google.inject.Inject;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleECAction;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleECState;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.structuredtextalgorithm.Messages;
import org.eclipse.fordiac.ide.structuredtextalgorithm.resource.STAlgorithmResource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmSource;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithmSourceElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STMethod;
import org.eclipse.fordiac.ide.structuredtextalgorithm.validation.AbstractSTAlgorithmValidator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreControlFlowValidator;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreVariableUsageValidator;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionPackage;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class STAlgorithmValidator
extends AbstractSTAlgorithmValidator {
    @Inject
    private ResourceDescriptionsProvider resourceDescriptionsProvider;
    @Inject
    private IContainer.Manager containerManager;
    public static final String ISSUE_CODE_PREFIX = "org.eclipse.fordiac.ide.structuredtextalgorithm.";
    public static final String DUPLICATE_METHOD_OR_ALGORITHM_NAME = "org.eclipse.fordiac.ide.structuredtextalgorithm.duplicateAlgorithmOrMethodName";
    public static final String MISSING_ALGORITHM = "org.eclipse.fordiac.ide.structuredtextalgorithm.missingAlgorithm";
    public static final String UNUSED_ALGORITHM = "org.eclipse.fordiac.ide.structuredtextalgorithm.unusedAlgorithm";
    public static final String VARIABLE_NAME_IN_USE_ON_INTERFACE = "org.eclipse.fordiac.ide.structuredtextalgorithm.variableNameInUseOnInterface";
    public static final String SHADOWING_FUNCTION = "org.eclipse.fordiac.ide.structuredtextalgorithm.shadowingFunction";

    @Check
    public void checkControlFlow(org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm algorithm) {
        STCoreControlFlowValidator controlFlowValidator = new STCoreControlFlowValidator((ValidationMessageAcceptor)this, this.getIssueSeverities(this.getContext(), (EObject)algorithm));
        controlFlowValidator.validateVariableBlocks((List)algorithm.getBody().getVarTempDeclarations());
        controlFlowValidator.validateStatements((List)algorithm.getBody().getStatements());
    }

    @Check
    public void checkControlFlow(STMethod method) {
        STCoreControlFlowValidator controlFlowValidator = new STCoreControlFlowValidator((ValidationMessageAcceptor)this, this.getIssueSeverities(this.getContext(), (EObject)method));
        controlFlowValidator.validateVariableBlocks((List)method.getBody().getVarDeclarations());
        controlFlowValidator.validateStatements((List)method.getBody().getStatements());
    }

    @Check
    public void checkUnusedVariables(org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm algorithm) {
        STCoreVariableUsageValidator variableUsageValidator = new STCoreVariableUsageValidator((ValidationMessageAcceptor)this, this.getIssueSeverities(this.getContext(), (EObject)algorithm));
        variableUsageValidator.addVariableBlocks((List)algorithm.getBody().getVarTempDeclarations());
        variableUsageValidator.addReferences((EObject)algorithm);
        variableUsageValidator.validateUnused();
    }

    @Check
    public void checkUnusedVariables(STMethod method) {
        STCoreVariableUsageValidator variableUsageValidator = new STCoreVariableUsageValidator((ValidationMessageAcceptor)this, this.getIssueSeverities(this.getContext(), (EObject)method));
        variableUsageValidator.addVariableBlocks((List)method.getBody().getVarDeclarations());
        variableUsageValidator.addReturnVariable((ICallable)method);
        variableUsageValidator.addReferences((EObject)method);
        variableUsageValidator.validateUnused();
    }

    @Check
    public void checkUniquenessOfVariableNamesInAFunctionBlock(STVarDeclaration varDeclaration) {
        STAlgorithmResource resource;
        LibraryElement libraryElement;
        Resource resource2 = varDeclaration.eResource();
        if (resource2 instanceof STAlgorithmResource && (libraryElement = (resource = (STAlgorithmResource)resource2).getInternalLibraryElement()) instanceof BaseFBType) {
            BaseFBType baseFBType = (BaseFBType)libraryElement;
            String name = varDeclaration.getName();
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInterfaceList().getEventInputs(), Messages.STAlgorithmValidator_NameUsedAsEventInput);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInterfaceList().getInputVars(), Messages.STAlgorithmValidator_NameUsedAsDataInput);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInterfaceList().getEventOutputs(), Messages.STAlgorithmValidator_NameUsedAsEventOutput);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInterfaceList().getOutputVars(), Messages.STAlgorithmValidator_NameUsedAsDataOutput);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInternalVars(), Messages.STAlgorithmValidator_NameUsedAsVariable);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInternalConstVars(), Messages.STAlgorithmValidator_NameUsedAsConstant);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getInternalFbs(), Messages.STAlgorithmValidator_NameUsedAsFunctionBlockVariable);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getAlgorithm(), Messages.STAlgorithmValidator_NameUsedAsAlgorithm);
            this.checkUniquenessOfVariableNamesInAFunctionBlock(name, (Collection<? extends INamedElement>)baseFBType.getMethods(), Messages.STAlgorithmValidator_NameUsedAsMethod);
        }
    }

    private void checkUniquenessOfVariableNamesInAFunctionBlock(String name, Collection<? extends INamedElement> list, String message) {
        if (list.stream().anyMatch(it -> it.getName().equalsIgnoreCase(name))) {
            this.error(MessageFormat.format(message, name), (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, VARIABLE_NAME_IN_USE_ON_INTERFACE, new String[]{name});
        }
    }

    @Check
    public void checkUniqunessOfSTAlgorithmSourceElementNames(STAlgorithmSourceElement sourceElement) {
        EObject eObject = sourceElement.eContainer();
        if (eObject instanceof STAlgorithmSource) {
            STAlgorithmSource source = (STAlgorithmSource)eObject;
            String name = sourceElement.getName();
            if (source.getElements().stream().anyMatch(it -> it != sourceElement && it.getName().equalsIgnoreCase(name))) {
                this.error(MessageFormat.format(Messages.STAlgorithmValidator_DuplicateMethodOrAlgorithmName, name), (EObject)sourceElement, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, DUPLICATE_METHOD_OR_ALGORITHM_NAME, new String[]{name});
            }
        }
    }

    @Check
    public void checkUniquenessOfSTAlgorithmSourceElementNamesAndFunctionNames(STFeatureExpression featureExpression) {
        if (!this.getIssueSeverities(this.getContext(), (EObject)featureExpression).isIgnored(SHADOWING_FUNCTION) && featureExpression.getFeature() instanceof STMethod) {
            IResourceDescriptions resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions(featureExpression.getFeature().eResource());
            IResourceDescription resourceDescription = resourceDescriptions.getResourceDescription(featureExpression.getFeature().eResource().getURI());
            for (IContainer container : this.containerManager.getVisibleContainers(resourceDescription, resourceDescriptions)) {
                for (IEObjectDescription description : container.getExportedObjectsByType(STFunctionPackage.Literals.ST_FUNCTION)) {
                    if (!featureExpression.getFeature().getName().equalsIgnoreCase(description.getQualifiedName().toString()) || description.getEObjectURI().equals(EcoreUtil.getURI((EObject)featureExpression))) continue;
                    this.addIssue(MessageFormat.format(Messages.STAlgorithmValidator_UnqualifiedMethodOrAlgorithmShadowingFunction, featureExpression.getFeature().getName(), description.getEObjectURI().toPlatformString(true)), (EObject)featureExpression, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, SHADOWING_FUNCTION, new String[0]);
                }
            }
        }
    }

    @Check
    public void checkMissingAlgorithm(STAlgorithmSource source) {
        STAlgorithmResource resource;
        LibraryElement libraryElement;
        Resource resource2 = source.eResource();
        if (resource2 instanceof STAlgorithmResource && (libraryElement = (resource = (STAlgorithmResource)resource2).getInternalLibraryElement()) instanceof SimpleFBType) {
            SimpleFBType simpleFBType = (SimpleFBType)libraryElement;
            STAlgorithmValidator.getAllReferencedAlgorithms(simpleFBType).filter(alg -> !STAlgorithmValidator.hasSTAlgorithm(source, alg) && !STAlgorithmValidator.hasNonSTAlgorithm(simpleFBType, alg)).forEach(alg -> this.acceptError(MessageFormat.format(Messages.STAlgorithmValidator_MissingAlgorithm, alg), (EObject)source, 0, 0, MISSING_ALGORITHM, new String[]{alg}));
        }
    }

    private static boolean hasSTAlgorithm(STAlgorithmSource source, String algorithm) {
        return source.getElements().stream().filter(org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm.class::isInstance).anyMatch(alg -> alg.getName().equalsIgnoreCase(algorithm));
    }

    private static boolean hasNonSTAlgorithm(SimpleFBType simpleFBType, String algorithm) {
        return simpleFBType.getAlgorithm().stream().filter(Predicate.not(STAlgorithm.class::isInstance)).anyMatch(alg -> alg.getName().equalsIgnoreCase(algorithm));
    }

    @Check
    public void checkUnusedAlgorithm(org.eclipse.fordiac.ide.structuredtextalgorithm.stalgorithm.STAlgorithm algorithm) {
        SimpleFBType simpleFBType;
        STAlgorithmResource resource;
        LibraryElement libraryElement;
        Resource resource2;
        String name = algorithm.getName();
        if (name != null && (resource2 = algorithm.eResource()) instanceof STAlgorithmResource && (libraryElement = (resource = (STAlgorithmResource)resource2).getInternalLibraryElement()) instanceof SimpleFBType && STAlgorithmValidator.getAllReferencedAlgorithms(simpleFBType = (SimpleFBType)libraryElement).noneMatch(reference -> reference.equalsIgnoreCase(name))) {
            this.addIssue(MessageFormat.format(Messages.STAlgorithmValidator_UnusedAlgorithm, name), (EObject)algorithm, (EStructuralFeature)LibraryElementPackage.eINSTANCE.getINamedElement_Name(), UNUSED_ALGORITHM, new String[]{name});
        }
    }

    private static Stream<String> getAllReferencedAlgorithms(SimpleFBType simpleFBType) {
        return STAlgorithmValidator.getAllECActions(simpleFBType).map(SimpleECAction::getAlgorithm).filter(Objects::nonNull);
    }

    private static Stream<SimpleECAction> getAllECActions(SimpleFBType simpleFBType) {
        return simpleFBType.getSimpleECStates().stream().map(SimpleECState::getSimpleECActions).flatMap(Collection::stream);
    }
}

