/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editors;

import java.util.List;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.utilities.CellEditorLayoutFactory;
import org.eclipse.fordiac.ide.model.edit.providers.ResultListLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.typelibrary.PaletteFilter;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewInstanceCellEditor
extends TextCellEditor {
    private static final int NUM_COLUMNS = 2;
    private Composite container;
    private Button menuButton;
    protected Shell popupShell;
    protected TableViewer tableViewer;
    private PaletteFilter paletteFilter;
    private boolean blockTableSelection = false;
    private TypeEntry selectedEntry = null;
    protected Text textControl;
    private ResultListLabelProvider resultListLabelProvider;

    public NewInstanceCellEditor(Composite parent) {
        super(parent, 896);
    }

    public Button getMenuButton() {
        return this.menuButton;
    }

    public void setTypeLibrary(TypeLibrary typeLib, FBNetwork hostNetwork) {
        this.paletteFilter = new PaletteFilter(typeLib, hostNetwork);
    }

    protected Control createControl(Composite parent) {
        this.container = this.createContainer(parent);
        this.textControl = (Text)super.createControl(this.container);
        this.configureTextControl();
        this.createTypeMenuButton(this.container);
        this.createPopUpList(this.container);
        this.updateSelectionList();
        return this.container;
    }

    public Text getText() {
        return this.text;
    }

    public void focusLost() {
        if (!this.insideAnyEditorArea()) {
            this.fireCancelEditor();
        }
    }

    public void fireCancelEditor() {
        super.fireCancelEditor();
    }

    public void deactivate() {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.popupShell.setVisible(false);
        }
        super.deactivate();
    }

    protected void handleDefaultSelection(SelectionEvent event) {
        if (!((Text)event.getSource()).getText().isEmpty()) {
            super.handleDefaultSelection(event);
        }
    }

    public Object doGetValue() {
        if (this.selectedEntry != null) {
            return this.selectedEntry;
        }
        return super.doGetValue();
    }

    public boolean insideAnyEditorArea() {
        Point cursorLocation = this.popupShell.getDisplay().getCursorLocation();
        Point containerRelativeCursor = this.container.getParent().toControl(cursorLocation);
        return this.container.getBounds().contains(containerRelativeCursor) || this.popupShell.getBounds().contains(cursorLocation);
    }

    protected Composite createContainer(Composite parent) {
        Composite newContainer = new Composite(parent, 0){

            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                Point screenPos = this.getParent().toDisplay(this.getLocation());
                Rectangle compositeBounds = this.getBounds();
                NewInstanceCellEditor.this.popupShell.setBounds(screenPos.x, screenPos.y + compositeBounds.height, compositeBounds.width, 150);
                if (!NewInstanceCellEditor.this.popupShell.isVisible()) {
                    NewInstanceCellEditor.this.popupShell.setVisible(true);
                }
            }
        };
        newContainer.setBackground(parent.getBackground());
        newContainer.setForeground(parent.getForeground());
        newContainer.setLayout((Layout)CellEditorLayoutFactory.getNewGridZeroLayout(2));
        return newContainer;
    }

    public void configureTextControl() {
        this.textControl.setLayoutData((Object)new GridData(4, 128, true, true));
        this.textControl.setMessage(Messages.NewInstanceCellEditor_SearchForType);
        this.textControl.addListener(24, event -> this.updateSelectionList());
        this.textControl.addListener(1, event -> this.handleKeyPress(event, this.textControl));
    }

    protected void updateSelectionList() {
        this.blockTableSelection = true;
        if (this.textControl.getText().length() >= 2) {
            List entries = this.paletteFilter.findFBAndSubappTypes(this.textControl.getText());
            this.resultListLabelProvider.setSearchString(this.textControl.getText());
            this.tableViewer.setInput((Object)entries);
            if (!entries.isEmpty()) {
                this.selectItemAtIndex(0);
            }
            this.markDirty();
        } else {
            this.tableViewer.setInput(null);
        }
        this.blockTableSelection = false;
    }

    private void handleKeyPress(Event event, Text textControl) {
        switch (event.keyCode) {
            case 0x1000002: {
                if (this.tableViewer.getTable().getItemCount() > 0) {
                    int index = (this.tableViewer.getTable().getSelectionIndex() + 1) % this.tableViewer.getTable().getItemCount();
                    this.selectItemAtIndex(index);
                }
                event.doit = false;
                break;
            }
            case 0x1000001: {
                if (this.tableViewer.getTable().getItemCount() > 0) {
                    int index = this.tableViewer.getTable().getSelectionIndex() - 1;
                    if (index < 0) {
                        index = this.tableViewer.getTable().getItemCount() - 1;
                    }
                    this.selectItemAtIndex(index);
                }
                event.doit = false;
                break;
            }
            case 13: {
                if (this.popupShell.isVisible() && this.tableViewer.getTable().getSelectionIndex() != -1) {
                    this.selectedEntry = (TypeEntry)this.tableViewer.getStructuredSelection().getFirstElement();
                    textControl.setText(this.selectedEntry.getTypeName());
                    break;
                }
                event.doit = false;
                break;
            }
        }
    }

    private void selectItemAtIndex(int index) {
        this.blockTableSelection = true;
        Object element = this.tableViewer.getElementAt(index);
        this.tableViewer.setSelection((ISelection)new StructuredSelection(element), true);
        this.blockTableSelection = false;
    }

    private void createPopUpList(Composite container) {
        this.popupShell = new Shell(container.getShell(), 540680);
        this.popupShell.setLayout((Layout)new FillLayout());
        this.tableViewer = new TableViewer((Composite)this.popupShell, 2820);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.resultListLabelProvider = new ResultListLabelProvider();
        DelegatingStyledCellLabelProvider delegatingStyledCellLabelProvider = new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this.resultListLabelProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)delegatingStyledCellLabelProvider);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.tableViewer.getTable().setLayout((Layout)layout);
        this.tableViewer.getControl().addListener(1, event -> {
            if (event.keyCode == 27) {
                this.fireCancelEditor();
            }
        });
        this.tableViewer.addSelectionChangedListener(event -> {
            if (!this.blockTableSelection) {
                this.selectedEntry = (TypeEntry)this.tableViewer.getStructuredSelection().getFirstElement();
                this.fireApplyEditorValue();
            }
        });
    }

    private void createTypeMenuButton(Composite container) {
        this.menuButton = new Button(container, 0x800000);
        this.menuButton.setImage(FordiacImage.ICON_TYPE_NAVIGATOR.getImage());
    }
}

