/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl;

import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.rcp.ui.contentmergeviewer.accessor.IStructuralFeatureAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl.FeatureMapKeyChangeAccessorImpl;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl.ResourceContentsAccessorImpl;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.impl.AbstractTableOrTreeMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TableMergeViewer
extends AbstractTableOrTreeMergeViewer {
    private TableViewer fTableViewer;
    private InfoViewer fInfoViewer;

    public TableMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side, ICompareColor.Provider colorProvider, IEMFCompareConfiguration compareConfiguration) {
        super(parent, side, colorProvider, compareConfiguration);
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = -1;
        layout.marginRight = -1;
        layout.marginTop = -1;
        layout.marginBottom = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fInfoViewer = new InfoViewer(composite, this.getSide());
        this.fInfoViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.fTableViewer = new TableViewer(composite, 66306);
        this.fTableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        return composite;
    }

    public final int getVerticalOffset() {
        return this.fInfoViewer.getControl().getSize().y - 2;
    }

    public final TableViewer getStructuredViewer() {
        return this.fTableViewer;
    }

    @Override
    public void setContentProvider(IContentProvider contentProvider) {
        super.setContentProvider(contentProvider);
        this.fInfoViewer.setContentProvider(contentProvider);
    }

    @Override
    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        super.setLabelProvider(labelProvider);
        this.fInfoViewer.setLabelProvider(labelProvider);
    }

    @Override
    protected void hookDispose() {
        this.fTableViewer = null;
        this.fInfoViewer = null;
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.fTableViewer.setInput(input);
        this.fInfoViewer.setInput(input);
        ((Composite)this.getControl()).layout(true);
    }

    @Override
    public void refresh() {
        this.fInfoViewer.refresh();
        this.fTableViewer.refresh();
    }

    private static class InfoViewer
    extends ContentViewer {
        private final IMergeViewer.MergeViewerSide fSide;
        private final Composite fControl;
        private final Label fEObjectIcon;
        private final Label fEObjectLabel;
        private final Label fFeatureIcon;
        private final Label fFeatureLabel;
        private ISelection fSelection;
        private Object fInput;

        public InfoViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
            this.fControl = new Composite(parent, 2048);
            this.fSide = side;
            this.fControl.setBackground(parent.getDisplay().getSystemColor(25));
            GridLayout layout = new GridLayout(3, false);
            layout.verticalSpacing = 0;
            layout.horizontalSpacing = 0;
            layout.marginLeft = 1;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.marginBottom = 0;
            this.fControl.setLayout((Layout)layout);
            Composite eObjectComposite = new Composite(this.fControl, 0);
            GridLayout eObjectCompositelayout = new GridLayout(2, false);
            eObjectCompositelayout.verticalSpacing = 0;
            eObjectCompositelayout.horizontalSpacing = 0;
            eObjectCompositelayout.marginLeft = 0;
            eObjectCompositelayout.marginHeight = 0;
            eObjectCompositelayout.marginWidth = 0;
            eObjectCompositelayout.marginBottom = 0;
            eObjectComposite.setLayout((Layout)eObjectCompositelayout);
            this.fEObjectIcon = new Label(eObjectComposite, 0);
            this.fEObjectIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.fEObjectLabel = new Label(eObjectComposite, 0);
            this.fEObjectLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            eObjectComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 3, 1));
            Label lblIn = new Label(this.fControl, 0);
            lblIn.setText("    ");
            this.fFeatureIcon = new Label(this.fControl, 0);
            this.fFeatureIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.fFeatureLabel = new Label(this.fControl, 0);
            this.fFeatureLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.hookControl((Control)this.fControl);
        }

        public Control getControl() {
            return this.fControl;
        }

        protected void inputChanged(Object input, Object oldInput) {
            this.fInput = input;
            this.fControl.setRedraw(false);
            try {
                this.refresh();
            }
            finally {
                this.fControl.setRedraw(true);
            }
        }

        public ISelection getSelection() {
            return this.fSelection;
        }

        public void refresh() {
            if (this.fInput instanceof FeatureMapKeyChangeAccessorImpl) {
                FeatureMapKeyChangeAccessorImpl featureMapAccessor = (FeatureMapKeyChangeAccessorImpl)this.fInput;
                FeatureMapChange diff = featureMapAccessor.getFeatureMapChange();
                FeatureMap.Entry entry = (FeatureMap.Entry)diff.getValue();
                Object entryValue = entry.getValue();
                if (this.getLabelProvider() instanceof ILabelProvider) {
                    ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
                    this.fFeatureLabel.setText(EMFCompareRCPUIMessages.getString("TableMergeViewer.featureMapEntryKeyLabel"));
                    this.fEObjectIcon.setImage(labelProvider.getImage(entryValue));
                    this.fEObjectLabel.setText(labelProvider.getText(entryValue));
                }
                this.fControl.layout(true);
            } else if (this.fInput instanceof IStructuralFeatureAccessor) {
                IStructuralFeatureAccessor featureAccessor = (IStructuralFeatureAccessor)this.fInput;
                EObject eObject = featureAccessor.getEObject(this.fSide);
                if (eObject == null) {
                    if (this.fSide != IMergeViewer.MergeViewerSide.ANCESTOR) {
                        eObject = featureAccessor.getEObject(IMergeViewer.MergeViewerSide.ANCESTOR);
                        if (eObject == null) {
                            eObject = featureAccessor.getEObject(this.fSide.opposite());
                        }
                    } else {
                        eObject = featureAccessor.getEObject(IMergeViewer.MergeViewerSide.LEFT);
                        if (eObject == null) {
                            eObject = featureAccessor.getEObject(IMergeViewer.MergeViewerSide.RIGHT);
                        }
                    }
                }
                EStructuralFeature structuralFeature = featureAccessor.getStructuralFeature();
                if (this.getLabelProvider() instanceof ILabelProvider) {
                    ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
                    this.fFeatureIcon.setImage(labelProvider.getImage((Object)structuralFeature));
                    this.fFeatureLabel.setText(labelProvider.getText((Object)structuralFeature));
                    this.fEObjectIcon.setImage(labelProvider.getImage((Object)eObject));
                    this.fEObjectLabel.setText(labelProvider.getText((Object)eObject));
                }
                this.fControl.layout(true);
            } else if (this.fInput instanceof ResourceContentsAccessorImpl) {
                ResourceContentsAccessorImpl resourceContentAccessor = (ResourceContentsAccessorImpl)this.fInput;
                Resource resource = resourceContentAccessor.getResource(this.fSide);
                if (this.getLabelProvider() instanceof ILabelProvider) {
                    ILabelProvider labelProvider = (ILabelProvider)this.getLabelProvider();
                    this.fFeatureLabel.setText(EMFCompareRCPUIMessages.getString("TableMergeViewer.directResourceContentsLabel"));
                    this.fEObjectIcon.setImage(labelProvider.getImage((Object)resource));
                    this.fEObjectLabel.setText(labelProvider.getText((Object)resource));
                }
                this.fControl.layout(true);
            }
        }

        public void setSelection(ISelection selection, boolean reveal) {
            this.fSelection = selection;
        }
    }
}

