/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.gef.commands.Command;

public class DeleteInternalFBCommand
extends Command
implements ScopedCommand {
    private final BaseFBType baseFbtype;
    private final FB fbToDelete;
    private int oldIndex;

    /*
     * WARNING - void declaration
     */
    public DeleteInternalFBCommand(FB fb) {
        void baseFBtype;
        this.fbToDelete = Objects.requireNonNull(fb);
        EObject eObject = fb.eContainer();
        if (!(eObject instanceof BaseFBType)) {
            throw new IllegalArgumentException("FB to delete is not contained in BaseFBType!");
        }
        BaseFBType baseFBType = (BaseFBType)eObject;
        this.baseFbtype = baseFBtype;
    }

    public void execute() {
        this.oldIndex = this.getIndexOfFBtoDelete();
        this.removeFB();
    }

    public void redo() {
        this.removeFB();
    }

    public void undo() {
        this.getInteralFBList().add(this.oldIndex, (Object)this.fbToDelete);
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.baseFbtype);
    }

    private int getIndexOfFBtoDelete() {
        return this.getInteralFBList().indexOf((Object)this.fbToDelete);
    }

    private EList<FB> getInteralFBList() {
        return this.baseFbtype.getInternalFbs();
    }

    private void removeFB() {
        this.getInteralFBList().remove((Object)this.fbToDelete);
    }
}

